/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeRenderer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class BasisAttributeBinding<T> {
    private Listener controlListener;
    CommandStackListener commandStackListener;
    EditingDomain editingDomain;
    final BasisAttributeRenderer<T> renderer;

    public BasisAttributeBinding(BasisAttributeRenderer<T> renderer) {
        this.renderer = renderer;
    }

    public void bind() {
        this.renderer.updateControl();
        this.controlListener = event -> this.renderer.updateModel();
        Control control = this.renderer.getControl();
        control.addListener(24, this.controlListener);
        this.commandStackListener = event -> {
            if (!this.renderer.isDisposed()) {
                this.renderer.updateControl();
            }
        };
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.renderer.getParent());
        this.editingDomain.getCommandStack().addCommandStackListener(this.commandStackListener);
        control.addDisposeListener(e -> this.editingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener));
    }

    public void unbind() {
        Control control = this.renderer.getControl();
        if (!control.isDisposed()) {
            control.removeListener(24, this.controlListener);
        }
        this.editingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener);
    }
}

