/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.table;

public final class Coordinate
implements Comparable<Coordinate> {
    public static final Coordinate ZERO = new Coordinate(0, 0);
    public final int col;
    public final int row;

    public Coordinate(int col, int row) {
        if (col < 0) {
            throw new IllegalArgumentException("Column is negative");
        }
        if (row < 0) {
            throw new IllegalArgumentException("Row is negative");
        }
        this.col = col;
        this.row = row;
    }

    public Coordinate offset(int cols, int rows) {
        return new Coordinate(this.col + cols, this.row + rows);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (Coordinate.class != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        return this.col == other.col && this.row == other.row;
    }

    @Override
    public int compareTo(Coordinate o) {
        int result = this.row - o.row;
        if (result == 0) {
            return this.col - o.col;
        }
        return result;
    }

    public String toString() {
        return "[" + this.col + "," + this.row + "]";
    }
}

