/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.OMLogger;

public abstract class AbstractLogHandler
implements OMLogHandler {
    private OMLogger.Level logLevel;

    public AbstractLogHandler(OMLogger.Level logLevel) {
        this.logLevel = logLevel;
    }

    public AbstractLogHandler() {
        this(OMLogger.Level.DEBUG);
    }

    public OMLogger.Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(OMLogger.Level logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void logged(OMLogger logger, OMLogger.Level level, String msg, Throwable t) {
        try {
            if (level.ordinal() <= this.logLevel.ordinal()) {
                this.writeLog(logger, level, msg, t);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected abstract void writeLog(OMLogger var1, OMLogger.Level var2, String var3, Throwable var4) throws Throwable;

    public static String toString(OMLogger.Level level) {
        switch (level) {
            case ERROR: {
                return "[ERROR]";
            }
            case WARN: {
                return "[WARN]";
            }
            case INFO: {
                return "[INFO]";
            }
            case DEBUG: {
                return "[DEBUG]";
            }
        }
        throw new IllegalArgumentException("Illegal log level: " + (Object)((Object)level));
    }
}

