/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.parts;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.set.basis.ProblemMessage;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.version.PlanProVersionService;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.feature.validation.report.SessionToValidationReportTransformation;
import org.eclipse.set.feature.validation.table.ValidationTableView;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.validationreport.ValidationReport;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SaveAndRefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.emfforms.AbstractEmfFormsPart;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ValidationPart
extends AbstractEmfFormsPart {
    private static final int BUTTON_WIDTH_EXPORT_VALIDATION = 30;
    private static final String VIEW_VALIDATION_REPORT = "validationReport";
    private static final String INJECT_VIEW_VALIDATION_NATTABLE = "validationTableNattable";
    private Exception createException;
    @Inject
    private ToolboxPartService toolboxPartService;
    @Inject
    private TableMenuService tableMenuService;
    private SessionToValidationReportTransformation transformation;
    private ValidationReport validationReport;
    private ValidationTableView tableView;
    private Button exportValidationButton;
    @Inject
    private PlanProVersionService versionService;
    @Inject
    EnumTranslationService enumTranslationService;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    @Inject
    CacheService cacheService;
    @Inject
    UserConfigurationService userConfigService;
    private Listener resizeListener;
    private Composite resizeListenerObject;

    @Inject
    public ValidationPart() {
    }

    protected void createFormsView(Composite parent) {
        Shell shell = this.getToolboxShell();
        MPart part = this.getToolboxPart();
        DialogService dialogService = this.getDialogService();
        dialogService.showProgressUISync(shell, this.messages.ProgressMsg, () -> this.create(parent));
        if (this.createException != null) {
            dialogService.error(shell, this.createException);
            MApplicationElementExtensions.setViewState((MApplicationElement)part, (ToolboxViewState)ToolboxViewState.ERROR);
        }
        if (this.getModelSession().isDirty()) {
            this.setOutdated(true);
        }
    }

    private void create(Composite parent) {
        try {
            this.transformation = new SessionToValidationReportTransformation(this.messages, this.versionService, this.enumTranslationService);
            this.validationReport = this.transformation.transform(this.getModelSession());
            this.storageReport();
            this.tableView = new ValidationTableView((BasePart)this, this.messages, this.tableMenuService);
            Function<Composite, Control> func = innerParent -> {
                Composite composite = new Composite(innerParent, 0);
                GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
                GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
                Control natTable = this.tableView.create((Composite)innerParent, this.validationReport);
                Button showTableButton = new Button(composite, 8);
                GridDataFactory.swtDefaults().align(16384, 4).grab(false, false).applyTo((Control)showTableButton);
                showTableButton.setText(this.messages.ShowValidationTableMsg);
                showTableButton.addListener(13, event -> this.showValidationTable());
                showTableButton.setSize(30, 0);
                Button collapseAllButton = this.tableView.createExpandCollapseAllButton(composite, this.messages.ValidationTable_ExpandAllGroup, this.messages.ValidationTable_CollapseAllGroup);
                this.exportValidationButton = new Button(composite, 8);
                GridDataFactory.swtDefaults().align(131072, 4).grab(true, false).applyTo((Control)this.exportValidationButton);
                this.exportValidationButton.setText(this.messages.ExportValidationMsg);
                this.exportValidationButton.addListener(13, event -> this.tableView.exportCsv());
                this.exportValidationButton.setSize(30, 0);
                showTableButton.setLayoutData((Object)new GridData(16384, 128, false, true));
                collapseAllButton.setLayoutData((Object)new GridData(16384, 128, false, true));
                this.exportValidationButton.setLayoutData((Object)new GridData(131072, 128, true, true));
                GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(-1, 600).applyTo(natTable);
                return natTable;
            };
            this.modelService.put(INJECT_VIEW_VALIDATION_NATTABLE, func);
            ScrolledComposite viewComposite = new ScrolledComposite(parent, 512);
            viewComposite.setLayout((Layout)new GridLayout());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewComposite);
            this.createEmfFormsPart((Composite)viewComposite, (EObject)this.validationReport, VIEW_VALIDATION_REPORT);
            viewComposite.setContent(this.getView().getSWTControl());
            this.updateButtonStates();
            this.resizeListenerObject = parent;
            this.resizeListener = event -> {
                Point size = this.getView().getSWTControl().computeSize(-1, -1);
                Rectangle bounds = parent.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                bounds.width = (int)((double)bounds.width * 0.98 - 25.0);
                bounds.height = (int)Math.max((double)bounds.height - 25.0, (double)size.y * 0.9);
                this.getView().getSWTControl().setBounds(bounds);
            };
            parent.addListener(11, this.resizeListener);
            this.createException = null;
        }
        catch (Exception e) {
            this.createException = e;
        }
    }

    private void storageReport() {
        Cache cache = this.cacheService.getCache(ToolboxFileRole.SESSION, "toolbox.cache.problem-message");
        List problems = (List)cache.get(VIEW_VALIDATION_REPORT, ArrayList::new);
        problems.clear();
        this.validationReport.getProblems().stream().filter(problem -> problem.getSeverity() != ValidationSeverity.SUCCESS).forEach(problem -> {
            boolean bl = problems.add(new ProblemMessage(problem.getMessage(), problem.getType(), problem.getLineNumber(), 3, problem.getObjectState().getLiteral()));
        });
        this.getBroker().post("modelsession/change/problems", null);
    }

    void showValidationTable() {
        this.toolboxPartService.showPart("org.eclipse.set.feature.validation.parts.ValidationTablePart");
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.updateValidationView();
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.updateValidationView();
    }

    private void updateValidationView() {
        if (this.isOutdated()) {
            this.getModelSession().refreshValidation();
            this.validationReport = this.transformation.transform(this.getModelSession());
            this.storageReport();
            this.setOutdated(false);
            this.updateButtonStates();
            this.tableView.updateView(this.validationReport);
        }
    }

    private void updateButtonStates() {
        this.exportValidationButton.setEnabled(!this.validationReport.getProblems().isEmpty());
    }

    protected SelectableAction getOutdatedAction() {
        return new SaveAndRefreshAction((BasePart)this);
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    @PreDestroy
    private void preDestroy() {
        if (this.resizeListenerObject != null && !this.resizeListenerObject.isDisposed()) {
            this.resizeListenerObject.removeListener(16, this.resizeListener);
        }
        this.dispose();
    }
}

