/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class Tag {
    private static final String CLOSING_PATTERN1 = "^<\\s*/.*";
    private static final String CLOSING_PATTERN2 = ".*/\\s*>$";
    private static final int NAME_GROUP = 1;
    private static final Pattern NAME_PATTERN = Pattern.compile("<\\s*[/?]?\\s*([^ \\t\\n\\x0B\\f\\r>/\\?]+).*");
    private static final String OPENING_PATTERN = "^<\\s*[^/].*";
    private final int endLineOffset;
    private final boolean isClosing;
    private final boolean isOpening;
    private final int line;
    private final int lineOffset;
    private final String name;
    private final String text;

    private static String findName(String text) {
        Matcher matcher = NAME_PATTERN.matcher(text);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException(text);
    }

    private static boolean isClosing(String text) {
        return text.matches(CLOSING_PATTERN1) || text.matches(CLOSING_PATTERN2);
    }

    private static boolean isOpening(String text) {
        return text.matches(OPENING_PATTERN);
    }

    public Tag(IDocument document, IRegion region) throws BadLocationException {
        this.text = document.get(region.getOffset(), region.getLength());
        this.line = document.getLineOfOffset(region.getOffset());
        this.lineOffset = document.getLineOffset(this.line);
        this.endLineOffset = this.lineOffset + document.getLineLength(this.line);
        this.name = Tag.findName(this.text);
        this.isOpening = Tag.isOpening(this.text);
        this.isClosing = Tag.isClosing(this.text);
    }

    public int getEndLineOffset() {
        return this.endLineOffset;
    }

    public int getLine() {
        return this.line;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public boolean isOpening() {
        return this.isOpening;
    }
}

