/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.ContinuedFractionHelper;
import org.apfloat.RoundingHelper;
import org.apfloat.spi.Util;

public class AprationalMath {
    private AprationalMath() {
    }

    public static Aprational pow(Aprational x, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            if (x.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apint(1L, x.radix());
        }
        if (n < 0L) {
            x = Aprational.ONE.divide(x);
            n = -n;
        }
        int b2pow = 0;
        while ((n & 1L) == 0L) {
            ++b2pow;
            n >>>= 1;
        }
        Aprational r = x;
        while ((n >>>= 1) > 0L) {
            x = x.multiply(x);
            if ((n & 1L) == 0L) continue;
            r = r.multiply(x);
        }
        while (b2pow-- > 0) {
            r = r.multiply(r);
        }
        return r;
    }

    @Deprecated
    public static Aprational negate(Aprational x) throws ApfloatRuntimeException {
        return x.negate();
    }

    public static Aprational abs(Aprational x) throws ApfloatRuntimeException {
        if (x.signum() >= 0) {
            return x;
        }
        return x.negate();
    }

    public static Aprational copySign(Aprational x, Aprational y) throws ApfloatRuntimeException {
        if (y.signum() == 0) {
            return y;
        }
        if (x.signum() != y.signum()) {
            return x.negate();
        }
        return x;
    }

    public static Aprational scale(Aprational x, long scale) throws ApfloatRuntimeException {
        if (scale >= 0L) {
            return new Aprational(ApintMath.scale(x.numerator(), scale), x.denominator());
        }
        if (scale == Long.MIN_VALUE) {
            Apint scaler = ApintMath.pow(new Apint((long)x.radix(), x.radix()), 0x4000000000000000L);
            return new Aprational(x.numerator(), x.denominator().multiply(scaler)).divide(scaler);
        }
        return new Aprational(x.numerator(), ApintMath.scale(x.denominator(), -scale));
    }

    @Deprecated
    public static Apfloat round(Aprational x, long precision, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return AprationalMath.roundToPrecision(x, precision, roundingMode);
    }

    public static Apfloat roundToPrecision(Aprational x, long precision, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToPrecision(x, precision, roundingMode);
    }

    public static Apint roundToInteger(Aprational x, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToInteger(x, roundingMode);
    }

    public static Apfloat roundToPlaces(Aprational x, long places, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToPlaces(x, places, roundingMode);
    }

    public static Aprational roundToMultiple(Aprational x, Aprational y, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToMultiple(x, y, roundingMode);
    }

    public static Aprational product(Aprational ... x) throws ApfloatRuntimeException {
        if (x.length == 0) {
            return Aprational.ONE;
        }
        Apint[] n = new Apint[x.length];
        Apint[] m = new Apint[x.length];
        for (int i = 0; i < x.length; ++i) {
            if (x[i].signum() == 0) {
                return Aprational.ZEROS[x[i].radix()];
            }
            n[i] = x[i].numerator();
            m[i] = x[i].denominator();
        }
        return new Aprational(ApintMath.product(n), ApintMath.product(m));
    }

    public static Aprational sum(Aprational ... x) throws ApfloatRuntimeException {
        if (x.length == 0) {
            return Aprational.ZERO;
        }
        x = (Aprational[])x.clone();
        Arrays.sort(x, Comparator.comparing(ApfloatHelper::size));
        return AprationalMath.recursiveSum(x, 0, x.length - 1);
    }

    public static Apint[] continuedFraction(Aprational x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Maximum number of terms is not positive");
        }
        return (Apint[])Util.stream(ContinuedFractionHelper.continuedFraction(x)).limit(n).toArray(Apint[]::new);
    }

    public static Aprational[] convergents(Aprational x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Maximum number of convergents is not positive");
        }
        Iterator<Apint> continuedFraction = ContinuedFractionHelper.continuedFraction(x);
        return (Aprational[])Util.stream(ContinuedFractionHelper.convergents(continuedFraction, x.radix())).limit(n).toArray(Aprational[]::new);
    }

    public static Aprational max(Aprational x, Aprational y) throws ApfloatRuntimeException {
        return x.compareTo(y) > 0 ? x : y;
    }

    public static Aprational min(Aprational x, Aprational y) throws ApfloatRuntimeException {
        return x.compareTo(y) < 0 ? x : y;
    }

    public static Aprational binomial(Aprational n, Aprational k) throws ArithmeticException, ApfloatRuntimeException {
        if (n.isInteger() && k.isInteger()) {
            return ApintMath.binomial(n.numerator(), k.numerator());
        }
        if (n.isInteger() && n.signum() < 0 && !k.isInteger()) {
            throw new ArithmeticException("Binomial coefficient is not finite");
        }
        if (!k.isInteger()) {
            k = n.subtract(k);
        }
        if (!k.isInteger()) {
            throw new ArithmeticException("Binomial coefficient is not a rational number");
        }
        int radix = n.radix();
        if (k.signum() < 0) {
            return Apint.ZEROS[radix];
        }
        Apint one = new Apint(1L, radix);
        return AprationalMath.pochhammer(n.subtract(k).add(one), k.numerator()).divide(ApintMath.factorial(k.longValueExact(), radix));
    }

    private static Aprational pochhammer(Aprational n, Apint m) {
        assert (m.signum() >= 0);
        Apint one = Apint.ONES[n.radix()];
        if (m.signum() == 0) {
            return one;
        }
        if (m.equals(one)) {
            return n;
        }
        Apint two = new Apint(2L, n.radix());
        Apint k = m.divide(two);
        return AprationalMath.pochhammer(n, k).multiply(AprationalMath.pochhammer(n.add(k), m.subtract(k)));
    }

    public static Aprational bernoulli(long n) throws IllegalArgumentException, ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        int radix = ctx.getDefaultRadix();
        return AprationalMath.bernoulli(n, radix);
    }

    public static Aprational bernoulli(long n, int radix) throws IllegalArgumentException, NumberFormatException, ApfloatRuntimeException {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative Bernoulli number: " + n);
        }
        if (n == 0L) {
            return Apint.ONES[radix];
        }
        if (n == 1L) {
            return new Aprational(new Apint(-1L, radix), new Apint(2L, radix));
        }
        if ((n & 1L) == 1L) {
            return Apint.ZEROS[radix];
        }
        return n <= 2000L ? AprationalMath.bernoulliSmall(n, radix) : AprationalMath.bernoulliBig(n, radix);
    }

    static Aprational bernoulliSmall(long n, int radix) {
        assert (n > 0L);
        Aprational sum = Aprational.ZERO;
        for (long k = 1L; k <= n; ++k) {
            Apint binomial = new Apint(1L, radix);
            Apint part = Apint.ZERO;
            for (long v = 1L; v <= k; ++v) {
                binomial = binomial.multiply(new Apint(k + 1L - v, radix)).divide(new Apint(v, radix));
                Apint term = binomial.multiply(ApintMath.pow(new Apint(v, radix), n));
                part = (v & 1L) == 0L ? part.add(term) : part.subtract(term);
            }
            sum = sum.add(new Aprational(part, new Apint(k + 1L, radix)));
        }
        return sum;
    }

    static Aprational bernoulliBig(long n, int radix) {
        assert (n > 1L);
        assert ((n & 1L) == 0L);
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        long p = Math.max(1L, (long)Math.ceil((double)(n >>= 1) * Math.log(n) / Math.log(radix)));
        long precision = ApfloatHelper.extendPrecision(Math.multiplyExact(Math.multiplyExact(2L, n) + 1L, p));
        Apint f2n1 = ApintMath.factorial(2L * n - 1L, radix);
        Apfloat z = ApfloatMath.scale(new Apfloat(1L, precision, radix), -p);
        Apfloat v = ApfloatMath.scale(f2n1.multiply(ApfloatMath.tan(z)), -p);
        v = ApfloatMath.scale(v, 2L * p * (n - 1L));
        v = v.frac();
        v = ApfloatMath.scale(v, 2L * p);
        Apint t = v.truncate();
        Apint two2n1 = ApintMath.pow(two, 2L * n - 1L);
        Apint two2n = two2n1.multiply(two);
        Aprational b = new Aprational(new Apint((n & 1L) == 1L ? n : -n, radix).multiply(t), two2n.subtract(one).multiply(two2n1));
        return b;
    }

    static Iterator<Aprational> bernoullis(long n, int radix) {
        return n <= 2000L ? AprationalMath.bernoullisSmall(radix) : AprationalMath.bernoullisBig(n, radix);
    }

    static Iterator<Aprational> bernoullis2(long n, int radix) {
        return n < 1000L ? AprationalMath.bernoullis2Small(radix) : AprationalMath.bernoullis2Big(n, radix);
    }

    static Iterator<Aprational> bernoullisSmall(final int radix) {
        return new Iterator<Aprational>(){
            private long n;
            private List<Aprational> all = new ArrayList<Aprational>();

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Aprational next() {
                Aprational b;
                if (this.n == 0L) {
                    b = Aprational.ONES[radix];
                } else if (this.n > 1L && (this.n & 1L) == 1L) {
                    b = Aprational.ZEROS[radix];
                } else {
                    b = Aprational.ZEROS[radix];
                    Iterator<Aprational> iterator = this.all.iterator();
                    Apint binomial = null;
                    long k = 0L;
                    while (iterator.hasNext()) {
                        binomial = k == 0L ? new Apint(1L, radix) : binomial.multiply(new Apint(this.n + 1L - k, radix)).divide(new Apint(k, radix));
                        b = b.subtract(binomial.multiply(iterator.next()).divide(new Apint(this.n - k + 1L, radix)));
                        ++k;
                    }
                }
                this.all.add(b);
                ++this.n;
                return b;
            }
        };
    }

    static Iterator<Aprational> bernoullis2Small(final int radix) {
        return new Iterator<Aprational>(){
            private Iterator<Aprational> i;
            {
                this.i = AprationalMath.bernoullisSmall(radix);
                this.i.next();
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Aprational next() {
                this.i.next();
                return this.i.next();
            }
        };
    }

    static Iterator<Aprational> bernoullisBig(final long n, final int radix) {
        return new Iterator<Aprational>(){
            private long k;
            private Iterator<Aprational> i;
            {
                this.i = AprationalMath.bernoullis2Big(n >> 1, radix);
            }

            @Override
            public boolean hasNext() {
                return this.k <= n;
            }

            @Override
            public Aprational next() {
                if (this.k > n) {
                    throw new NoSuchElementException();
                }
                Aprational b = this.k == 0L ? Aprational.ONES[radix] : (this.k == 1L ? new Aprational(new Apint(-1L, radix), new Apint(2L, radix)) : ((this.k & 1L) == 1L ? Aprational.ZEROS[radix] : this.i.next()));
                ++this.k;
                return b;
            }
        };
    }

    static Iterator<Aprational> bernoullis2Big(final long n, final int radix) {
        final Apint one = Apint.ONES[radix];
        final Apint two = new Apint(2L, radix);
        final long p = (long)Math.ceil((double)n * Math.log(n) / Math.log(radix));
        long precision = ApfloatHelper.extendPrecision(Math.multiplyExact(Math.multiplyExact(2L, n) + 1L, p));
        final Apint f2n1 = ApintMath.factorial(2L * n - 1L, radix);
        final Apfloat z = ApfloatMath.scale(new Apfloat(1L, precision, radix), -p);
        return new Iterator<Aprational>(){
            private long k = 1L;
            private Apfloat v = ApfloatMath.scale(f2n1.multiply(ApfloatMath.tan(z)), -p);
            private Apint f2k1 = one;
            private Apint two2k1 = two;
            private Apint two2k;

            @Override
            public boolean hasNext() {
                return this.k <= n;
            }

            @Override
            public Aprational next() {
                if (this.k > n) {
                    throw new NoSuchElementException();
                }
                long k = this.k;
                this.v = ApfloatMath.scale(this.v, 2L * p);
                Apint t1 = this.v.truncate();
                this.f2k1 = k == 1L ? this.f2k1 : this.f2k1.multiply(new Apint(2L * k - 1L, radix)).multiply(new Apint(2L * k - 2L, radix));
                Apint t = t1.multiply(this.f2k1).divide(f2n1);
                this.v = this.v.frac();
                this.two2k = this.two2k1.multiply(two);
                Aprational b = new Aprational(new Apint((k & 1L) == 1L ? k : -k, radix).multiply(t), this.two2k.subtract(one).multiply(this.two2k1));
                this.two2k1 = this.two2k.multiply(two);
                ++this.k;
                return b;
            }
        };
    }

    private static Aprational recursiveSum(Aprational[] x, int n, int m) throws ApfloatRuntimeException {
        if (n == m) {
            return x[n];
        }
        int k = n + m >>> 1;
        return AprationalMath.recursiveSum(x, n, k).add(AprationalMath.recursiveSum(x, k + 1, m));
    }
}

