/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl.siteplan;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.export.xsl.AbstractTransformTableHeader;
import org.eclipse.set.utils.export.xsl.XMLDocumentExtensions;
import org.eclipse.set.utils.export.xsl.XSLConstant;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanExportPage;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanXSLExtension;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanXSLPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SiteplanXSL {
    private static final String SITEPLAN_XSL_TEMPLATE = "data/export/pdf/siteplan_template.xsl";
    private static final double PAGE_WIDTH_TOLERANCE = 50.0;
    private static final List<SiteplanXSLPage> avaiablePageSize = List.of(SiteplanExportPage.getSiteplanPageA0(), SiteplanExportPage.getSiteplanPageA1(), SiteplanExportPage.getSiteplanPageA2(), SiteplanExportPage.getSiteplanPageA3());
    private Document doc;
    private Node rootNode;
    private final SiteplanXSLPage pageStyle;
    private final BufferedImage image;
    private final double ppm;
    private final int pagePosition;
    private final String pagePostfix;
    private final double customPageWidth;

    public SiteplanXSLPage getPageStyle() {
        return this.pageStyle;
    }

    public SiteplanXSL(BufferedImage image, double ppm, String modelState, int pageIndex, String pagePostfix) {
        this.image = image;
        this.ppm = ppm;
        this.pageStyle = this.determinePageStyle();
        this.pagePosition = pageIndex;
        this.pagePostfix = pagePostfix;
        this.customPageWidth = this.getCustomPageWidth();
    }

    public Document getXSLDocument() throws ParserConfigurationException, SAXException, IOException, NullPointerException, UnsupportedOperationException {
        this.doc = AbstractTransformTableHeader.parseTemplate(SITEPLAN_XSL_TEMPLATE);
        this.rootNode = this.doc.getElementsByTagName("xsl:stylesheet").item(0);
        if (this.pageStyle == null) {
            throw new UnsupportedOperationException("Es gibt kein passendes Papierformat f\u00fcr diesen Lageplan im aktuellen Layout. Bitte DPI-Zahl or Skalierungsfaktor \u00e4ndern");
        }
        return this.setPageSize((double)this.pageStyle.getPageHeight()).setRegionBodySize((SiteplanXSLExtension.RegionBody)this.pageStyle.getRegionBody()).setFreeFeldHeight((SiteplanXSLExtension.TitleBoxRegion)this.pageStyle.getTitleBoxRegion()).setSignificantSize((SiteplanXSLExtension.SignificantInformation)this.pageStyle.getSignificantInformation()).setFoldingMarkTemplates(this.pageStyle.getFoldingMarks()).setFoldingMarkRightRegionWidth(this.pageStyle.getFoldingMarks()).setPagePosition().doc;
    }

    private double getCustomPageWidth() {
        double imageWidthMilimet = SiteplanXSL.pxToMilimeter(this.image.getWidth(), this.ppm);
        Optional<SiteplanXSLPage> relevantPageWidth = avaiablePageSize.stream().filter(page -> Math.abs(page.getRegionBody().width() - imageWidthMilimet) < 50.0).findFirst();
        if (relevantPageWidth.isEmpty()) {
            return this.pageStyle.getPageWidth() + imageWidthMilimet - this.pageStyle.getRegionBody().width();
        }
        return relevantPageWidth.get().getPageWidth();
    }

    private SiteplanXSL setPageSize(double pageHeight) throws NullPointerException {
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:attribute", "page-height", pageHeight);
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:attribute", "page-width", this.customPageWidth);
        return this;
    }

    private SiteplanXSL setRegionBodySize(SiteplanXSLExtension.RegionBody regionBody) throws NullPointerException {
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "region-body-height", regionBody.height());
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "region-body-width", SiteplanXSL.pxToMilimeter(this.image.getWidth(), this.ppm));
        return this;
    }

    private SiteplanXSL setSignificantSize(SiteplanXSLExtension.SignificantInformation significant) throws NullPointerException {
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "significant-height", significant.height());
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "significant-width", significant.width());
        return this;
    }

    private SiteplanXSL setFreeFeldHeight(SiteplanXSLExtension.TitleBoxRegion titleBox) throws NullPointerException {
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "siteplan-freefeld-height", titleBox.freefeldSize());
        return this;
    }

    private SiteplanXSL setFoldingMarkTemplates(List<SiteplanXSLExtension.FoldingMark> marks) throws NullPointerException {
        List<SiteplanXSLExtension.FoldingMark> sideMarks;
        List<Double> customFolding = SiteplanXSLExtension.calculateCustomFoldingTopBottom(this.customPageWidth);
        if (customFolding != null && !customFolding.isEmpty()) {
            this.createFoldingMarkTopBottomTemplate(new SiteplanXSLExtension.FoldingMark(SiteplanXSLExtension.RegionPosition.AFTER, customFolding));
        }
        if (!(sideMarks = marks.stream().filter(mark -> mark.position() == SiteplanXSLExtension.RegionPosition.START || mark.position() == SiteplanXSLExtension.RegionPosition.END).toList()).isEmpty()) {
            this.createFoldingMarkSideTemplate(sideMarks.getFirst());
        }
        return this;
    }

    private void createFoldingMarkTopBottomTemplate(SiteplanXSLExtension.FoldingMark topBottomMark) {
        Element topBottomMarkTemplate = this.getFoldingMarkTemplate("siteplan-folding-mark-top-bottom");
        Element tableElement = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.TABLE_LAYOUT, "fixed"), new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.TABLE_WIDTH, "100%"));
        topBottomMarkTemplate.appendChild(tableElement);
        Element tableBodyElement = this.doc.createElement("fo:table-body");
        Element tableRow = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-row", new XMLDocumentExtensions.XMLAttribute("height", topBottomMark.markWidth()));
        tableBodyElement.appendChild(tableRow);
        IntStream.range(0, topBottomMark.distances().size()).forEach(index -> {
            Double distance = topBottomMark.distances().get(index);
            Element tableColumn = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-column", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.COLUMN_WIDTH, distance));
            tableElement.appendChild(tableColumn);
            Element tableCell = topBottomMark.distances().size() - 1 == index ? this.doc.createElement("fo:table-cell") : XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-cell", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.BorderDirection.RIGHT.getDirectionString(), "0.5mm solid black"));
            tableRow.appendChild(tableCell);
            Element tableCellBlock = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:block", new XMLDocumentExtensions.XMLAttribute("color", "white"));
            tableCellBlock.setTextContent(".");
            tableCell.appendChild(tableCellBlock);
        });
        tableElement.appendChild(tableBodyElement);
    }

    private void createFoldingMarkSideTemplate(SiteplanXSLExtension.FoldingMark sideMark) {
        if (sideMark.distances().isEmpty()) {
            return;
        }
        Element sideMarkTemplate = this.getFoldingMarkTemplate("siteplan-folding-mark-side");
        Element tableElement = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.TABLE_LAYOUT, "fixed"), new XMLDocumentExtensions.XMLAttribute("width", "100%"));
        sideMarkTemplate.appendChild(tableElement);
        Element tableColumn = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-column", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.COLUMN_WIDTH, sideMark.markWidth()));
        tableElement.appendChild(tableColumn);
        Element tableBodyElement = this.doc.createElement("fo:table-body");
        tableElement.appendChild(tableBodyElement);
        IntStream.range(0, sideMark.distances().size()).forEach(index -> {
            Double distance = sideMark.distances().get(index);
            Element tableRow = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-row", new XMLDocumentExtensions.XMLAttribute("height", distance));
            tableBodyElement.appendChild(tableRow);
            Element tableCell = sideMark.distances().size() - 1 == index ? this.doc.createElement("fo:table-cell") : XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-cell", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.BorderDirection.BOTTOM.getDirectionString(), "0.5mm solid black"));
            tableRow.appendChild(tableCell);
            Element tableCellBlock = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:block", new XMLDocumentExtensions.XMLAttribute("color", "white"));
            tableCellBlock.setTextContent(".");
            tableCell.appendChild(tableCellBlock);
        });
    }

    private Element getFoldingMarkTemplate(String templateName) {
        Element foldingMarkTemplate = AbstractTransformTableHeader.findNodebyTagName(this.doc, "xsl:template", "name", templateName).orElse(null);
        if (foldingMarkTemplate != null) {
            this.rootNode.removeChild(foldingMarkTemplate);
        }
        foldingMarkTemplate = XMLDocumentExtensions.createXMLElementWithAttrName(this.doc, "xsl:template", templateName);
        this.rootNode.appendChild(foldingMarkTemplate);
        return foldingMarkTemplate;
    }

    private SiteplanXSL setFoldingMarkRightRegionWidth(List<SiteplanXSLExtension.FoldingMark> foldingMarks) {
        SiteplanXSLExtension.FoldingMark markRight = foldingMarks.stream().filter(mark -> mark.position() == SiteplanXSLExtension.RegionPosition.END).findFirst().orElse(null);
        if (markRight != null) {
            XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "siteplan-folding-mark-right-width", markRight.extent());
        } else {
            XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "siteplan-folding-mark-right-width", 10.0);
        }
        return this;
    }

    private SiteplanXSL setPagePosition() {
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "pagePosition", String.valueOf(this.pagePosition));
        XMLDocumentExtensions.setXSLElementValue(this.doc, "xsl:variable", "pagePostFix", this.pagePostfix);
        return this;
    }

    private SiteplanXSLPage determinePageStyle() {
        double imgHeightMillimet = SiteplanXSL.pxToMilimeter(this.image.getHeight(), this.ppm);
        Optional<SiteplanXSLPage> xslPage = avaiablePageSize.stream().filter(page -> page.regionBody.height() >= imgHeightMillimet).min((first, second) -> Double.compare(first.regionBody.height(), second.regionBody.height()));
        if (xslPage.isPresent()) {
            return xslPage.get();
        }
        SiteplanXSLExtension.RegionBody customRegion = new SiteplanXSLExtension.RegionBody(SiteplanXSL.pxToMilimeter(this.image.getWidth(), this.ppm), imgHeightMillimet);
        double customWidth = customRegion.width() + 180.0 + 20.0 + 10.0;
        double customHeight = customRegion.height() + 20.0;
        SiteplanXSLExtension.TitleBoxRegion titleBoxRegion = new SiteplanXSLExtension.TitleBoxRegion(SiteplanXSLExtension.RegionPosition.END, 190.0, customHeight - 10.0 - 75.0);
        return new SiteplanXSLPage(customHeight, customWidth, titleBoxRegion, customRegion, Collections.emptyList(), new SiteplanXSLExtension.SignificantInformation(205.0));
    }

    public static double pxToMilimeter(double px, double ppm) {
        if (ppm <= 0.0) {
            return px * 25.4 / (double)ToolboxConfiguration.getExportDPI();
        }
        BigDecimal pixelProMillimeter = BigDecimal.valueOf(ppm).divide(BigDecimal.valueOf(1000L), 5, RoundingMode.FLOOR);
        BigDecimal toMillimeter = BigDecimal.valueOf(px).divide(pixelProMillimeter, 5, RoundingMode.FLOOR);
        return toMillimeter.divide(BigDecimal.valueOf(ToolboxConfiguration.getSiteplanExportScale()), 5, RoundingMode.FLOOR).doubleValue();
    }
}

