/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.set.basis.extensions.IDocumentExtensions;
import org.eclipse.set.basis.extensions.TagExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanProFoldingStructureProvider {
    private static final Annotation[] EMPTY = new Annotation[0];
    static final Logger LOGGER = LoggerFactory.getLogger(PlanProFoldingStructureProvider.class);
    private final UISynchronize sync;
    private final ProjectionViewer viewer;
    IDocument document;

    private static Map<Annotation, Position> getAdditions(Set<Position> positions) {
        HashMap<Annotation, Position> result = new HashMap<Annotation, Position>();
        positions.forEach(position -> {
            Position position2 = result.put((Annotation)new ProjectionAnnotation(), (Position)position);
        });
        return result;
    }

    private static Annotation[] getDeletions(ProjectionAnnotationModel model, Set<Position> positions) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof ProjectionAnnotation) || positions.remove(position = model.getPosition(annotation))) continue;
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    public PlanProFoldingStructureProvider(ProjectionViewer viewer, UISynchronize sync) {
        this.viewer = viewer;
        this.sync = sync;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void updateFoldingRegions(IRegion range) {
        ProjectionAnnotationModel model = this.viewer.getProjectionAnnotationModel();
        if (model != null) {
            try {
                this.updateFoldingRegions(model, range);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Set<Position> getFoldingPositions(IRegion range) throws BadLocationException {
        ArrayList tags = IDocumentExtensions.getTags((IDocument)this.document, (IRegion)range);
        LOGGER.debug("Found " + tags.size() + " tags.");
        Set positions = TagExtensions.getFoldingPositions((ArrayList)tags);
        return positions;
    }

    void updateFoldingRegions(ProjectionAnnotationModel model, IRegion range) throws BadLocationException {
        LOGGER.debug("Start updateFoldingRegions...");
        Set<Position> positions = this.getFoldingPositions(range);
        LOGGER.debug("Found " + positions.size() + " positions.");
        Annotation[] deletions = PlanProFoldingStructureProvider.getDeletions(model, positions);
        Map<Annotation, Position> additions = PlanProFoldingStructureProvider.getAdditions(positions);
        if (deletions.length != 0 || !additions.isEmpty()) {
            this.sync.asyncExec(() -> model.modifyAnnotations(deletions, additions, EMPTY));
        }
    }
}

