/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.Routing;
import org.eclipse.set.model.planpro.Ansteuerung_Element.AEA_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung_Art_TypeClass;
import org.eclipse.set.model.planpro.Ansteuerung_Element.ENUMAussenelementansteuerungArt;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stellelement;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Unterbringung;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Km_Massgebend_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_Strecke_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Strecke_Km_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Rangier_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.model.planpro.Flankenschutz.Fla_Schutz;
import org.eclipse.set.model.planpro.Flankenschutz.Fla_Schutz_Signal_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.Bezeichnung_Strecke_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.Strecke_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Gleis.Gleis_Bezeichnung;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente;
import org.eclipse.set.model.planpro.Ortung.Schaltmittel_Zuordnung;
import org.eclipse.set.model.planpro.Signalbegriffe_Ril_301.Zs3v;
import org.eclipse.set.model.planpro.Signalbegriffe_Struktur.Signalbegriff_ID_TypeClass;
import org.eclipse.set.model.planpro.Signale.ENUMFiktivesSignalFunktion;
import org.eclipse.set.model.planpro.Signale.ENUMSignalFunktion;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Signale.Signal_Befestigung;
import org.eclipse.set.model.planpro.Signale.Signal_Fstr_Aus_Inselgleis_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Fstr_S_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Funktion_TypeClass;
import org.eclipse.set.model.planpro.Signale.Signal_Rahmen;
import org.eclipse.set.model.planpro.Signale.Signal_Real_Aktiv_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Signalbegriff;
import org.eclipse.set.model.planpro.Verweise.ID_Aussenelementansteuerung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Grenzzeichen_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Signal_Befestigung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Signal_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Stellelement_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Strecke_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Ziel_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Zweites_Haltfallkriterium_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.AussenelementansteuerungExtensions;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.FahrwegExtensions;
import org.eclipse.set.ppmodel.extensions.FmaKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.FstrFahrwegExtensions;
import org.eclipse.set.ppmodel.extensions.FstrZugRangierExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.set.ppmodel.extensions.StellelementExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.DirectedTopKante;
import org.eclipse.set.ppmodel.extensions.utils.TopGraph;
import org.eclipse.set.ppmodel.extensions.utils.TopRouting;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalExtensions
extends PunktObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(SignalExtensions.class);
    private static final BigDecimal ABSTAND_VORSIGNALBAKE = BigDecimal.valueOf(260L);
    private static final String PREFIX_VORSIGNALBAKE = "Ne3";
    private static final double tolerantDistance = 1.0;

    public static List<Fla_Schutz> flaSchutz(Signal signal) {
        Functions.Function1 _function = it -> {
            boolean _tripleNotEquals;
            boolean _and = false;
            Fla_Schutz_Signal_AttributeGroup _flaSchutzSignal = it.getFlaSchutzSignal();
            boolean bl = _tripleNotEquals = _flaSchutzSignal != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _equals;
                ID_Signal_TypeClass _iDFlaSignal = it.getFlaSchutzSignal().getIDFlaSignal();
                String _wert = null;
                if (_iDFlaSignal != null) {
                    _wert = _iDFlaSignal.getWert();
                }
                String _wert_1 = signal.getIdentitaet().getWert();
                _and = _equals = Objects.equals(_wert, _wert_1);
            }
            return _and;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFlaSchutz(), (Functions.Function1)_function));
    }

    public static boolean isStartOfAnyTrainRoute(Signal signal) {
        if (signal == null) {
            return false;
        }
        Functions.Function1 _function = it -> {
            Fstr_Zug_AttributeGroup _fstrZug;
            boolean _tripleNotEquals;
            boolean _tripleEquals;
            boolean _and = false;
            Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(it);
            Signal _start = null;
            if (_fstrFahrweg != null) {
                _start = FahrwegExtensions.getStart(_fstrFahrweg);
            }
            boolean bl = _tripleEquals = _start == signal;
            _and = !_tripleEquals ? false : (_tripleNotEquals = (_fstrZug = it.getFstrZug()) != null);
            return _and;
        };
        return IterableExtensions.exists((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFstrZugRangier(), (Functions.Function1)_function);
    }

    public static boolean isStartOrDestinationOfAnyTrainRoute(Signal signal) {
        Functions.Function1 _function = it -> {
            Fstr_Zug_AttributeGroup _fstrZug = it.getFstrZug();
            return _fstrZug != null;
        };
        Functions.Function1 _function_1 = it -> {
            boolean _tripleEquals;
            boolean _or = false;
            Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(it);
            Signal _start = null;
            if (_fstrFahrweg != null) {
                _start = FahrwegExtensions.getStart(_fstrFahrweg);
            }
            boolean bl = _tripleEquals = _start == signal;
            if (_tripleEquals) {
                _or = true;
            } else {
                boolean _tripleEquals_1;
                Fstr_Fahrweg _fstrFahrweg_1 = FstrZugRangierExtensions.getFstrFahrweg(it);
                Signal _zielSignal = null;
                if (_fstrFahrweg_1 != null) {
                    _zielSignal = FahrwegExtensions.getZielSignal(_fstrFahrweg_1);
                }
                _or = _tripleEquals_1 = _zielSignal == signal;
            }
            return _or;
        };
        return IterableExtensions.exists((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFstrZugRangier(), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public static boolean isStartOrDestinationOfAnyShuntingRoute(Signal signal, boolean isStart) {
        Iterable _fstrZugRangier = BasisAttributExtensions.getContainer((EObject)signal).getFstrZugRangier();
        for (Fstr_Zug_Rangier zugRangier : _fstrZugRangier) {
            boolean _equals;
            boolean _tripleNotEquals;
            String IDEnd = null;
            if (isStart) {
                Fstr_Fahrweg _fstrFahrweg = null;
                if (zugRangier != null) {
                    _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(zugRangier);
                }
                ID_Signal_TypeClass _iDStart = null;
                if (_fstrFahrweg != null) {
                    _iDStart = _fstrFahrweg.getIDStart();
                }
                Signal _value = null;
                if (_iDStart != null) {
                    _value = _iDStart.getValue();
                }
                Identitaet_TypeClass _identitaet = null;
                if (_value != null) {
                    _identitaet = _value.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                IDEnd = _wert;
            } else {
                Fstr_Fahrweg _fstrFahrweg_1 = null;
                if (zugRangier != null) {
                    _fstrFahrweg_1 = FstrZugRangierExtensions.getFstrFahrweg(zugRangier);
                }
                ID_Ziel_TypeClass _iDZiel = null;
                if (_fstrFahrweg_1 != null) {
                    _iDZiel = _fstrFahrweg_1.getIDZiel();
                }
                Basis_Objekt _value_1 = null;
                if (_iDZiel != null) {
                    _value_1 = _iDZiel.getValue();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (_value_1 != null) {
                    _identitaet_1 = _value_1.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                IDEnd = _wert_1;
            }
            boolean _and = false;
            Fstr_Rangier_AttributeGroup _fstrRangier = null;
            if (zugRangier != null) {
                _fstrRangier = zugRangier.getFstrRangier();
            }
            if (!(_and = !(_tripleNotEquals = _fstrRangier != null) ? false : (_equals = signal.getIdentitaet().getWert().equals(IDEnd)))) continue;
            return true;
        }
        return false;
    }

    public static List<Signal_Rahmen> signalRahmen(Signal signal) {
        Functions.Function1 _function = r -> {
            Signal _signal = SignalRahmenExtensions.getSignal(r);
            return Objects.equals(_signal, signal);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getSignalRahmen(), (Functions.Function1)_function));
    }

    public static boolean isAlleinstehendesZusatzsignal(Signal signal) {
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Funktion_TypeClass _signalFunktion = null;
        if (_signalReal != null) {
            _signalFunktion = _signalReal.getSignalFunktion();
        }
        ENUMSignalFunktion _wert = null;
        if (_signalFunktion != null) {
            _wert = _signalFunktion.getWert();
        }
        ENUMSignalFunktion signalFunktion = _wert;
        Set<Signal_Signalbegriff> signalbegriffe = SignalExtensions.getSignalbegriffe(signal);
        return signalFunktion == ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_ALLEINSTEHENDES_ZUSATZSIGNAL && SignalbegriffExtensions.containsSignalbegriffID(signalbegriffe, Zs3v.class);
    }

    public static boolean isInWirkrichtungOfSignal(TopGraph topGraph, Signal signal, Punkt_Objekt object) {
        return SignalExtensions.isInWirkrichtungOfSignal(topGraph, signal, PunktObjektExtensions.getSinglePoints(object));
    }

    public static boolean isInWirkrichtungOfSignal(TopGraph topGraph, Signal signal, TOP_Kante topKante) {
        Functions.Function1 _function = it -> it == topKante;
        boolean _exists = IterableExtensions.exists(PunktObjektExtensions.getTopKanten((Punkt_Objekt)signal), (Functions.Function1)_function);
        if (_exists) {
            return false;
        }
        List<Punkt_Objekt_TOP_Kante_AttributeGroup> allPunktOnTopKante = TopKanteExtensions.getConnected(topKante);
        Functions.Function2 _function_1 = (p1, p2) -> {
            BigDecimal _abstand_1;
            Punkt_Objekt_TOP_Kante_AttributeGroup _xifexpression = null;
            BigDecimal _abstand = TopKanteExtensions.getAbstand(topKante, TopKanteExtensions.getTOPKnotenA(topKante), p1);
            boolean _lessThan = _abstand.compareTo(_abstand_1 = TopKanteExtensions.getAbstand(topKante, TopKanteExtensions.getTOPKnotenA(topKante), p2)) < 0;
            _xifexpression = _lessThan ? p1 : p2;
            return _xifexpression;
        };
        Punkt_Objekt_TOP_Kante_AttributeGroup punktNearstA = (Punkt_Objekt_TOP_Kante_AttributeGroup)IterableExtensions.reduce(allPunktOnTopKante, (Functions.Function2)_function_1);
        Functions.Function2 _function_2 = (p1, p2) -> {
            BigDecimal _abstand_1;
            Punkt_Objekt_TOP_Kante_AttributeGroup _xifexpression = null;
            BigDecimal _abstand = TopKanteExtensions.getAbstand(topKante, TopKanteExtensions.getTOPKnotenB(topKante), p1);
            boolean _lessThan = _abstand.compareTo(_abstand_1 = TopKanteExtensions.getAbstand(topKante, TopKanteExtensions.getTOPKnotenB(topKante), p2)) < 0;
            _xifexpression = _lessThan ? p1 : p2;
            return _xifexpression;
        };
        Punkt_Objekt_TOP_Kante_AttributeGroup punkNearstB = (Punkt_Objekt_TOP_Kante_AttributeGroup)IterableExtensions.reduce(allPunktOnTopKante, (Functions.Function2)_function_2);
        return SignalExtensions.isInWirkrichtungOfSignal(topGraph, signal, List.of(punktNearstA)) && SignalExtensions.isInWirkrichtungOfSignal(topGraph, signal, List.of(punkNearstB));
    }

    public static boolean isInWirkrichtungOfSignal(TopGraph topGraph, Signal signal, List<Punkt_Objekt_TOP_Kante_AttributeGroup> potks) {
        Functions.Function1 _function = it -> it.getEdges();
        Iterable relevantPaths = IterableExtensions.flatMap((Iterable)Digraphs.getPaths((Digraph)topGraph, PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signal), potks), (Functions.Function1)_function);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)relevantPaths);
        if (_isNullOrEmpty) {
            return false;
        }
        Functions.Function1 _function_1 = it -> PunktObjektExtensions.getTopKanten((Punkt_Objekt)signal).contains(it.getElement());
        Functions.Function1 _function_2 = it -> {
            ENUMWirkrichtung wirkrichtung = PunktObjektExtensions.getWirkrichtung((Punkt_Objekt)signal, (TOP_Kante)it.getElement());
            if (wirkrichtung == null) {
                return it.isForwards();
            }
            boolean _matched = false;
            if (Objects.equals(wirkrichtung, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN)) {
                _matched = true;
                boolean _isForwards = it.isForwards();
                return _isForwards;
            }
            if (!_matched && Objects.equals(wirkrichtung, 0)) {
                _matched = true;
                return true;
            }
            if (!_matched && Objects.equals(wirkrichtung, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN)) {
                _matched = true;
                boolean _isForwards_1 = it.isForwards();
                return !_isForwards_1;
            }
            throw new IllegalArgumentException();
        };
        return IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)relevantPaths, (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }

    public static List<Signal_Rahmen> signalRahmenForBefestigung(Signal signal, Iterable<Signal_Befestigung> gruppe) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                Identitaet_TypeClass _identitaet = it_1.getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                return _wert;
            };
            ID_Signal_Befestigung_TypeClass _iDSignalBefestigung = it.getIDSignalBefestigung();
            String _wert = null;
            if (_iDSignalBefestigung != null) {
                _wert = _iDSignalBefestigung.getWert();
            }
            return IterableExtensions.contains((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)gruppe), (Functions.Function1)_function_1)), (Object)_wert);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(SignalExtensions.signalRahmen(signal), (Functions.Function1)_function));
    }

    public static double rotation(Signal signal) {
        return PunktObjektTopKanteExtensions.getCoordinate(PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signal).get(0)).getEffectiveRotation();
    }

    public static List<Signal> getVorsignalbaken(Signal signal) {
        List<TOP_Kante> topKanten = PunktObjektExtensions.getTopKanten((Punkt_Objekt)signal);
        int _size = topKanten.size();
        boolean _equals = _size == 1;
        Assert.isTrue((boolean)_equals);
        TOP_Kante topKante = topKanten.get(0);
        ENUMWirkrichtung wirkrichtung = PunktObjektExtensions.getWirkrichtung((Punkt_Objekt)signal, topKante);
        boolean isForward = Objects.equals(wirkrichtung, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN);
        DirectedTopKante start = new DirectedTopKante(topKante, isForward);
        TopRouting _topRouting = new TopRouting();
        Set paths = Digraphs.getPaths((DirectedEdge)start, (Routing)_topRouting, (BigDecimal)ABSTAND_VORSIGNALBAKE);
        Consumer<DirectedEdgePath> _function = it -> it.setStart((Object)PunktObjektExtensions.getSinglePoint((Punkt_Objekt)signal));
        paths.forEach(_function);
        boolean _isDebugEnabled = logger.isDebugEnabled();
        if (_isDebugEnabled) {
            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
            if (signal != null) {
                _bezeichnung = signal.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
            if (_bezeichnung != null) {
                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            }
            String _wert = null;
            if (_bezeichnungTabelle != null) {
                _wert = _bezeichnungTabelle.getWert();
            }
            String bezeichnung = _wert;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Searchpaths for Vorsignalbaken of ");
            _builder.append(bezeichnung);
            _builder.append(":");
            logger.debug(_builder.toString());
            logger.debug(Debug.debugString(paths));
        }
        Functions.Function1 _function_1 = it -> {
            List _xblockexpression = null;
            DirectedEdgePath itsPath = it;
            Functions.Function1 _function_2 = it_1 -> PunktObjektTopKanteExtensions.getPunktObjekt(it_1);
            Functions.Function1 _function_3 = it_1 -> {
                BigDecimal _distance = itsPath.distance((Object)PunktObjektExtensions.getSinglePoint((Punkt_Objekt)signal), (Object)PunktObjektExtensions.getSinglePoint((Punkt_Objekt)it_1));
                return _distance.compareTo(ABSTAND_VORSIGNALBAKE) < 0;
            };
            Functions.Function1 _function_4 = it_1 -> SignalExtensions.isVorsignalbake(it_1);
            _xblockexpression = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)it.getPointIterator(), (Functions.Function1)_function_2), Signal.class), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
            return _xblockexpression;
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)paths, (Functions.Function1)_function_1)));
    }

    public static Set<Signalbegriff_ID_TypeClass> getSignalbegriffIds(Signal signal) {
        Functions.Function1 _function = it -> SignalRahmenExtensions.getSignalbegriffe(it);
        Functions.Function1 _function_1 = it -> it.getSignalbegriffID();
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map(SignalExtensions.signalRahmen(signal), (Functions.Function1)_function)), (Functions.Function1)_function_1));
    }

    public static Set<Signal_Signalbegriff> getSignalbegriffe(Signal signal) {
        Functions.Function1 _function = it -> SignalRahmenExtensions.getSignalbegriffe(it);
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(SignalExtensions.signalRahmen(signal), (Functions.Function1)_function)));
    }

    public static boolean isVorsignalbake(Signal signal) {
        Functions.Function1 _function = it -> UrObjectExtensions.getTypeName((EObject)it).startsWith(PREFIX_VORSIGNALBAKE);
        return IterableExtensions.exists(SignalExtensions.getSignalbegriffIds(signal), (Functions.Function1)_function);
    }

    public static List<Schaltmittel_Zuordnung> getAnrueckverschluss(Signal signal) {
        List<Schaltmittel_Zuordnung> _emptyList;
        List<Schaltmittel_Zuordnung> _elvis = null;
        Signal_Fstr_S_AttributeGroup _signalFstrS = null;
        if (signal != null) {
            _signalFstrS = signal.getSignalFstrS();
        }
        EList _iDAnrueckverschluss = null;
        if (_signalFstrS != null) {
            _iDAnrueckverschluss = _signalFstrS.getIDAnrueckverschluss();
        }
        List _map = null;
        if (_iDAnrueckverschluss != null) {
            Functions.Function1 _function = it -> it.getValue();
            _map = ListExtensions.map((List)_iDAnrueckverschluss, (Functions.Function1)_function);
        }
        Iterable _filterNull = null;
        if (_map != null) {
            _filterNull = IterableExtensions.filterNull((Iterable)_map);
        }
        List<Schaltmittel_Zuordnung> _list = null;
        if (_filterNull != null) {
            _list = IterableExtensions.toList((Iterable)_filterNull);
        }
        _elvis = _list != null ? _list : (_emptyList = Collections.emptyList());
        return _elvis;
    }

    public static Unterbringung getControlBox(Signal signal) {
        boolean _tripleEquals;
        Stellelement _realAktivStellelement = SignalExtensions.getRealAktivStellelement(signal);
        Aussenelementansteuerung _energie = null;
        if (_realAktivStellelement != null) {
            _energie = StellelementExtensions.getEnergie(_realAktivStellelement);
        }
        Aussenelementansteuerung energie = _energie;
        AEA_Allg_AttributeGroup _aEAAllg = null;
        if (energie != null) {
            _aEAAllg = energie.getAEAAllg();
        }
        Aussenelementansteuerung_Art_TypeClass _aussenelementansteuerungArt = null;
        if (_aEAAllg != null) {
            _aussenelementansteuerungArt = _aEAAllg.getAussenelementansteuerungArt();
        }
        ENUMAussenelementansteuerungArt _wert = null;
        if (_aussenelementansteuerungArt != null) {
            _wert = _aussenelementansteuerungArt.getWert();
        }
        boolean bl = _tripleEquals = _wert == ENUMAussenelementansteuerungArt.ENUM_AUSSENELEMENTANSTEUERUNG_ART_OBJEKTCONTROLLER;
        if (_tripleEquals) {
            return AussenelementansteuerungExtensions.getUnterbringung(energie);
        }
        return null;
    }

    public static Stellelement getRealAktivStellelement(Signal signal) {
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_AttributeGroup _signalRealAktiv = null;
        if (_signalReal != null) {
            _signalRealAktiv = _signalReal.getSignalRealAktiv();
        }
        ID_Stellelement_TypeClass _iDStellelement = null;
        if (_signalRealAktiv != null) {
            _iDStellelement = _signalRealAktiv.getIDStellelement();
        }
        Stellelement _value = null;
        if (_iDStellelement != null) {
            _value = _iDStellelement.getValue();
        }
        return _value;
    }

    public static Stellelement getStellelement(Signal signal) {
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_AttributeGroup _signalRealAktiv = null;
        if (_signalReal != null) {
            _signalRealAktiv = _signalReal.getSignalRealAktiv();
        }
        Signal_Real_Aktiv_AttributeGroup signalRealAktiv = _signalRealAktiv;
        ID_Stellelement_TypeClass _iDStellelement = null;
        if (signalRealAktiv != null) {
            _iDStellelement = signalRealAktiv.getIDStellelement();
        }
        Stellelement _value = null;
        if (_iDStellelement != null) {
            _value = _iDStellelement.getValue();
        }
        return _value;
    }

    public static W_Kr_Gsp_Element getWKrGspElement(Signal signal) {
        boolean _equals;
        Functions.Function1 _function = it -> {
            Weiche_Element_AttributeGroup _weicheElement = it.getWeicheElement();
            ID_Grenzzeichen_TypeClass _iDGrenzzeichen = null;
            if (_weicheElement != null) {
                _iDGrenzzeichen = _weicheElement.getIDGrenzzeichen();
            }
            Signal _value = null;
            if (_iDGrenzzeichen != null) {
                _value = _iDGrenzzeichen.getValue();
            }
            Identitaet_TypeClass _identitaet = null;
            if (_value != null) {
                _identitaet = _value.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            String _wert_1 = signal.getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        Iterable weichenElemente = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getWKrGspElement(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)weichenElemente);
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No weicheElement.IDGrenzzeichen found for Signal ");
            String _wert = signal.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(".");
            logger.debug(_builder.toString());
            return null;
        }
        int _size = IterableExtensions.size((Iterable)weichenElemente);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return ((W_Kr_Gsp_Element[])Conversions.unwrapArray((Object)weichenElemente, W_Kr_Gsp_Element.class))[0];
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Signal ");
        String _wert_1 = signal.getIdentitaet().getWert();
        _builder_1.append(_wert_1);
        _builder_1.append(" is Grenzzeichen for {");
        boolean _hasElements = false;
        for (W_Kr_Gsp_Element e : weichenElemente) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder_1.appendImmediate((Object)", ", "");
            }
            Bezeichnung_Element_AttributeGroup _bezeichnung = e.getBezeichnung();
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
            if (_bezeichnung != null) {
                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            }
            String _wert_2 = null;
            if (_bezeichnungTabelle != null) {
                _wert_2 = _bezeichnungTabelle.getWert();
            }
            _builder_1.append(_wert_2);
        }
        _builder_1.append("}");
        throw new IllegalArgumentException(_builder_1.toString());
    }

    public static <T extends Signalbegriff_ID_TypeClass> boolean hasSignalbegriffID(Signal signal, Class<T> type) {
        return SignalbegriffExtensions.containsSignalbegriffID(SignalExtensions.getSignalbegriffe(signal), type);
    }

    public static <T extends Signalbegriff_ID_TypeClass> Set<Signal_Signalbegriff> getSignalbegriffe(Signal signal, Class<T> type) {
        Functions.Function1 _function = it -> SignalbegriffExtensions.hasSignalbegriffID(it, type);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(SignalExtensions.getSignalbegriffe(signal), (Functions.Function1)_function));
    }

    public static Set<Gleis_Bezeichnung> getRaFahrtGleichzeitigVerbot(Signal signal) {
        Set _emptySet;
        Set _elvis = null;
        Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = null;
        if (signal != null) {
            _signalFstrAusInselgleis = signal.getSignalFstrAusInselgleis();
        }
        EList _iDRaFahrtGleichzeitigVerbot = null;
        if (_signalFstrAusInselgleis != null) {
            _iDRaFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDRaFahrtGleichzeitigVerbot();
        }
        List _map = null;
        if (_iDRaFahrtGleichzeitigVerbot != null) {
            Functions.Function1 _function = it -> it.getValue();
            _map = ListExtensions.map((List)_iDRaFahrtGleichzeitigVerbot, (Functions.Function1)_function);
        }
        Set _filterNull = null;
        if (_map != null) {
            _filterNull = IterableExtensions.filterNull((Iterable)_map);
        }
        _elvis = _filterNull != null ? _filterNull : (_emptySet = Collections.emptySet());
        return IterableExtensions.toSet(_elvis);
    }

    public static Set<Gleis_Bezeichnung> getZgFahrtGleichzeitigVerbot(Signal signal) {
        Set _emptySet;
        Set _elvis = null;
        Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = null;
        if (signal != null) {
            _signalFstrAusInselgleis = signal.getSignalFstrAusInselgleis();
        }
        EList _iDZgFahrtGleichzeitigVerbot = null;
        if (_signalFstrAusInselgleis != null) {
            _iDZgFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDZgFahrtGleichzeitigVerbot();
        }
        List _map = null;
        if (_iDZgFahrtGleichzeitigVerbot != null) {
            Functions.Function1 _function = it -> it.getValue();
            _map = ListExtensions.map((List)_iDZgFahrtGleichzeitigVerbot, (Functions.Function1)_function);
        }
        Set _filterNull = null;
        if (_map != null) {
            _filterNull = IterableExtensions.filterNull((Iterable)_map);
        }
        _elvis = _filterNull != null ? _filterNull : (_emptySet = Collections.emptySet());
        return IterableExtensions.toSet(_elvis);
    }

    public static Schaltmittel_Zuordnung getZweitesHaltfallkriterium(Signal signal) {
        Signal_Fstr_S_AttributeGroup _signalFstrS = null;
        if (signal != null) {
            _signalFstrS = signal.getSignalFstrS();
        }
        ID_Zweites_Haltfallkriterium_TypeClass _iDZweitesHaltfallkriterium = null;
        if (_signalFstrS != null) {
            _iDZweitesHaltfallkriterium = _signalFstrS.getIDZweitesHaltfallkriterium();
        }
        Schaltmittel_Zuordnung _value = null;
        if (_iDZweitesHaltfallkriterium != null) {
            _value = _iDZweitesHaltfallkriterium.getValue();
        }
        return _value;
    }

    public static Punkt_Objekt_TOP_Kante_AttributeGroup getMountPoint(Signal signal, Signal_Befestigung signalBefestigung) {
        Functions.Function1 _function = e -> {
            Identitaet_TypeClass _identitaet_1;
            Identitaet_TypeClass _identitaet = PunktObjektTopKanteExtensions.getTopKante(e).getIdentitaet();
            return _identitaet == (_identitaet_1 = PunktObjektTopKanteExtensions.getTopKante(CollectionExtensions.getUnique(PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signalBefestigung))).getIdentitaet());
        };
        return (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(IterableExtensions.toList((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints((Punkt_Objekt)signal), (Functions.Function1)_function)));
    }

    public static boolean isBelongToControlArea(Signal signal, Stell_Bereich controlArea) {
        boolean existsFiktivesSignalFAPZiel;
        boolean existsFiktivesSignalFAPStart;
        boolean _isBelongToControlArea;
        Stellelement stellElement = SignalExtensions.getStellelement(signal);
        boolean _or = false;
        ID_Aussenelementansteuerung_TypeClass _iDEnergie = null;
        if (stellElement != null) {
            _iDEnergie = stellElement.getIDEnergie();
        }
        Aussenelementansteuerung _value = null;
        if (_iDEnergie != null) {
            _value = _iDEnergie.getValue();
        }
        if (_isBelongToControlArea = AussenelementansteuerungExtensions.isBelongToControlArea(_value, controlArea)) {
            _or = true;
        } else {
            boolean _isBelongToControlArea_1;
            ID_Aussenelementansteuerung_TypeClass _iDInformation = null;
            if (stellElement != null) {
                _iDInformation = stellElement.getIDInformation();
            }
            Aussenelementansteuerung _value_1 = null;
            if (_iDInformation != null) {
                _value_1 = _iDInformation.getValue();
            }
            _or = _isBelongToControlArea_1 = AussenelementansteuerungExtensions.isBelongToControlArea(_value_1, controlArea);
        }
        if (_or) {
            return true;
        }
        boolean bl = existsFiktivesSignalFAPStart = signal.getSignalFiktiv() != null && IterableExtensions.exists((Iterable)signal.getSignalFiktiv().getFiktivesSignalFunktion(), it -> {
            ENUMFiktivesSignalFunktion _wert = it.getWert();
            return _wert == ENUMFiktivesSignalFunktion.ENUM_FIKTIVES_SIGNAL_FUNKTION_FAP_START;
        });
        if (existsFiktivesSignalFAPStart) {
            Functions.Function1 _function = it -> it.getIDFstrFahrweg().getValue();
            Functions.Function1 _function_1 = it -> {
                ID_Signal_TypeClass _iDStart = it.getIDStart();
                Signal _value_2 = null;
                if (_iDStart != null) {
                    _value_2 = _iDStart.getValue();
                }
                return _value_2 == signal;
            };
            Iterable fstrFahrwegs = IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFstrZugRangier(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> {
                ID_Ziel_TypeClass _iDZiel = it.getIDZiel();
                Basis_Objekt _value_2 = null;
                if (_iDZiel != null) {
                    _value_2 = _iDZiel.getValue();
                }
                return _value_2;
            };
            Functions.Function1 _function_3 = it -> BereichObjektExtensions.contains((Bereich_Objekt)controlArea, (Punkt_Objekt)it);
            return IterableExtensions.exists((Iterable)Iterables.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)fstrFahrwegs, (Functions.Function1)_function_2)), Signal.class), (Functions.Function1)_function_3);
        }
        boolean bl2 = existsFiktivesSignalFAPZiel = signal.getSignalFiktiv() != null && IterableExtensions.exists((Iterable)signal.getSignalFiktiv().getFiktivesSignalFunktion(), it -> {
            ENUMFiktivesSignalFunktion _wert = it.getWert();
            return _wert == ENUMFiktivesSignalFunktion.ENUM_FIKTIVES_SIGNAL_FUNKTION_FAP_ZIEL;
        });
        if (existsFiktivesSignalFAPZiel) {
            Functions.Function1 _function_4 = it -> it.getIDFstrFahrweg().getValue();
            Functions.Function1 _function_5 = it -> {
                ID_Ziel_TypeClass _iDZiel = it.getIDZiel();
                Basis_Objekt _value_2 = null;
                if (_iDZiel != null) {
                    _value_2 = _iDZiel.getValue();
                }
                return _value_2 == signal;
            };
            Iterable fstrFahrwegs_1 = IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFstrZugRangier(), (Functions.Function1)_function_4)), (Functions.Function1)_function_5);
            Functions.Function1 _function_6 = it -> {
                ID_Signal_TypeClass _iDStart = it.getIDStart();
                Signal _value_2 = null;
                if (_iDStart != null) {
                    _value_2 = _iDStart.getValue();
                }
                return _value_2;
            };
            Functions.Function1 _function_7 = it -> BereichObjektExtensions.contains((Bereich_Objekt)controlArea, (Punkt_Objekt)it);
            return IterableExtensions.exists((Iterable)Iterables.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)fstrFahrwegs_1, (Functions.Function1)_function_6)), Signal.class), (Functions.Function1)_function_7);
        }
        if (signal.getSignalReal() != null || !existsFiktivesSignalFAPStart && !existsFiktivesSignalFAPZiel) {
            Functions.Function1 _function_8 = it -> BereichObjektExtensions.contains((Bereich_Objekt)controlArea, it, 1.0);
            return IterableExtensions.exists((Iterable)signal.getPunktObjektTOPKante(), (Functions.Function1)_function_8);
        }
        return false;
    }

    public static List<FMA_Komponente> getFmaKomponenten(Signal signal) {
        Functions.Function1 _function = it -> FahrwegExtensions.getStart(it) == signal || FahrwegExtensions.getZielSignal(it) == signal;
        Iterable fstrFahrwegs = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFstrFahrweg(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> FstrFahrwegExtensions.getFstrDweg(it);
        List dwegs = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)fstrFahrwegs, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> it.getIDFMAAnlageFreimeldung();
        Functions.Function1 _function_3 = it -> it.getValue();
        Iterable fmaAnlages = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)dwegs, (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        Functions.Function1 _function_4 = fmaKomponent -> {
            Functions.Function1 _function_5 = it -> FmaKomponenteExtensions.belongsTo(fmaKomponent, it);
            return IterableExtensions.exists((Iterable)fmaAnlages, (Functions.Function1)_function_5);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getFMAKomponente(), (Functions.Function1)_function_4));
    }

    public static List<Pair<String, List<String>>> getStreckeAndKm(Signal signal) {
        boolean _not_1;
        boolean _not;
        boolean _tripleEquals;
        Functions.Function1 _function;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)signal.getPunktObjektStrecke());
        if (_isNullOrEmpty) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1 getStreckeFunc = _function = pos -> {
            String _elvis = null;
            ID_Strecke_TypeClass _iDStrecke = pos.getIDStrecke();
            Strecke _value = null;
            if (_iDStrecke != null) {
                _value = _iDStrecke.getValue();
            }
            Strecke_Bezeichnung_AttributeGroup _bezeichnung = null;
            if (_value != null) {
                _bezeichnung = _value.getBezeichnung();
            }
            Bezeichnung_Strecke_TypeClass _bezeichnungStrecke = null;
            if (_bezeichnung != null) {
                _bezeichnungStrecke = _bezeichnung.getBezeichnungStrecke();
            }
            String _wert = null;
            if (_bezeichnungStrecke != null) {
                _wert = _bezeichnungStrecke.getWert();
            }
            _elvis = _wert != null ? _wert : "";
            return _elvis;
        };
        int _size = signal.getPunktObjektStrecke().size();
        boolean bl = _tripleEquals = _size == 1;
        if (_tripleEquals) {
            String _apply = (String)getStreckeFunc.apply((Object)((Punkt_Objekt_Strecke_AttributeGroup)signal.getPunktObjektStrecke().getFirst()));
            String _wert = ((Punkt_Objekt_Strecke_AttributeGroup)signal.getPunktObjektStrecke().getFirst()).getStreckeKm().getWert();
            Pair _mappedTo = Pair.of((Object)_apply, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_wert})));
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo}));
        }
        Functions.Function1 _function_1 = it -> {
            Km_Massgebend_TypeClass _kmMassgebend = it.getKmMassgebend();
            Boolean _wert_1 = null;
            if (_kmMassgebend != null) {
                _wert_1 = _kmMassgebend.getWert();
            }
            return _wert_1 == Boolean.valueOf(true);
        };
        Iterable kmMassgebends = IterableExtensions.filter((Iterable)signal.getPunktObjektStrecke(), (Functions.Function1)_function_1);
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)kmMassgebends);
        boolean bl2 = _not = !_isNullOrEmpty_1;
        if (_not) {
            Functions.Function1 _function_2 = it -> {
                String _apply_1 = (String)getStreckeFunc.apply(it);
                String _wert_1 = it.getStreckeKm().getWert();
                return Pair.of((Object)_apply_1, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_wert_1})));
            };
            return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)kmMassgebends, (Functions.Function1)_function_2));
        }
        List<Strecke> routeThroughBereichObjekt = PunktObjektTopKanteExtensions.getStreckenThroughBereichObjekt(PunktObjektExtensions.getSinglePoint((Punkt_Objekt)signal));
        boolean _isFindGeometryComplete = GEOKanteGeometryExtensions.isFindGeometryComplete();
        boolean bl3 = _not_1 = !_isFindGeometryComplete;
        if (_not_1) {
            Functions.Function1 _function_3 = it -> {
                String _elvis = null;
                Strecke_Bezeichnung_AttributeGroup _bezeichnung = it.getBezeichnung();
                Bezeichnung_Strecke_TypeClass _bezeichnungStrecke = null;
                if (_bezeichnung != null) {
                    _bezeichnungStrecke = _bezeichnung.getBezeichnungStrecke();
                }
                String _wert_1 = null;
                if (_bezeichnungStrecke != null) {
                    _wert_1 = _bezeichnungStrecke.getWert();
                }
                _elvis = _wert_1 != null ? _wert_1 : "";
                return Pair.of((Object)_elvis, Collections.unmodifiableList(CollectionLiterals.newArrayList()));
            };
            return ListExtensions.map(routeThroughBereichObjekt, (Functions.Function1)_function_3);
        }
        Functions.Function1 _function_4 = route -> {
            String _elvis = null;
            Strecke_Bezeichnung_AttributeGroup _bezeichnung = route.getBezeichnung();
            Bezeichnung_Strecke_TypeClass _bezeichnungStrecke = null;
            if (_bezeichnung != null) {
                _bezeichnungStrecke = _bezeichnung.getBezeichnungStrecke();
            }
            String _wert_1 = null;
            if (_bezeichnungStrecke != null) {
                _wert_1 = _bezeichnungStrecke.getWert();
            }
            _elvis = _wert_1 != null ? _wert_1 : "";
            List<String> _streckeKm = SignalExtensions.getStreckeKm(signal, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Strecke[]{route})));
            return Pair.of((Object)_elvis, _streckeKm);
        };
        return IterableExtensions.toList((Iterable)ListExtensions.map(routeThroughBereichObjekt, (Functions.Function1)_function_4));
    }

    public static List<String> getStreckeKm(Signal signal, List<Strecke> routeThroughBereichObjekt) {
        boolean _not_1;
        boolean _not;
        boolean _isFindGeometryComplete = GEOKanteGeometryExtensions.isFindGeometryComplete();
        boolean bl = _not = !_isFindGeometryComplete;
        if (_not) {
            return null;
        }
        Functions.Function1 _function = it -> {
            Km_Massgebend_TypeClass _kmMassgebend = it.getKmMassgebend();
            Boolean _wert = null;
            if (_kmMassgebend != null) {
                _wert = _kmMassgebend.getWert();
            }
            return _wert == Boolean.valueOf(true);
        };
        Iterable kmMassgebend = IterableExtensions.filter((Iterable)signal.getPunktObjektStrecke(), (Functions.Function1)_function);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)kmMassgebend);
        boolean bl2 = _not_1 = !_isNullOrEmpty;
        if (_not_1) {
            Functions.Function1 _function_1 = it -> it.getStreckeKm().getWert();
            return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)kmMassgebend, (Functions.Function1)_function_1));
        }
        Functions.Function1 _function_2 = route -> {
            try {
                return BigDecimalExtensions.toTableDecimal((BigDecimal)PunktObjektTopKanteExtensions.getStreckeKmThroughProjection(PunktObjektExtensions.getSinglePoint((Punkt_Objekt)signal), route));
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    logger.error("Can't find the Signal route km through projection point on route", (Throwable)e);
                    Functions.Function1 _function_3 = pos -> {
                        Strecke _value = pos.getIDStrecke().getValue();
                        return Objects.equals(_value, route);
                    };
                    Punkt_Objekt_Strecke_AttributeGroup _findFirst = (Punkt_Objekt_Strecke_AttributeGroup)IterableExtensions.findFirst((Iterable)signal.getPunktObjektStrecke(), (Functions.Function1)_function_3);
                    Strecke_Km_TypeClass _streckeKm = null;
                    if (_findFirst != null) {
                        _streckeKm = _findFirst.getStreckeKm();
                    }
                    String _wert = null;
                    if (_streckeKm != null) {
                        _wert = _streckeKm.getWert();
                    }
                    return _wert;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        List result = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(routeThroughBereichObjekt, (Functions.Function1)_function_2)));
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)result);
        if (_isNullOrEmpty_1) {
            Functions.Function1 _function_3 = it -> it.getStreckeKm().getWert();
            return IterableExtensions.toList((Iterable)ListExtensions.map((List)signal.getPunktObjektStrecke(), (Functions.Function1)_function_3));
        }
        return result;
    }
}

