/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.table;

import java.nio.file.Path;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.feature.validation.table.ValidationTableTransformationService;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationReport;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.set.utils.table.tree.AbstractTreeLayerTable;
import org.eclipse.set.utils.xml.XMLNodeFinder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ValidationTableView
extends AbstractTreeLayerTable {
    static String CSV_HEADER_PATTERN = "Validierungsmeldungen\nDatei: %s\nValidierung: %s\nWerkzeugkofferversion: %s\n\n\"Lfd. Nr.\";\"Schweregrad\";\"Problemart\";\"Zeilennummer\";\"Objektart\";\"Attribut/-gruppe\";\"Bereich\";\"Zustand\";\"Meldung\"\n";
    private final Messages messages;
    private final BasePart part;
    private NatTable natTable;
    private final TableMenuService tableMenuService;
    private final XMLNodeFinder xmlNodeFinder;

    public ValidationTableView(BasePart part, Messages messages, TableMenuService tableMenuService) {
        this.part = part;
        this.messages = messages;
        this.tableMenuService = tableMenuService;
        ToolboxFile toolboxFile = part.getModelSession().getToolboxFile();
        this.xmlNodeFinder = new XMLNodeFinder();
        this.xmlNodeFinder.read(toolboxFile, toolboxFile.getModelPath());
    }

    public Control create(Composite parent, ValidationReport validationReport) {
        ValidationTableTransformationService service = new ValidationTableTransformationService(this.messages);
        Table table = service.transform(validationReport);
        this.createTableBodyData(table, rowIndex -> ((ValidationProblem)validationReport.getProblems().get(rowIndex - 1)).getLineNumber());
        this.tableMenuService.addMenuItem(this.createJumpToTextViewMenuItem(this.part));
        this.tableMenuService.addMenuItem(this.createJumpToSiteplanMenuItem());
        this.natTable = this.createTable(parent, table);
        return this.natTable;
    }

    public void updateView(ValidationReport validationReport) {
        ValidationTableTransformationService service = new ValidationTableTransformationService(this.messages);
        this.bodyDataProvider.refresh(service.transform(validationReport));
        this.natTable.refresh();
    }

    protected TableMenuService getTableMenuService() {
        return this.tableMenuService;
    }

    protected XMLNodeFinder getXMLNodeFinder() {
        return this.xmlNodeFinder;
    }

    protected String getCSVHeaderPattern() {
        return CSV_HEADER_PATTERN;
    }

    public void exportCsv() {
        Shell shell = this.part.getToolboxShell();
        Path location = this.part.getModelSession().getToolboxFile().getPath();
        String defaultFileName = String.format(this.messages.ExportFilePattern, PathExtensions.getBaseFileName((Path)location));
        this.exportCsv(shell, this.part.getDialogService(), this.messages.ExportValidationTitleMsg, defaultFileName);
    }
}

