/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ListDialog;

public abstract class ExpectedValueControlRenderer
extends SimpleControlSWTControlSWTRenderer {
    private Label text;
    private Shell shell;

    public ExpectedValueControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding databindingService, EMFFormsLabelProvider labelProvider, VTViewTemplateProvider viewTemplateProvider) {
        super(vElement, viewContext, reportService, databindingService, labelProvider, viewTemplateProvider);
    }

    private String getTextVariantID() {
        return "org_eclipse_emf_ecp_view_editor_controls_ruleattribute";
    }

    public void finalizeRendering(Composite parent) {
        super.finalizeRendering(parent);
        this.shell = parent.getShell();
    }

    protected Control createSWTControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)composite);
        Button bSelectObject = new Button(composite, 8);
        bSelectObject.setText("Select Object");
        this.text = new Label(composite, 2052);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        bSelectObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExpectedValueControlRenderer.this.onSelectButton(ExpectedValueControlRenderer.this.text);
            }
        });
        return this.text;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Label text = (Label)control;
        TargetToModelUpdateStrategy targetToModelUpdateStrategy = new TargetToModelUpdateStrategy();
        ModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new ModelToTargetUpdateStrategy();
        ISWTObservableValue value = WidgetProperties.text().observe((Widget)text);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), this.withPreSetValidation((UpdateValueStrategy)targetToModelUpdateStrategy), (UpdateValueStrategy)modelToTargetUpdateStrategy);
        return new Binding[]{binding};
    }

    protected Binding createTooltipBinding(Control text, IObservableValue modelValue, DataBindingContext dataBindingContext, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        ISWTObservableValue toolTip = WidgetProperties.tooltipText().observe((Widget)text);
        return dataBindingContext.bindValue((IObservableValue)toolTip, modelValue, targetToModel, modelToTarget);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getSelectedObject(EAttribute attribute) {
        void var3_6;
        Object object = null;
        if (attribute == null) {
            this.showError(this.shell, "Missing Attribute", "Please select an attribute before attempting to select its value.");
            return object;
        }
        Class clazz = attribute.getEAttributeType().getInstanceClass();
        if (clazz == null) {
            if (!EcorePackage.eINSTANCE.getEEnum().isInstance((Object)attribute.getEType())) return null;
            Class<Enum> clazz2 = Enum.class;
            EList eLiterals = ((EEnumImpl)EEnumImpl.class.cast(attribute.getEType())).getELiterals();
            Object[] enumValues = eLiterals.toArray();
            ListDialog ld = new ListDialog(this.shell);
            ld.setLabelProvider((ILabelProvider)new LabelProvider());
            ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            ld.setInput((Object)enumValues);
            ld.setInitialSelections(new Object[]{enumValues[0]});
            ld.setMessage("Please select the enum value to set.");
            ld.setTitle("Select a value");
            int enumSelectionResult = ld.open();
            if (enumSelectionResult != 0) return object;
            return ((EEnumLiteral)EEnumLiteral.class.cast(ld.getResult()[0])).getLiteral();
        }
        if (clazz.isPrimitive()) {
            Class<?> clazz3 = this.getAttributeClass(clazz);
        }
        if (Enum.class.isAssignableFrom((Class<?>)var3_6)) {
            T[] enumValues = var3_6.getEnumConstants();
            ListDialog ld = new ListDialog(this.shell);
            ld.setLabelProvider((ILabelProvider)new LabelProvider());
            ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            ld.setInput(enumValues);
            ld.setInitialSelections(new Object[]{enumValues[0]});
            ld.setMessage("Please select the enum value to set.");
            ld.setTitle("Select a value");
            int enumSelectionResult = ld.open();
            if (enumSelectionResult != 0) return object;
            return ((Enumerator)Enumerator.class.cast(ld.getResult()[0])).getLiteral();
        }
        if (String.class.isAssignableFrom((Class<?>)var3_6)) return this.promptForValue(this.shell, object, (Class<?>)var3_6);
        if (Number.class.isAssignableFrom((Class<?>)var3_6)) return this.promptForValue(this.shell, object, (Class<?>)var3_6);
        if (Boolean.class.isAssignableFrom((Class<?>)var3_6)) {
            return this.promptForValue(this.shell, object, (Class<?>)var3_6);
        }
        this.showError(this.shell, "Not primitive Attribute selected", "The selected attribute has a not primitive type. We can't provide you support for it!");
        return object;
    }

    protected void showError(Shell shell, String title, String description) {
        MessageDialog.openError((Shell)shell, (String)title, (String)description);
    }

    Object promptForValue(Shell shell, Object object, Class<?> attributeClazz) {
        try {
            Constructor<?> constructor = attributeClazz.getConstructor(String.class);
            InputDialog id = new InputDialog(shell, "Insert the value", "The value must be parseable by the " + attributeClazz.getSimpleName() + " class. For a double value please use the #.# format. For boolean values 'true' or 'false'.", null, null);
            int inputResult = id.open();
            if (inputResult == 0) {
                object = constructor.newInstance(id.getValue());
            }
            if (Boolean.class.isAssignableFrom(attributeClazz) && !((Boolean)Boolean.class.cast(object)).booleanValue() && !"false".equalsIgnoreCase(id.getValue())) {
                this.showError(shell, "Invalid boolean value", "You have entered an invalid value. False has been chosen instead.");
            }
        }
        catch (IllegalArgumentException ex) {
            this.openInvalidValueMessage();
        }
        catch (SecurityException ex) {
            this.openInvalidValueMessage();
        }
        catch (NoSuchMethodException ex) {
            this.openInvalidValueMessage();
        }
        catch (InstantiationException ex) {
            this.openInvalidValueMessage();
        }
        catch (IllegalAccessException ex) {
            this.openInvalidValueMessage();
        }
        catch (InvocationTargetException ex) {
            this.openInvalidValueMessage();
        }
        return object;
    }

    private Class<?> getAttributeClass(Class<?> attributeClazz) {
        if (Integer.TYPE.isAssignableFrom(attributeClazz)) {
            attributeClazz = Integer.class;
        } else if (Long.TYPE.isAssignableFrom(attributeClazz)) {
            attributeClazz = Long.class;
        } else if (Float.TYPE.isAssignableFrom(attributeClazz)) {
            attributeClazz = Float.class;
        } else if (Double.TYPE.isAssignableFrom(attributeClazz)) {
            attributeClazz = Double.class;
        } else if (Boolean.TYPE.isAssignableFrom(attributeClazz)) {
            attributeClazz = Boolean.class;
        } else if (Character.TYPE.isAssignableFrom(attributeClazz)) {
            attributeClazz = Character.class;
        }
        return attributeClazz;
    }

    private void openInvalidValueMessage() {
        MessageDialog.openError((Shell)this.shell, (String)"Invalid value", (String)"You have entered an invalid value. The previsous value will be kept.");
    }

    protected abstract void onSelectButton(Label var1);

    protected EObject getObservedEObject() throws DatabindingFailedException {
        IObservableValue observableValue = this.getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EObject result = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        return result;
    }

    protected String getUnsetText() {
        return null;
    }

    protected class ModelToTargetUpdateStrategy
    extends EMFUpdateValueStrategy {
        protected ModelToTargetUpdateStrategy() {
        }

        public Object convert(Object value) {
            String converted = value.toString();
            if (String.class.isInstance(converted)) {
                IObservableValue observableValue;
                try {
                    observableValue = ExpectedValueControlRenderer.this.getEMFFormsDatabinding().getObservableValue(((VControl)ExpectedValueControlRenderer.this.getVElement()).getDomainModelReference(), ExpectedValueControlRenderer.this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    ExpectedValueControlRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return converted;
                }
                InternalEObject internalEObject = (InternalEObject)((IObserving)observableValue).getObserved();
                EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
                observableValue.dispose();
                return ECPTooltipModifierHelper.modifyString((String)((String)String.class.cast(converted)), (EStructuralFeature.Setting)internalEObject.eSetting(structuralFeature));
            }
            return converted;
        }
    }

    protected class TargetToModelUpdateStrategy
    extends EMFUpdateValueStrategy {
        public Object convert(Object value) {
            return value;
        }
    }
}

