/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import java.lang.reflect.Field;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.factory.MarkupNames;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public final class ConstantFactory
extends Factory
implements MarkupNames {
    private final String bundleSymbolicName;
    private final String constantClassName;
    private final String constantName;
    private Object product;

    public ConstantFactory(IConfigurationElement configurationElement) {
        super(ConstantFactory.productGroup(configurationElement), ConstantFactory.type(configurationElement));
        this.bundleSymbolicName = configurationElement.getContributor().getName();
        this.constantClassName = Objects.requireNonNull(configurationElement.getAttribute("class"));
        this.constantName = ConstantFactory.constantName(configurationElement);
    }

    @Override
    public Object create(String description) throws ProductCreationException {
        return this.getProduct(description);
    }

    private synchronized Object getProduct(String description) throws ProductCreationException {
        if (this.product == null) {
            try {
                Class<?> constantClass = OM.BUNDLE.loadClass(this.bundleSymbolicName, this.constantClassName);
                Field constantField = constantClass.getField(this.constantName);
                this.product = constantField.get(null);
            }
            catch (Exception ex) {
                throw this.productCreationException(description, ex);
            }
        }
        return this.product;
    }

    private static String productGroup(IConfigurationElement configurationElement) {
        return configurationElement.getAttribute("productGroup");
    }

    private static String type(IConfigurationElement configurationElement) {
        return configurationElement.getAttribute("type");
    }

    private static String constantName(IConfigurationElement configurationElement) {
        String constantName = configurationElement.getAttribute("name");
        if (StringUtil.isEmpty(constantName)) {
            constantName = ConstantFactory.type(configurationElement).toUpperCase();
        }
        return constantName;
    }
}

