/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.set.basis.geometry.GEOKanteSegment;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.locationtech.jts.geom.LineString;

public class GEOKanteMetadata {
    static final double SEGMENT_THRESHOLD = 0.001;
    final GEO_Kante geoKante;
    final GEO_Knoten geoKnoten;
    final LineString geometry;
    final List<GEOKanteSegment> segments = new ArrayList<GEOKanteSegment>();
    final BigDecimal start;
    final BigDecimal length;

    public GEO_Kante getGeoKante() {
        return this.geoKante;
    }

    public GEO_Knoten getGeoKnoten() {
        return this.geoKnoten;
    }

    public LineString getGeometry() {
        return this.geometry;
    }

    public List<GEOKanteSegment> getSegments() {
        return this.segments;
    }

    public BigDecimal getStart() {
        return this.start;
    }

    public BigDecimal getEnd() {
        return this.start.add(this.length);
    }

    public BigDecimal getLength() {
        return this.length;
    }

    public GEOKanteMetadata(GEO_Kante geoKante, BigDecimal start, BigDecimal length, List<Bereich_Objekt> bereichObjekt, TOP_Kante topKante, GEO_Knoten geoKnoten, LineString geometry) {
        this.geoKante = geoKante;
        this.start = start;
        this.length = length;
        this.geometry = geometry;
        this.geoKnoten = geoKnoten;
        this.determineSegments(topKante, bereichObjekt);
    }

    public GEOKanteMetadata(GEO_Kante geoKante, BigDecimal start, GEO_Knoten geoKnoten, LineString geometry) {
        this.geoKante = geoKante;
        this.start = start;
        this.length = GEOKanteMetadata.dermineLength().apply(geoKante);
        this.geometry = geometry;
        this.geoKnoten = geoKnoten;
        this.segments.add(new GEOKanteSegment(start, this.length));
    }

    private static Function<GEO_Kante, BigDecimal> dermineLength() {
        return kante -> {
            try {
                return kante.getGEOKanteAllg().getGEOLaenge().getWert();
            }
            catch (NullPointerException e) {
                return BigDecimal.ZERO;
            }
        };
    }

    private void determineSegments(TOP_Kante topKante, List<Bereich_Objekt> bereichObjekt) {
        this.segments.add(new GEOKanteSegment(this.start, this.length));
        BigDecimal end = this.getEnd();
        List<Bereich_Objekt> relevantBOs = bereichObjekt.stream().filter(bo -> bo.getBereichObjektTeilbereich().stream().anyMatch(tb -> {
            boolean existBothOfBound;
            boolean isSameTOPKante = tb.getIDTOPKante() != null && tb.getIDTOPKante().getValue() == topKante;
            boolean bl = existBothOfBound = tb.getBegrenzungA() != null && tb.getBegrenzungA().getWert() != null && tb.getBegrenzungB() != null && tb.getBegrenzungB().getWert() != null;
            return isSameTOPKante && existBothOfBound;
        })).toList();
        relevantBOs.forEach(bo -> bo.getBereichObjektTeilbereich().forEach(tb -> {
            BigDecimal tbStart = tb.getBegrenzungA().getWert();
            BigDecimal tbEnd = tb.getBegrenzungB().getWert();
            if (tbStart.compareTo(end) > 0 || tbEnd.compareTo(this.start) < 0) {
                return;
            }
            if (tbStart.compareTo(this.start) > 0 || tbEnd.compareTo(end) < 0) {
                if (tbStart.compareTo(this.start) >= 0 && tbEnd.compareTo(end) <= 0) {
                    this.splitSegmentsAt(tbStart);
                    this.splitSegmentsAt(tbEnd);
                } else if (tbStart.compareTo(this.start) <= 0 && tbEnd.compareTo(end) <= 0) {
                    this.splitSegmentsAt(tbEnd);
                } else if (tbStart.compareTo(this.start) > 0 && tbEnd.compareTo(end) >= 0) {
                    this.splitSegmentsAt(tbStart);
                }
            }
        }));
        this.segments.forEach(segment -> {
            BigDecimal segStart = segment.getStart();
            BigDecimal segEnd = segment.getEnd();
            relevantBOs.forEach(bo -> bo.getBereichObjektTeilbereich().forEach(tb -> {
                BigDecimal tbStart = tb.getBegrenzungA().getWert();
                BigDecimal tbEnd = tb.getBegrenzungB().getWert();
                if (tbStart.compareTo(end) > 0 || tbEnd.compareTo(this.start) < 0) {
                    return;
                }
                if (tbStart.compareTo(segEnd) > 0) {
                    return;
                }
                if (tbEnd.compareTo(segStart) < 0) {
                    return;
                }
                gEOKanteSegment.bereichObjekte.add((Bereich_Objekt)bo);
            }));
        });
    }

    private void splitSegmentsAt(BigDecimal distance) {
        GEOKanteSegment originalSegment = this.getContainingSegment(distance);
        if (originalSegment == null) {
            throw new RuntimeException("Missing GEO_Kante segment");
        }
        GEOKanteSegment nextSegment = new GEOKanteSegment(originalSegment);
        BigDecimal firstSegmentLength = distance.subtract(originalSegment.getStart());
        BigDecimal secondSegmentLength = originalSegment.getEnd().subtract(distance);
        if (firstSegmentLength.compareTo(BigDecimal.valueOf(0.001)) < 0 || secondSegmentLength.compareTo(BigDecimal.valueOf(0.001)) < 0) {
            return;
        }
        originalSegment.setLength(firstSegmentLength);
        nextSegment.setStart(distance);
        nextSegment.setLength(secondSegmentLength);
        this.segments.add(nextSegment);
    }

    public GEOKanteSegment getContainingSegment(BigDecimal distance) {
        return this.segments.stream().filter(segment -> segment.getStart().compareTo(distance) <= 0 && segment.getEnd().compareTo(distance) >= 0).findFirst().orElse(null);
    }
}

