/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.viewgroups;

import org.eclipse.jface.resource.ImageDescriptor;

public record ToolboxViewGroup(String text, ImageDescriptor imageDescriptor, boolean isInitiallyExpanded, boolean isDevelopment, boolean isInvisible, int orderPriority) {

    public static class Builder {
        private String text;
        private ImageDescriptor imageDescriptor;
        private boolean isInitiallyExpanded = false;
        private boolean isDevelopment = false;
        private boolean isInvisible = false;
        private int orderPriority = 0;

        public Builder withText(String groupText) {
            this.text = groupText;
            return this;
        }

        public Builder withIcon(ImageDescriptor groupImageDescriptor) {
            this.imageDescriptor = groupImageDescriptor;
            return this;
        }

        public Builder setInitiallyExpanded(boolean initiallyExpanded) {
            this.isInitiallyExpanded = initiallyExpanded;
            return this;
        }

        public Builder setDevelopment(boolean development) {
            this.isDevelopment = development;
            return this;
        }

        public Builder setInvisible(boolean invisible) {
            this.isInvisible = invisible;
            return this;
        }

        public Builder withOrderPriority(int priority) {
            this.orderPriority = priority;
            return this;
        }

        public ToolboxViewGroup build() {
            return new ToolboxViewGroup(this.text, this.imageDescriptor, this.isInitiallyExpanded, this.isDevelopment, this.isInvisible, this.orderPriority);
        }
    }
}

