/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.xtext.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.util.JdtClasspathUriResolver;

public class ResourceSetClasspathConfigurator {
    public ResourceSet configure(XtextResourceSet set, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && javaProject.exists()) {
            set.getURIConverter().getURIMap().putAll(this.computePlatformURIMap(javaProject));
            set.setClasspathURIContext((Object)javaProject);
            set.setClasspathUriResolver((IClasspathUriResolver)new JdtClasspathUriResolver());
        }
        return set;
    }

    private Map<URI, URI> computePlatformURIMap(IJavaProject javaProject) {
        HashMap<URI, URI> hashMap = new HashMap<URI, URI>(EcorePlugin.computePlatformURIMap());
        try {
            IClasspathEntry[] classpath;
            if (!javaProject.exists()) {
                return hashMap;
            }
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                    IPath path = classPathEntry.getPath();
                    if (path != null && "jar".equals(path.getFileExtension())) {
                        try {
                            File file = path.toFile();
                            if (file == null || !file.exists()) break block17;
                            Throwable throwable = null;
                            Object var11_14 = null;
                            try (JarFile jarFile = new JarFile(file);){
                                Manifest manifest = jarFile.getManifest();
                                if (manifest != null) {
                                    this.handleManifest(hashMap, file, manifest);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            DslCommonPlugin.getDefault().error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            DslCommonPlugin.getDefault().error(e.getMessage(), (Throwable)e);
        }
        return hashMap;
    }

    private void handleManifest(HashMap<URI, URI> hashMap, File file, Manifest manifest) {
        String name = manifest.getMainAttributes().getValue("bundle-symbolic-name");
        if (name != null) {
            int indexOf = name.indexOf(59);
            if (indexOf > 0) {
                name = name.substring(0, indexOf);
            }
            if (!EcorePlugin.getPlatformResourceMap().containsKey(name)) {
                String p = "archive:" + String.valueOf(file.toURI()) + "!/";
                URI uri = URI.createURI((String)p);
                URI platformResourceKey = URI.createPlatformResourceURI((String)(name + "/"), (boolean)false);
                URI platformPluginKey = URI.createPlatformPluginURI((String)(name + "/"), (boolean)false);
                hashMap.put(platformResourceKey, uri);
                hashMap.put(platformPluginKey, uri);
            }
        }
    }
}

