/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.layout;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.swt.widgets.Display;

public class SiriusCanonicalLayoutCommand
extends RecordingCommand
implements AbstractCommand.NonDirtying {
    private IGraphicalEditPart parentEditPart;
    private List<IAdaptable> childViewsAdapters;
    private List<IAdaptable> borderedChildViewsAdapters;
    private List<IAdaptable> centeredChildViewsAdapters;
    private List<IAdaptable> referenceChildViewsAdapters;
    private String specificLayoutType;
    private boolean deferredExecution;

    static SiriusCanonicalLayoutCommand normal(TransactionalEditingDomain domain, IGraphicalEditPart parent, List<IAdaptable> views, String layoutType) {
        return new SiriusCanonicalLayoutCommand(domain, parent, views, null, null, null, layoutType, false);
    }

    static SiriusCanonicalLayoutCommand initial(TransactionalEditingDomain domain, IGraphicalEditPart parent, List<IAdaptable> views, List<IAdaptable> referenceViews, String layoutType) {
        return new SiriusCanonicalLayoutCommand(domain, parent, null, null, views, referenceViews, layoutType, false);
    }

    static SiriusCanonicalLayoutCommand border(TransactionalEditingDomain domain, IGraphicalEditPart parent, List<IAdaptable> views) {
        return new SiriusCanonicalLayoutCommand(domain, parent, null, views, null, null, "KEEP FIXED", true);
    }

    private SiriusCanonicalLayoutCommand(TransactionalEditingDomain domain, IGraphicalEditPart parentEditPart, List<IAdaptable> childViewsAdapters, List<IAdaptable> borderedChildViewsAdapters, List<IAdaptable> centeredChildViewsAdapters, List<IAdaptable> referenceChildViewsAdapters, String specificLayoutType, boolean deferredExecution) {
        super(domain, Messages.SiriusCanonicalLayoutCommand_label);
        this.parentEditPart = parentEditPart;
        this.childViewsAdapters = childViewsAdapters;
        this.centeredChildViewsAdapters = centeredChildViewsAdapters;
        this.referenceChildViewsAdapters = referenceChildViewsAdapters;
        this.borderedChildViewsAdapters = borderedChildViewsAdapters;
        this.specificLayoutType = specificLayoutType;
        this.deferredExecution = deferredExecution;
    }

    protected void doExecute() {
        Display.getDefault().asyncExec(() -> {
            if (this.deferredExecution) {
                Display.getDefault().asyncExec(() -> this.internalExecute());
            } else {
                this.internalExecute();
            }
        });
    }

    private void internalExecute() {
        if (this.childViewsAdapters == null && this.centeredChildViewsAdapters == null && this.borderedChildViewsAdapters == null) {
            this.executeLayoutOnDiagramOpening();
        } else {
            this.executeLayoutDueToExternalChanges();
        }
    }

    private void executeLayoutOnDiagramOpening() {
        Command arrangeCmd = SiriusLayoutDataManager.INSTANCE.getArrangeCreatedViewsOnOpeningCommand(this.parentEditPart);
        if (arrangeCmd != null && arrangeCmd.canExecute()) {
            arrangeCmd.execute();
        }
    }

    private void executeLayoutDueToExternalChanges() {
        Command arrangeCmd = SiriusLayoutDataManager.INSTANCE.getArrangeCreatedViewsCommand(this.childViewsAdapters, this.borderedChildViewsAdapters, this.centeredChildViewsAdapters, this.referenceChildViewsAdapters, this.parentEditPart, this.specificLayoutType);
        if (arrangeCmd != null && arrangeCmd.canExecute() && this.parentEditPart != null && this.parentEditPart.getRoot() != null) {
            arrangeCmd.execute();
        }
    }
}

