/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.grandom.generators;

import java.util.Random;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.elk.graph.properties.Property;

public class GeneratorOptions
extends MapPropertyHolder {
    private static final long serialVersionUID = -917483559995737504L;
    public static final IProperty<Integer> NUMBER_OF_GRAPHS = new Property("randomWizard.numberOfGraphs", (Object)1);
    public static final IProperty<String> FILE_NAME = new Property("randomWizard.filename", (Object)"random.kgt");
    public static final IProperty<FileFormat> FILE_FORMAT = new Property("randomWizard.fileFormat", (Object)FileFormat.XTEXT);
    public static final IProperty<GraphType> GRAPH_TYPE = new Property("basic.graphType", (Object)GraphType.CUSTOM);
    public static final IProperty<RandVal> NUMBER_OF_NODES = new Property("basic.numNodes", (Object)RandVal.exact(10.0));
    public static final IProperty<EdgeDetermination> EDGE_DETERMINATION = new Property("basic.edgeDetermination", (Object)EdgeDetermination.ABSOLUTE);
    public static final IProperty<RandVal> EDGES_ABSOLUTE = new Property("basic.numberOfEdges", (Object)RandVal.exact(20.0));
    public static final IProperty<RandVal> RELATIVE_EDGES = new Property("basic.relEdges", (Object)RandVal.allNil());
    public static final IProperty<RandVal> DENSITY = new Property("basic.density", (Object)RandVal.allNil());
    public static final IProperty<Boolean> ENABLE_HIERARCHY = new Property("basic.enableHierarchy", (Object)false);
    public static final IProperty<Float> HIERARCHY_CHANCE = new Property("basic.hierarchyChance", (Object)Float.valueOf(0.05f), (Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(1.0f));
    public static final IProperty<RandVal> MAX_HIERARCHY_LEVEL = new Property("basic.maxHierarchyLevel", (Object)RandVal.exact(3.0));
    public static final IProperty<Float> HIERARCHY_NODES_FACTOR = new Property("basic.hierarchyNodesFactor", (Object)Float.valueOf(0.5f), (Comparable)Float.valueOf(0.0f));
    public static final IProperty<Float> HYPERNODE_CHANCE = new Property("basic.hypernodeChance", (Object)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(1.0f));
    public static final IProperty<Boolean> ENABLE_PORTS = new Property("basic.ports", (Object)false);
    public static final IProperty<RandVal> USE_EXISTING_PORTS_CHANCE = new Property("basic.useExistingPortsChance", (Object)RandVal.exact(0.3));
    public static final IProperty<Boolean> CROSS_HIERARCHY_EDGES = new Property("basic.crossHierarchyEdges", (Object)false);
    public static final IProperty<Boolean> TIME_BASED_RANDOMIZATION = new Property("basic.timeBasedRandomization", (Object)true);
    public static final IProperty<Integer> RANDOMIZATION_SEED = new Property("basic.randomizationSeed", (Object)0);
    public static final IProperty<Boolean> SET_NODE_SIZE = new Property("basic.setNodeSize", (Object)true);
    public static final IProperty<RandVal> NODE_WIDTH = new Property("basic.minNodeWidth", (Object)RandVal.exact(30.0));
    public static final IProperty<RandVal> NODE_HEIGHT = new Property("basic.minNodeHeight", (Object)RandVal.exact(30.0));
    public static final IProperty<Boolean> CREATE_NODE_LABELS = new Property("basic.createNodeLabels", (Object)false);
    public static final IProperty<Boolean> SET_PORT_SIZE = new Property("basic.setPortSize", (Object)true);
    public static final IProperty<RandVal> PORT_WIDTH = new Property("basic.portWidth", (Object)RandVal.exact(4.0));
    public static final IProperty<RandVal> PORT_HEIGHT = new Property("basic.portHeight", (Object)RandVal.exact(4.0));
    public static final IProperty<Boolean> CREATE_PORT_LABELS = new Property("basic.createPortLabels", (Object)false);
    public static final IProperty<PortConstraints> PORT_CONSTRAINTS = new Property("layout.portConstraints", (Object)PortConstraints.UNDEFINED);
    public static final IProperty<Integer> INCOMING_NORTH_SIDE = new Property("layout.incomingNorthSide", (Object)10);
    public static final IProperty<Integer> INCOMING_EAST_SIDE = new Property("layout.incomingEastSide", (Object)5);
    public static final IProperty<Integer> INCOMING_SOUTH_SIDE = new Property("layout.incomingSouthSide", (Object)10);
    public static final IProperty<Integer> INCOMING_WEST_SIDE = new Property("layout.incomingWestSide", (Object)75);
    public static final IProperty<Integer> OUTGOING_NORTH_SIDE = new Property("layout.outgoingNorthSide", (Object)10);
    public static final IProperty<Integer> OUTGOING_EAST_SIDE = new Property("layout.outgoingEastSide", (Object)75);
    public static final IProperty<Integer> OUTGOING_SOUTH_SIDE = new Property("layout.outgoingSouthSide", (Object)10);
    public static final IProperty<Integer> OUTGOING_WEST_SIDE = new Property("layout.outgoingWestSide", (Object)5);
    public static final IProperty<RandVal> OUTGOING_EDGES = new Property("basic.minOutgoingEdges", (Object)RandVal.allNil());
    public static final IProperty<Boolean> SELF_LOOPS = new Property("basic.selfLoops", (Object)false);
    public static final IProperty<Boolean> MULTI_EDGES = new Property("basic.multiEdges", (Object)true);
    public static final IProperty<Boolean> CYCLES = new Property("basic.cycles", (Object)true);
    public static final IProperty<Boolean> ISOLATED_NODES = new Property("basic.isolatedNodes", (Object)true);
    public static final Property<Boolean> EDGE_LABELS = new Property("basic.edgeLabels", (Object)false);
    public static final IProperty<Integer> MAX_WIDTH = new Property("basic.maxWidth", (Object)0);
    public static final IProperty<Integer> MAX_DEGREE = new Property("basic.maxDegree", (Object)0);
    public static final IProperty<Boolean> PLANAR = new Property("basic.planar", (Object)false);
    public static final IProperty<RandVal> PARTITION_FRAC = new Property("basic.minPartitionFraction", (Object)RandVal.exact(0.4f));
    public static final IProperty<Boolean> SMALL_HIERARCHY = new Property("basic.SMALL_HIERARCHY", (Object)false);
    public static final IProperty<RandVal> NUMBER_HIERARCHICAL_NODES = new Property("basic.HIERARCH_NODE", (Object)RandVal.allNil());
    public static final IProperty<RandVal> CROSS_HIER = new Property("basic.CROSS_HIER", (Object)RandVal.allNil());
    public static final IProperty<RandVal> EXACT_RELATIVE_HIER = new Property("basic.EXACT_RELATIVE_HIER", null);

    public static enum EdgeDetermination {
        ABSOLUTE,
        OUTGOING,
        RELATIVE,
        DENSITY;

    }

    public static enum FileFormat {
        XMI,
        XTEXT;

    }

    public static enum GraphType {
        CUSTOM,
        TREE,
        BICONNECTED,
        TRICONNECTED,
        ACYCLIC_NO_TRANSITIVE_EDGES,
        BIPARTITE;

    }

    public static class RandVal {
        private double min;
        private double max;
        private double mean;
        private double stddv;
        private double exact;
        private boolean useMinMax;
        private boolean useExact;

        private RandVal(double min, double max, double mean, double stddv, double exact, boolean useMinMax, boolean useExact) {
            this.min = min;
            this.max = max;
            this.mean = mean;
            this.stddv = stddv;
            this.exact = exact;
            this.useMinMax = useMinMax;
            this.useExact = useExact;
        }

        public static RandVal allNil() {
            return new RandVal(0.0, 0.0, 0.0, 0.0, 0.0, false, false);
        }

        public static RandVal minMax(double min, double max) {
            return new RandVal(min, max, 0.0, 0.0, 0.0, true, false);
        }

        public static RandVal exact(double exact) {
            return new RandVal(0.0, 0.0, 0.0, 0.0, exact, false, true);
        }

        public static RandVal gaussian(double mean, double stddv) {
            return new RandVal(0.0, 0.0, mean, stddv, 0.0, false, false);
        }

        public double val(Random r) {
            double result = 0.0;
            if (this.useExact) {
                result = this.exact;
            } else if (this.useMinMax) {
                assert (this.max >= this.min);
                result = r.nextDouble() * (this.max - this.min) + this.min;
            } else {
                result = r.nextGaussian() * this.stddv + this.mean;
            }
            return result < 0.0 ? 0.0 : result;
        }

        public int intVal(Random r) {
            return (int)Math.round(this.val(r));
        }

        public int defaultInt() {
            return (int)Math.round(this.exact);
        }

        public float floatVal(Random r) {
            return (float)this.val(r);
        }

        public void setMean(double d) {
            this.mean = d;
        }

        public void setStddv(double d) {
            this.stddv = d;
        }

        public void setMin(int m) {
            this.min = m;
        }

        public void setMax(int m) {
            this.max = m;
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public double defaultVal() {
            return this.exact;
        }
    }
}

