/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.quickoutline;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineCallback;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlineDescriptor;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlinePageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.SiriusInformationPresenter;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.SiriusInformationPresenterFactory;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.api.editor.DTreeEditor;
import org.eclipse.sirius.tree.ui.tools.internal.quickoutline.DTreeQuickOutlineContentProvider;
import org.eclipse.sirius.tree.ui.tools.internal.quickoutline.DTreeQuickOutlineLabelProvider;
import org.eclipse.sirius.tree.ui.tools.internal.quickoutline.TreeOutlineCallback;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TreeQuickOutlineHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DTreeEditor editor = this.getCurrentEditor();
        if (editor != null) {
            QuickOutlineDescriptor descriptor = this.createDescriptor(editor);
            SiriusInformationPresenter presenter = SiriusInformationPresenterFactory.createInformationPresenter((Control)editor.getControl(), (QuickOutlineDescriptor)descriptor, (Object)editor.getRepresentation());
            presenter.showInformation();
        }
        return null;
    }

    private QuickOutlineDescriptor createDescriptor(DTreeEditor editor) {
        ComposedAdapterFactory caf = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        DTreeQuickOutlineLabelProvider labelProvider = new DTreeQuickOutlineLabelProvider((AdapterFactory)caf);
        TreeOutlineCallback callBack = new TreeOutlineCallback((IEditorPart)editor);
        QuickOutlinePageDescriptor page1 = new QuickOutlinePageDescriptor((IQuickOutlineCallback)callBack, (IQuickOutlineLabelProvider)labelProvider, (IContentProvider)new DTreeQuickOutlineContentProvider(), Messages.TreeQuickOutlineHandler_quickOutline);
        QuickOutlineDescriptor descriptor = new QuickOutlineDescriptor();
        descriptor.addPage(page1);
        return descriptor;
    }

    private DTreeEditor getCurrentEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof DTreeEditor) {
            return (DTreeEditor)window.getActivePage().getActiveEditor();
        }
        return null;
    }
}

