/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.sheet;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.business.api.views.properties.tabbed.LabelProviderProviderService;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Image;

public class SiriusSheetLabelProvider
extends DecoratingLabelProvider {
    private LabelProviderProviderService labelProviderProviderService = new LabelProviderProviderService();

    public SiriusSheetLabelProvider() {
        super((ILabelProvider)new AdapterFactoryLabelProvider(DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory()), null);
    }

    public String getText(Object element) {
        String text = null;
        ILabelProvider firstProvidedLabelProvider = this.labelProviderProviderService.getFirstProvidedLabelProvider(element);
        if (firstProvidedLabelProvider != null) {
            text = firstProvidedLabelProvider.getText(element);
        } else {
            Object selected = this.unwrap(element);
            if (selected instanceof DSemanticDecorator && ((DSemanticDecorator)selected).getTarget() != null) {
                EObject eObject = ((DSemanticDecorator)selected).getTarget();
                AdapterFactory adapterFactory = DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory();
                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
                text = itemLabelProvider.getText((Object)eObject);
            } else {
                text = super.getText(selected);
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = null;
        ILabelProvider firstProvidedLabelProvider = this.labelProviderProviderService.getFirstProvidedLabelProvider(element);
        if (firstProvidedLabelProvider != null) {
            image = firstProvidedLabelProvider.getImage(element);
        } else {
            Object selected = this.unwrap(element);
            if (selected instanceof DSemanticDecorator && ((DSemanticDecorator)selected).getTarget() != null) {
                EObject eObject = ((DSemanticDecorator)selected).getTarget();
                image = DiagramUIPlugin.getPlugin().getImage(DiagramUIPlugin.getPlugin().getItemImageDescriptor(eObject));
            } else {
                image = super.getImage(selected);
            }
        }
        return image;
    }

    private Object unwrap(Object element) {
        View view;
        if (element instanceof IStructuredSelection) {
            return this.unwrap(((IStructuredSelection)element).getFirstElement());
        }
        if (element instanceof EditPart) {
            return this.unwrapEditPart((EditPart)element);
        }
        if (element instanceof IAdaptable && (view = (View)((IAdaptable)element).getAdapter(View.class)) != null) {
            return this.unwrapView(view);
        }
        return element;
    }

    private Object unwrapEditPart(EditPart p) {
        if (p.getModel() instanceof View) {
            return this.unwrapView((View)p.getModel());
        }
        return p.getModel();
    }

    private Object unwrapView(View view) {
        return view.getElement() == null ? view : view.getElement();
    }
}

