/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.api.menu;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.sirius.editor.tools.api.menu.AbstractMenuBuilder;

public abstract class AbstractTypeRestrictingMenuBuilder
extends AbstractMenuBuilder {
    private final Collection<EClassifier> valids = new HashSet<EClassifier>();
    private final Collection<EClassifier> restricted = new HashSet<EClassifier>();

    protected void addValidType(EClassifier clazz) {
        this.valids.add(clazz);
    }

    protected void addRestrictedType(EClassifier clazz) {
        this.restricted.add(clazz);
    }

    @Override
    protected boolean isMine(CommandParameter object) {
        if (object.getEReference() != null && this.valids.size() + this.restricted.size() > 0) {
            EObject value = (EObject)object.getValue();
            return this.isMyTargetType(value);
        }
        return true;
    }

    private boolean isMyTargetType(EObject value) {
        boolean isContainedInValid = false;
        boolean isContainedInRestritected = false;
        for (EClassifier valid : this.valids) {
            if (!(valid instanceof EClass) || !this.instance((EClass)valid, value)) continue;
            isContainedInValid = true;
        }
        if (isContainedInValid) {
            for (EClassifier valid : this.restricted) {
                if (!(valid instanceof EClass) || !this.instance((EClass)valid, value)) continue;
                isContainedInRestritected = true;
            }
        }
        return isContainedInValid && !isContainedInRestritected;
    }

    private boolean instance(EClass valid, EObject type) {
        return type.eClass() == valid || valid.isSuperTypeOf(type.eClass());
    }
}

