/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.business.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceFinder
implements IResourceVisitor {
    private static final String FILE_SEPARATOR_REGEX = "/|\\\\";
    protected final String[] path;
    private final List<IResource> matches = new ArrayList<IResource>();

    public ResourceFinder(String path) {
        this.path = path.split(FILE_SEPARATOR_REGEX);
    }

    public List<IResource> getMatches() {
        return this.matches;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (this.path.length == 0) {
            return false;
        }
        if (this.isCandidate(resource)) {
            this.matches.add(resource);
        }
        return true;
    }

    protected boolean isCandidate(IResource resource) {
        if (this.path.length == 0) {
            return false;
        }
        boolean isCandidate = false;
        if (this.path[this.path.length - 1].equals(resource.getName())) {
            isCandidate = true;
            IContainer container = resource.getParent();
            int i = this.path.length - 2;
            while (i >= 0 && container != null && isCandidate) {
                if (!this.path[i].equals(container.getName())) {
                    isCandidate = false;
                }
                container = container.getParent();
                --i;
            }
        }
        return isCandidate;
    }
}

