/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.junit.Assert;

public abstract class AbstractInterpretedExpressionTestCase
extends TestCase {
    private static final String RETURN_TYPE = "http://www.eclipse.org/sirius/interpreted/expression/returnType";
    private static final String VARIABLES = "http://www.eclipse.org/sirius/interpreted/expression/variables";
    private Collection<EAttribute> interpretedExpressions;
    private EPackage basePackage;
    private final Predicate<EAttribute> isInterpretedExpression = input -> DescriptionPackage.eINSTANCE.getInterpretedExpression().equals(input.getEAttributeType());

    public EPackage getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(EPackage basePackage) {
        this.basePackage = basePackage;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpretedExpressions = new LinkedHashSet<EAttribute>();
        Assert.assertNotNull((String)"Base package should not be null.", (Object)this.basePackage);
        this.handleEPackage(this.basePackage);
    }

    private void handleEPackage(EPackage pkg) {
        for (EClassifier classifier : pkg.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            this.handleEClass((EClass)classifier);
        }
        for (EPackage subPkg : pkg.getESubpackages()) {
            this.handleEPackage(subPkg);
        }
    }

    private void handleEClass(EClass eclass) {
        eclass.getEAttributes().stream().filter(this.isInterpretedExpression).forEach(this.interpretedExpressions::add);
    }

    public void testVariableTypesInterpretedExpressionEAnnotation() {
        HashMap<EAttribute, List<String>> wrongTypes = new HashMap<EAttribute, List<String>>();
        for (EAttribute attr : this.interpretedExpressions) {
            EAnnotation varAnnotations = attr.getEAnnotation(VARIABLES);
            if (varAnnotations == null) continue;
            for (String varName : varAnnotations.getDetails().keySet()) {
                String typeName;
                String errorMessage;
                String doc = (String)varAnnotations.getDetails().get((Object)varName);
                if (doc == null || doc.indexOf("|") == -1 || (errorMessage = this.validateVariableType(typeName = doc.substring(0, doc.indexOf("|")).trim())) == null) continue;
                if (!wrongTypes.containsKey(attr)) {
                    wrongTypes.put(attr, new ArrayList());
                }
                ((List)wrongTypes.get(attr)).add(varName + ":" + typeName + " > " + errorMessage);
            }
        }
        Assert.assertTrue((String)this.getMessage(wrongTypes), (boolean)wrongTypes.isEmpty());
    }

    private String getMessage(Map<EAttribute, List<String>> wrongTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(wrongTypes.size());
        sb.append(" variable(s) available in interpreted expressions need type correction:");
        for (EAttribute attr : wrongTypes.keySet()) {
            sb.append("\n . ");
            sb.append(attr.eResource().getURIFragment((EObject)attr));
            for (String v : wrongTypes.get(attr)) {
                sb.append("\n   . " + v);
            }
        }
        return sb.toString();
    }

    private String validateVariableType(String typeName) {
        Object errorMessage = "cannot be checked, the test method must be improved";
        if ("ecore.EObject".equals(typeName) || "EObject".equals(typeName)) {
            errorMessage = null;
        } else {
            EClassifier eClassifier;
            int indexOf = typeName.indexOf(".");
            String pName = typeName.substring(0, indexOf).trim();
            String cName = typeName.substring(indexOf + 1).trim();
            EPackage ePackage = this.getEPackage(pName, this.getAvailablePackages());
            errorMessage = ePackage != null ? ((eClassifier = ePackage.getEClassifier(cName)) == null ? "the EClass " + cName + " has not been found in the indicated EPackage." : null) : "the EPackage" + pName + " might not be accessible for the expression.";
        }
        return errorMessage;
    }

    private Collection<EPackage> getAvailablePackages() {
        LinkedHashSet<EPackage> availablePackages = new LinkedHashSet<EPackage>();
        availablePackages.add(this.basePackage);
        availablePackages.add(this.getDialectPackage());
        availablePackages.add((EPackage)ViewpointPackage.eINSTANCE);
        return availablePackages;
    }

    protected EPackage getDialectPackage() {
        return this.getBasePackage();
    }

    private EPackage getEPackage(String pName, Collection<EPackage> packages) {
        EPackage found = null;
        for (EPackage p : packages) {
            found = p.getName().equals(pName) ? p : this.getEPackage(pName, (Collection<EPackage>)p.getESubpackages());
            if (found != null) break;
        }
        return found;
    }

    public void testVariablesInInterpretedExpressionEAnnotation() {
        Predicate<EAttribute> needsDocumentation = input -> input.getEAnnotation(VARIABLES) == null;
        List<EAttribute> nonDocumented = this.interpretedExpressions.stream().filter(needsDocumentation).collect(Collectors.toList());
        nonDocumented.remove(ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__ELEMENTS_TO_SELECT);
        Assert.assertTrue((String)this.getMessage(nonDocumented, VARIABLES), (boolean)nonDocumented.isEmpty());
    }

    public void testReturnTypeInterpretedExpressionEAnnotation() {
        Predicate<EAttribute> needsReturnType = input -> {
            EAnnotation eAnnotation = input.getEAnnotation(RETURN_TYPE);
            return eAnnotation == null || eAnnotation.getDetails().isEmpty();
        };
        List<EAttribute> nonDocumented = this.interpretedExpressions.stream().filter(needsReturnType).collect(Collectors.toList());
        Assert.assertTrue((String)this.getMessage(nonDocumented, RETURN_TYPE), (boolean)nonDocumented.isEmpty());
    }

    private String getMessage(List<EAttribute> nonDocumented, String source) {
        StringBuilder sb = new StringBuilder();
        sb.append(nonDocumented.size());
        sb.append(" interpreted expression(s) needs variable EAnnotation ");
        sb.append(source);
        sb.append(": ");
        for (EAttribute attr : nonDocumented) {
            sb.append("\n . ");
            sb.append(attr.eResource().getURIFragment((EObject)attr));
        }
        return sb.toString();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.interpretedExpressions.clear();
    }

    protected void assertVariableExistence(AbstractToolDescription tool, String expectedVariable, Set<String> variables) {
        AbstractInterpretedExpressionTestCase.assertTrue((String)("The interpreter context for " + tool.getName() + " should contains the variable " + expectedVariable), (boolean)variables.contains(expectedVariable));
    }

    protected void assertVariableExistenceAndType(AbstractToolDescription tool, String expectedVariable, String expectedType, Set<String> variables, Map<String, VariableType> variablesToType) {
        this.assertVariableExistenceAndType(tool, expectedVariable, VariableType.fromString((String)expectedType), variables, variablesToType);
    }

    protected void assertVariableExistenceAndType(AbstractToolDescription tool, String expectedVariable, VariableType expectedType, Set<String> variables, Map<String, VariableType> variablesToType) {
        this.assertVariableExistence(tool, expectedVariable, variables);
        Set acceptableTypesNames = expectedType.getPossibleTypes().stream().map(TypeName::toString).collect(Collectors.toSet());
        Set actualVariableTypesNames = variablesToType.get(expectedVariable).getPossibleTypes().stream().map(TypeName::toString).collect(Collectors.toSet());
        boolean areSameSets = acceptableTypesNames.equals(actualVariableTypesNames);
        AbstractInterpretedExpressionTestCase.assertTrue((String)("The interpreter context for " + tool.eClass().getName() + " has a bad variable type for variable expected:" + expectedVariable + " " + expectedType.toString() + " got instead: " + variablesToType.get(expectedVariable).toString()), (boolean)areSameSets);
    }
}

