/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.parser;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileVersionSAXParser;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.IdentifiedElement;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.osgi.framework.Version;

public class RepresentationsFileXMIHelper
extends XMIHelperImpl {
    private static final String REPRESENTATION_NAME_FEATURE_LABEL = "name";
    private static final String REPRESENTATION_DOCUMENTATION_FEATURE_LABEL = "documentation";
    private static final String PLATFORM_SCHEME = "platform";
    private String version;
    private boolean migrationNeeded;

    public RepresentationsFileXMIHelper(XMLResource resource) {
        super(resource);
        RepresentationsFileVersionSAXParser parser = new RepresentationsFileVersionSAXParser(resource.getURI());
        this.version = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        this.migrationNeeded = RepresentationsFileMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)this.version));
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (this.migrationNeeded) {
            Object newValue = RepresentationsFileMigrationService.getInstance().getValue(object, feature, value, this.version);
            if (newValue != null) {
                super.setValue(object, feature, newValue, position);
            } else if (!(object instanceof DRepresentation) || !REPRESENTATION_NAME_FEATURE_LABEL.equals(feature.getName()) && !REPRESENTATION_DOCUMENTATION_FEATURE_LABEL.equals(feature.getName())) {
                super.setValue(object, feature, value, position);
            }
        } else {
            super.setValue(object, feature, value, position);
        }
    }

    public EObject createObject(EFactory eFactory, EClassifier type) {
        EFactory factory = eFactory;
        if (this.migrationNeeded && type != null && type.getEPackage() != null && type.getEPackage().getEFactoryInstance() != null) {
            factory = type.getEPackage().getEFactoryInstance();
        }
        EObject newObject = super.createObject(factory, type);
        if (this.migrationNeeded) {
            newObject = RepresentationsFileMigrationService.getInstance().updateCreatedObject(newObject, this.version);
        }
        return newObject;
    }

    public URI deresolve(URI uri) {
        if (PLATFORM_SCHEME.equals(uri.scheme()) && PLATFORM_SCHEME.equals(this.resourceURI.scheme()) && uri.segmentCount() > 2 && this.resourceURI.segmentCount() > 2 && (!uri.segments()[0].equals(this.resourceURI.segments()[0]) || !uri.segments()[1].equals(this.resourceURI.segments()[1]))) {
            return uri;
        }
        return super.deresolve(uri);
    }

    public String convertToString(EFactory factory, EDataType dataType, Object value) {
        URI deresolvedURI;
        String str = null;
        if (dataType.equals(ViewpointPackage.eINSTANCE.getResourceDescriptor()) && (deresolvedURI = this.deresolve(((ResourceDescriptor)value).getResourceURI())) != null) {
            str = deresolvedURI.toString();
        }
        return str != null ? str : super.convertToString(factory, dataType, value);
    }

    protected Object createFromString(EFactory eFactory, EDataType eDataType, String value) {
        if (value != null && eDataType.equals(ViewpointPackage.eINSTANCE.getResourceDescriptor())) {
            URI resolvedURI = new ResourceDescriptor(value).getResourceURI().resolve(this.resourceURI);
            return new ResourceDescriptor(resolvedURI);
        }
        return super.createFromString(eFactory, eDataType, value);
    }

    public String getID(EObject obj) {
        if (obj instanceof IdentifiedElement && ((IdentifiedElement)obj).getUid() != null) {
            return null;
        }
        return super.getID(obj);
    }
}

