/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.model.business.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.model.business.internal.DRepresentationDescriptorAdapter;
import org.eclipse.sirius.model.business.internal.query.DRepresentationInternalQueryHelper;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DAnnotation;

public class DRepresentationInternalQuery {
    protected final DRepresentation representation;

    public DRepresentationInternalQuery(DRepresentation representation) {
        this.representation = representation;
    }

    public DRepresentation getRepresentation() {
        return this.representation;
    }

    public Option<AnnotationEntry> getAnnotation(String source, EObject eObject) {
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource()) || !eObject.equals(annotation.getData())) continue;
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public Collection<AnnotationEntry> getAnnotation(String source) {
        ArrayList<AnnotationEntry> annotationEntries = new ArrayList<AnnotationEntry>();
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource())) continue;
            annotationEntries.add(annotation);
        }
        return annotationEntries;
    }

    public Option<DAnnotation> getDAnnotation(String source, String detail) {
        DAnnotation annotation = this.representation.getDAnnotation(source);
        if (annotation != null && annotation.getDetails().get((Object)detail) != null) {
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public DRepresentationDescriptor getRepresentationDescriptor() {
        DRepresentationDescriptor result = null;
        if (this.representation != null) {
            Optional<DRepresentationDescriptorAdapter> optionalRepDesc = this.representation.eAdapters().stream().filter(a -> a instanceof DRepresentationDescriptorAdapter).map(DRepresentationDescriptorAdapter.class::cast).findFirst();
            if (optionalRepDesc.isPresent()) {
                return optionalRepDesc.get().getdRepresentationDescriptor();
            }
            if (this.representation instanceof DSemanticDecorator) {
                if (DRepresentationInternalQueryHelper.getInstance().hasSession(this)) {
                    result = this.findDescriptorFromCrossReferencer();
                    if (result == null) {
                        result = this.findDescriptorFromAnalysis();
                    }
                } else {
                    result = this.findDescriptorFromEResource();
                }
                if (result != null) {
                    DRepresentationDescriptorAdapter representationDescriptorAdaptor = new DRepresentationDescriptorAdapter(result);
                    this.representation.eAdapters().add((Object)representationDescriptorAdaptor);
                }
            }
        }
        return result;
    }

    private DRepresentationDescriptor findDescriptorFromAnalysis() {
        DRepresentationDescriptor result = null;
        Collection<DAnalysis> allAnalyses = DRepresentationInternalQueryHelper.getInstance().getAllAnalyses(this);
        for (DAnalysis dAnalysis : allAnalyses) {
            result = this.findDescriptorFromAnalysis(dAnalysis);
            if (result != null) break;
        }
        return result;
    }

    private DRepresentationDescriptor findDescriptorFromEResource() {
        DRepresentationDescriptor result = null;
        Resource eResource = this.representation.eResource();
        if (eResource != null && eResource.getContents() != null) {
            for (EObject content : eResource.getContents()) {
                if (content instanceof DAnalysis) {
                    result = this.findDescriptorFromAnalysis((DAnalysis)content);
                }
                if (result != null) break;
            }
        }
        return result;
    }

    public DRepresentationDescriptor findDescriptorFromAnalysis(DAnalysis dAnalysis) {
        if (this.representation.eResource() != null) {
            EList<DView> ownedViews = dAnalysis.getOwnedViews();
            for (DView view : ownedViews) {
                EList<DRepresentationDescriptor> ownedRepresentationDescriptors = view.getOwnedRepresentationDescriptors();
                for (DRepresentationDescriptor descriptor : ownedRepresentationDescriptors) {
                    DRepresentation representationTemp;
                    if (!descriptor.isLoadedRepresentation() || !this.representation.equals(representationTemp = descriptor.getRepresentation())) continue;
                    return descriptor;
                }
            }
        }
        return null;
    }

    private DRepresentationDescriptor findDescriptorFromCrossReferencer() {
        DRepresentationDescriptor result = null;
        ECrossReferenceAdapter crossReferencer = DRepresentationInternalQueryHelper.getInstance().getCrossReferencer(this);
        if (crossReferencer != null) {
            Collection usages = crossReferencer.getInverseReferences((EObject)this.representation);
            for (EStructuralFeature.Setting setting : usages) {
                if (!ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR.isInstance((Object)setting.getEObject()) || setting.getEStructuralFeature() != ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__REPRESENTATION) continue;
                result = (DRepresentationDescriptor)setting.getEObject();
                break;
            }
        }
        return result;
    }
}

