/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.style.basiclabelstyledescription;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractCheckBoxGroupPropertySection;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicLabelStyleDescriptionLabelFormatPropertySectionSpec
extends AbstractCheckBoxGroupPropertySection {
    private static final String BOLD = "Bold";
    private static final String ITALIC = "Italic";
    private static final String UNDERLINE = "Underline";
    private static final String STRIKE_THROUGH = "Strike through";
    private static final String TOOL_TIP = "The font formatting style to use for the label";

    public BasicLabelStyleDescriptionLabelFormatPropertySectionSpec() {
        this.buttonGroup = false;
    }

    @Override
    protected boolean isEqual(List<?> newList) {
        List<String> value = BasicLabelStyleDescriptionLabelFormatPropertySectionSpec.convertPropertiesToUI((List<FontFormat>)((BasicLabelStyleDescription)this.eObject).getLabelFormat());
        return value.equals(newList);
    }

    @Override
    protected List<?> getChoiceOfValues() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(BOLD);
        values.add(ITALIC);
        values.add(UNDERLINE);
        values.add(STRIKE_THROUGH);
        return values;
    }

    protected List<FontFormat> getSelectedValue() {
        List<?> possibleValues = this.getChoiceOfValues();
        ArrayList selectedValues = new ArrayList();
        ArrayList<FontFormat> fontFormat = new ArrayList<FontFormat>();
        int i = 0;
        while (i < this.button.length) {
            if (this.button[i].getSelection()) {
                selectedValues.add(possibleValues.get(i));
            }
            ++i;
        }
        if (selectedValues.size() > 0) {
            for (Object selectedValue : selectedValues) {
                if (selectedValue.equals(ITALIC)) {
                    fontFormat.add(FontFormat.ITALIC_LITERAL);
                }
                if (selectedValue.equals(BOLD)) {
                    fontFormat.add(FontFormat.BOLD_LITERAL);
                }
                if (selectedValue.equals(UNDERLINE)) {
                    fontFormat.add(FontFormat.UNDERLINE_LITERAL);
                }
                if (!selectedValue.equals(STRIKE_THROUGH)) continue;
                fontFormat.add(FontFormat.STRIKE_THROUGH_LITERAL);
            }
        }
        return fontFormat;
    }

    @Override
    protected EStructuralFeature getFeature() {
        return StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelFormat();
    }

    @Override
    protected String getDefaultLabelText() {
        return "Label Format";
    }

    @Override
    protected String getFeatureAsText() {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            String featureText = propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet(eFeature));
            return featureText;
        }
        return this.getDefaultFeatureAsText();
    }

    @Override
    protected String getDefaultFeatureAsText() {
        Object returnStr = "";
        if (this.eObject instanceof BasicLabelStyleDescription) {
            for (String str : BasicLabelStyleDescriptionLabelFormatPropertySectionSpec.convertPropertiesToUI((List<FontFormat>)((BasicLabelStyleDescription)this.eObject).getLabelFormat())) {
                returnStr = ((String)returnStr).length() > 0 ? (String)returnStr + ", " + str : str;
            }
        }
        return returnStr;
    }

    @Override
    protected String getLabelText() {
        return super.getLabelText() + ":";
    }

    protected EEnum getFeatures() {
        return ViewpointPackage.eINSTANCE.getFontFormat();
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite fakeGroup = this.getWidgetFactory().createComposite(this.composite);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = 0;
        rowLayout.spacing = 5;
        fakeGroup.setLayout((Layout)rowLayout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        fakeGroup.setLayoutData((Object)data);
        int i = 0;
        while (i < this.button.length) {
            this.button[i].setParent(fakeGroup);
            this.button[i].setLayoutData(null);
            ++i;
        }
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)fakeGroup, -25);
        data.top = new FormAttachment((Control)fakeGroup, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.nameLabel.setToolTipText(TOOL_TIP);
        data = new FormData();
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        data.top = new FormAttachment((Control)this.nameLabel, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setImage(this.getHelpIcon());
        help.setToolTipText(TOOL_TIP);
    }

    @Override
    public void handleSelectionChanged() {
        boolean equals = this.isEqual(this.getSelectedValues());
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            List<FontFormat> value = this.getSelectedValue();
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    protected EAttribute getAttribute() {
        EAttribute attribute = null;
        for (EAttribute eAttribute : ViewpointPackage.eINSTANCE.getBasicLabelStyle().getEAllAttributes()) {
            if (!eAttribute.getEType().equals(this.getFeatures())) continue;
            attribute = eAttribute;
            break;
        }
        return attribute;
    }

    public static List<String> convertPropertiesToUI(List<FontFormat> font) {
        ArrayList<String> formats = new ArrayList<String>();
        for (FontFormat format : font) {
            if (format.getValue() == 1) {
                formats.add(ITALIC);
                continue;
            }
            if (format.getValue() == 2) {
                formats.add(BOLD);
                continue;
            }
            if (format.getValue() == 3) {
                formats.add(UNDERLINE);
                continue;
            }
            if (format.getValue() != 4) continue;
            formats.add(STRIKE_THROUGH);
        }
        return formats;
    }
}

