/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils.tree;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.ui.tools.api.editor.DTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.utils.TreeColumnWidthQuery;
import org.eclipse.sirius.table.ui.tools.internal.editor.utils.TreeColumnWidthSetter;
import org.eclipse.sirius.tests.support.api.TreeItemImageQuery;
import org.eclipse.sirius.tests.support.api.TreeItemLabelFontFormatQuery;
import org.eclipse.sirius.tests.swtbot.support.api.widget.TreeItemBackgroundColorQuery;
import org.eclipse.sirius.tests.swtbot.support.api.widget.TreeItemExpandedQuery;
import org.eclipse.sirius.tests.swtbot.support.api.widget.TreeItemExpander;
import org.eclipse.sirius.tests.swtbot.support.api.widget.TreeItemLabelColorQuery;
import org.eclipse.sirius.tests.swtbot.support.api.widget.TreeItemLabelSizeQuery;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.tree.ui.tools.api.editor.DTreeEditor;
import org.eclipse.sirius.ui.tools.internal.util.ItemSearcher;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.ui.IEditorReference;
import org.junit.Assert;

public final class TreeUtils {
    private static final String COLLAPSE = "collapse";
    private static final String EXPANDED = "expanded";

    private TreeUtils() {
    }

    public static void changeDLineCollapse(DLine dLine, boolean collapse) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)dLine);
        CommandStack commandStack = transactionalEditingDomain.getCommandStack();
        Command expandCarDTreeItemCmd = SetCommand.create((EditingDomain)transactionalEditingDomain, (Object)dLine, (Object)TablePackage.Literals.DLINE__COLLAPSED, (Object)collapse);
        commandStack.execute(expandCarDTreeItemCmd);
    }

    public static void changeDTreeItemExpansion(DTreeItem dTreeItem, boolean expand) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)dTreeItem);
        CommandStack commandStack = transactionalEditingDomain.getCommandStack();
        Command expandCarDTreeItemCmd = SetCommand.create((EditingDomain)transactionalEditingDomain, (Object)dTreeItem, (Object)TreePackage.Literals.DTREE_ITEM__EXPANDED, (Object)expand);
        commandStack.execute(expandCarDTreeItemCmd);
    }

    public static void collapseTreeItem(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        TreeUtils.changeExpansionTreeItem(swtBotTreeEditor, dTreeItem, false);
    }

    public static void expandTreeItem(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        TreeUtils.changeExpansionTreeItem(swtBotTreeEditor, dTreeItem, true);
    }

    public static void changeExpansionTreeItem(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem, boolean expansion) {
        DTreeEditor dTreeEditor = (DTreeEditor)((IEditorReference)swtBotTreeEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTreeEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dTreeItem);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        TreeItem treeItem = (TreeItem)itemSearcher.getResult();
        TreeItemExpander treeItemExpander = new TreeItemExpander(treeItem, expansion);
        Display.getDefault().syncExec((Runnable)treeItemExpander);
        SWTBotUtils.waitProgressMonitorClose("Progress Information");
    }

    public static void collapseTreeItem(SWTBotEditor swtBotTableEditor, DLine dLine) {
        TreeUtils.changeExpansionTreeItem(swtBotTableEditor, dLine, false);
    }

    public static void expandTreeItem(SWTBotEditor swtBotTableEditor, DLine dLine) {
        TreeUtils.changeExpansionTreeItem(swtBotTableEditor, dLine, true);
    }

    public static void changeExpansionTreeItem(SWTBotEditor swtBotTableEditor, DLine dLine, boolean expansion) {
        DTableEditor dTableEditor = (DTableEditor)((IEditorReference)swtBotTableEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTableEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dLine);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        TreeItem treeItem = (TreeItem)itemSearcher.getResult();
        TreeItemExpander treeItemExpander = new TreeItemExpander(treeItem, expansion);
        Display.getDefault().syncExec((Runnable)treeItemExpander);
    }

    public static void checkTreeItemExpansion(SWTBotEditor swtBotTableEditor, DLine dLine) {
        boolean collapsed = dLine.isCollapsed();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTableEditor, dLine);
        boolean widgetExpansion = TreeUtils.getWidgetExpansion(treeItem);
        Assert.assertEquals((String)("As the DLine is " + (collapsed ? COLLAPSE : EXPANDED) + ", its TreeItem should be also " + (collapsed ? COLLAPSE : EXPANDED)), (Object)(!collapsed ? 1 : 0), (Object)widgetExpansion);
    }

    public static void checkTreeItemCollapse(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        boolean expanded = dTreeItem.isExpanded();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTreeEditor, dTreeItem);
        boolean widgetExpansion = TreeUtils.getWidgetExpansion(treeItem);
        Assert.assertEquals((String)("As the DTreeitem is " + (expanded ? EXPANDED : COLLAPSE) + ", its TreeItem should be also " + (expanded ? EXPANDED : COLLAPSE)), (Object)expanded, (Object)widgetExpansion);
    }

    public static void changeDTreeItemBackgroundColor(DTreeItem dTreeItem, RGBValues newBackgroundColor) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)dTreeItem);
        CommandStack commandStack = transactionalEditingDomain.getCommandStack();
        Command changeDTreeItemBackgroundColorCmd = SetCommand.create((EditingDomain)transactionalEditingDomain, (Object)dTreeItem.getOwnedStyle(), (Object)TreePackage.Literals.TREE_ITEM_STYLE__BACKGROUND_COLOR, (Object)newBackgroundColor);
        commandStack.execute(changeDTreeItemBackgroundColorCmd);
    }

    public static void checkTreeItemBackgroundColor(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        RGBValues backgroundColor = dTreeItem.getOwnedStyle().getBackgroundColor();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTreeEditor, dTreeItem);
        RGBValues widgetBackgroundColor = TreeUtils.getWidgetBackgroundColor(treeItem);
        String backgroundColorMessage = "\t DTreeItem.backgroundColor : (" + backgroundColor.getRed() + "," + backgroundColor.getGreen() + "," + backgroundColor.getBlue() + ")\n";
        String widgetBackgroundColorMessage = "\t SWTTreeItem.backgroundColor : (" + widgetBackgroundColor.getRed() + "," + widgetBackgroundColor.getGreen() + "," + widgetBackgroundColor.getBlue() + ")\n";
        String failureMessage = "The background color from the DTreeItem and this from the swt widget differs : \n" + backgroundColorMessage + widgetBackgroundColorMessage;
        Assert.assertEquals((String)failureMessage, (long)backgroundColor.getRed(), (long)widgetBackgroundColor.getRed());
        Assert.assertEquals((String)failureMessage, (long)backgroundColor.getGreen(), (long)widgetBackgroundColor.getGreen());
        Assert.assertEquals((String)failureMessage, (long)backgroundColor.getBlue(), (long)widgetBackgroundColor.getBlue());
    }

    public static void checkTreeItemBackgroundColor(SWTBotEditor swtBotTableEditor, DCell dCell) {
        Option optionalBackgroundStyleToApply = new DCellQuery(dCell).getBackgroundStyleToApply();
        Assert.assertTrue((String)"We should have a background style for the cell.", (boolean)optionalBackgroundStyleToApply.some());
        RGBValues backgroundColor = ((DTableElementStyle)optionalBackgroundStyleToApply.get()).getBackgroundColor();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTableEditor, dCell.getLine());
        int dCellIndex = new DCellQuery(dCell).getColumnIndex();
        RGBValues widgetBackgroundColor = TreeUtils.getWidgetBackgroundColor(treeItem, dCellIndex + 1);
        String backgroundColorMessage = "\t DCellStyle.backgroundColor : (" + backgroundColor.getRed() + "," + backgroundColor.getGreen() + "," + backgroundColor.getBlue() + ")\n";
        String widgetBackgroundColorMessage = "\t SWTTreeItem.backgroundColor : (" + widgetBackgroundColor.getRed() + "," + widgetBackgroundColor.getGreen() + "," + widgetBackgroundColor.getBlue() + ")\n";
        String failureMessage = "The background color from the DCellStyle and this from the swt widget differs : \n" + backgroundColorMessage + widgetBackgroundColorMessage;
        Assert.assertEquals((String)failureMessage, (long)backgroundColor.getRed(), (long)widgetBackgroundColor.getRed());
        Assert.assertEquals((String)failureMessage, (long)backgroundColor.getGreen(), (long)widgetBackgroundColor.getGreen());
        Assert.assertEquals((String)failureMessage, (long)backgroundColor.getBlue(), (long)widgetBackgroundColor.getBlue());
    }

    public static void checkColumnWidth(SWTBotEditor swtBotTableEditor, DColumn dColumn) {
        int dColumnWidh = dColumn.getWidth();
        int treeColumnWidth = TreeUtils.getColumnWidth(swtBotTableEditor, dColumn);
        Assert.assertEquals((String)"The TreeColumn width should corresponds to its DColumn.width", (long)dColumnWidh, (long)treeColumnWidth);
    }

    public static void checkTreeItemLabelSize(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        int labelSize = dTreeItem.getOwnedStyle().getLabelSize();
        TreeUtils.checkTreeItemLabelSize(swtBotTreeEditor, dTreeItem, labelSize);
    }

    public static void checkTreeItemLabelSize(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem, int expectedLabelSize) {
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTreeEditor, dTreeItem);
        int treeItemLabelSize = TreeUtils.getWidgetLabelSize(treeItem);
        Assert.assertEquals((String)"The TreeItem label size should corresponds to its DTreeItem.ownedStyle.labelSize", (long)expectedLabelSize, (long)treeItemLabelSize);
    }

    public static void checkTreeItemLabelSize(SWTBotEditor swtBotTableEditor, DCell dCell) {
        Option optionalForegroundStyleToApply = new DCellQuery(dCell).getForegroundStyleToApply();
        Assert.assertTrue((String)"We should have a foreground Style for the cell.", (boolean)optionalForegroundStyleToApply.some());
        int labelSize = ((DTableElementStyle)optionalForegroundStyleToApply.get()).getLabelSize();
        TreeUtils.checkTreeItemLabelSize(swtBotTableEditor, dCell, labelSize);
    }

    public static void checkTreeItemLabelSize(SWTBotEditor swtBotTableEditor, DCell dCell, int expectedLabelSize) {
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTableEditor, dCell.getLine());
        int dCellIndex = new DCellQuery(dCell).getColumnIndex();
        int treeItemLabelSize = TreeUtils.getWidgetLabelSize(treeItem, dCellIndex + 1);
        Assert.assertEquals((String)"The TreeItem label size should corresponds to its DCell.currentStyle.labelSize", (long)expectedLabelSize, (long)treeItemLabelSize);
    }

    public static void checkTreeItemLabelFormat(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        EList fontFormat = dTreeItem.getOwnedStyle().getLabelFormat();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTreeEditor, dTreeItem);
        List<FontFormat> widgetFontFormat = TreeUtils.getWidgetLabelFormat(treeItem);
        Assert.assertEquals((String)"The TreeItem label font format should corresponds to its DTreeItem.ownedStyle.fontFormat", (Object)fontFormat, widgetFontFormat);
    }

    public static void checkTreeItemLabelFormat(SWTBotEditor swtBotTableEditor, DCell dCell) {
        Option optionalForegroundStyleToApply = new DCellQuery(dCell).getForegroundStyleToApply();
        Assert.assertTrue((String)"We should have a currentStyle for the cell.", (boolean)optionalForegroundStyleToApply.some());
        EList fontFormat = ((DTableElementStyle)optionalForegroundStyleToApply.get()).getLabelFormat();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTableEditor, dCell.getLine());
        int dCellIndex = new DCellQuery(dCell).getColumnIndex();
        List<FontFormat> widgetFontFormat = TreeUtils.getWidgetLabelFormat(treeItem, dCellIndex + 1);
        Assert.assertEquals((String)"The TreeItem label font format should corresponds to its DCell.currentStyle.fontFormat", (Object)fontFormat, widgetFontFormat);
    }

    public static void checkTreeItemShowIcon(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        boolean showIcon = dTreeItem.getOwnedStyle().isShowIcon();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTreeEditor, dTreeItem);
        boolean widgetShowIcon = TreeUtils.hasWidgetWithIcon(treeItem);
        Assert.assertEquals((String)"The TreeItem.image nullity should corresponds to its DTreeItem.ownedStyle.showIcon", (Object)showIcon, (Object)widgetShowIcon);
    }

    public static void checkTreeItemLabelColor(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        RGBValues labelColor = dTreeItem.getOwnedStyle().getLabelColor();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTreeEditor, dTreeItem);
        RGBValues widgetLabelColor = TreeUtils.getWidgetLabelColor(treeItem);
        String backgroundColorMessage = "\t DTreeItem.ownedStyle.labelColor : (" + labelColor.getRed() + "," + labelColor.getGreen() + "," + labelColor.getBlue() + ")\n";
        String widgetBackgroundColorMessage = "\t SWTTreeItem.backgroundColor : (" + widgetLabelColor.getRed() + "," + widgetLabelColor.getGreen() + "," + widgetLabelColor.getBlue() + ")\n";
        String failureMessage = "The label color from the DTreeItem and this from the swt widget differs : \n" + backgroundColorMessage + widgetBackgroundColorMessage;
        Assert.assertEquals((String)failureMessage, (long)labelColor.getRed(), (long)widgetLabelColor.getRed());
        Assert.assertEquals((String)failureMessage, (long)labelColor.getGreen(), (long)widgetLabelColor.getGreen());
        Assert.assertEquals((String)failureMessage, (long)labelColor.getBlue(), (long)widgetLabelColor.getBlue());
    }

    public static void checkTreeItemLabelColor(SWTBotEditor swtBotTableEditor, DCell dCell) {
        Option optionalForegroundStyleToApply = new DCellQuery(dCell).getForegroundStyleToApply();
        Assert.assertTrue((String)"We should have a currentStyle for the cell.", (boolean)optionalForegroundStyleToApply.some());
        RGBValues foregroundColor = ((DTableElementStyle)optionalForegroundStyleToApply.get()).getForegroundColor();
        TreeItem treeItem = TreeUtils.getTreeItem(swtBotTableEditor, dCell.getLine());
        int dCellIndex = new DCellQuery(dCell).getColumnIndex();
        RGBValues widgetForegroundColor = TreeUtils.getWidgetLabelColor(treeItem, dCellIndex + 1);
        String backgroundColorMessage = "\t DCellStyle.foregroundColor : (" + foregroundColor.getRed() + "," + foregroundColor.getGreen() + "," + foregroundColor.getBlue() + ")\n";
        String widgetBackgroundColorMessage = "\t SWTTreeItem.oregroundColor : (" + widgetForegroundColor.getRed() + "," + widgetForegroundColor.getGreen() + "," + widgetForegroundColor.getBlue() + ")\n";
        String failureMessage = "The label color from the DCellStyle and this from the swt widget differs : \n" + backgroundColorMessage + widgetBackgroundColorMessage;
        Assert.assertEquals((String)failureMessage, (long)foregroundColor.getRed(), (long)widgetForegroundColor.getRed());
        Assert.assertEquals((String)failureMessage, (long)foregroundColor.getGreen(), (long)widgetForegroundColor.getGreen());
        Assert.assertEquals((String)failureMessage, (long)foregroundColor.getBlue(), (long)widgetForegroundColor.getBlue());
    }

    public static void resizeTreeHeaderColumnWidth(SWTBotEditor swtBotTableEditor, DTable dTable, int newWidth) {
        TreeUtils.resizeTreeColumnWidth(swtBotTableEditor, null, newWidth);
    }

    public static void resizeTreeColumnWidth(SWTBotEditor swtBotTableEditor, DColumn dColumn, int newWidth) {
        DTableEditor dTableEditor = (DTableEditor)((IEditorReference)swtBotTableEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTableEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, null);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        Item item = (Item)itemSearcher.getResult();
        Assert.assertTrue((String)"item should be a TreeColumn", (boolean)(item instanceof TreeColumn));
        TreeColumn treeColumn = (TreeColumn)item;
        TreeColumnWidthSetter treeColumnWidthSetter = new TreeColumnWidthSetter(treeColumn, newWidth);
        Display.getDefault().syncExec((Runnable)treeColumnWidthSetter);
    }

    public static void checkTreeHeaderColumnWidth(SWTBotEditor swtBotTableEditor, DTable dTable) {
        int widgetHeaderColumnWidth = TreeUtils.getColumnWidth(swtBotTableEditor, null);
        int modelHeaderColumnWidth = dTable.getHeaderColumnWidth();
        Assert.assertEquals((String)"DTable.headerColumnWidth should corresponds to the Tree.treeColumn[0].width", (long)modelHeaderColumnWidth, (long)widgetHeaderColumnWidth);
    }

    public static void checkTreeColumnWidth(SWTBotEditor swtBotTableEditor, DColumn dColumn) {
        int widgetHeaderColumnWidth = TreeUtils.getColumnWidth(swtBotTableEditor, dColumn);
        int modelColumnWidth = dColumn.getWidth();
        Assert.assertEquals((String)"DColumn.width should corresponds to the TreeColumn.width", (long)modelColumnWidth, (long)widgetHeaderColumnWidth);
    }

    private static TreeItem getTreeItem(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        TreeItem treeItem = null;
        DTreeEditor dTreeEditor = (DTreeEditor)((IEditorReference)swtBotTreeEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTreeEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dTreeItem);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        treeItem = (TreeItem)itemSearcher.getResult();
        return treeItem;
    }

    private static TreeItem getTreeItem(SWTBotEditor swtBotTableEditor, DLine dLine) {
        TreeItem treeItem = null;
        DTableEditor dTableEditor = (DTableEditor)((IEditorReference)swtBotTableEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTableEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dLine);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        treeItem = (TreeItem)itemSearcher.getResult();
        return treeItem;
    }

    public static boolean getWidgetExpansion(SWTBotEditor swtBotTableEditor, DLine dLine) {
        boolean widgetExpansion = false;
        DTableEditor dTableEditor = (DTableEditor)((IEditorReference)swtBotTableEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTableEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dLine);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        TreeItem treeItem = (TreeItem)itemSearcher.getResult();
        widgetExpansion = TreeUtils.getWidgetExpansion(treeItem);
        return widgetExpansion;
    }

    public static boolean getWidgetExpansion(SWTBotEditor swtBotTreeEditor, DTreeItem dTreeItem) {
        boolean widgetExpansion = false;
        DTreeEditor dTreeEditor = (DTreeEditor)((IEditorReference)swtBotTreeEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTreeEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dTreeItem);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        TreeItem treeItem = (TreeItem)itemSearcher.getResult();
        widgetExpansion = TreeUtils.getWidgetExpansion(treeItem);
        return widgetExpansion;
    }

    public static int getColumnWidth(SWTBotEditor swtBotTableEditor, DColumn dColumn) {
        int columnWidth = -1;
        DTableEditor dTableEditor = (DTableEditor)((IEditorReference)swtBotTableEditor.getReference()).getEditor(false);
        Tree tree = (Tree)dTableEditor.getControl();
        ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dColumn);
        Display.getDefault().syncExec((Runnable)itemSearcher);
        Item item = (Item)itemSearcher.getResult();
        Assert.assertTrue((String)"item should be a TreeColumn", (boolean)(item instanceof TreeColumn));
        TreeColumn treeColumn = (TreeColumn)item;
        TreeColumnWidthQuery treeColumnWidthQuery = new TreeColumnWidthQuery(treeColumn);
        Display.getDefault().syncExec((Runnable)treeColumnWidthQuery);
        columnWidth = (Integer)treeColumnWidthQuery.getResult();
        return columnWidth;
    }

    public static boolean getWidgetExpansion(TreeItem treeItem) {
        boolean widgetExpansion = false;
        TreeItemExpandedQuery treeItemExpandedQuery = new TreeItemExpandedQuery(treeItem);
        Display.getDefault().syncExec((Runnable)((Object)treeItemExpandedQuery));
        widgetExpansion = (Boolean)treeItemExpandedQuery.getResult();
        return widgetExpansion;
    }

    private static RGBValues getWidgetBackgroundColor(TreeItem treeItem) {
        RGBValues widgetBackgroundColor = TreeUtils.getWidgetBackgroundColor(treeItem, 0);
        return widgetBackgroundColor;
    }

    private static RGBValues getWidgetBackgroundColor(TreeItem treeItem, int index) {
        RGBValues widgetBackgroundColor = null;
        TreeItemBackgroundColorQuery treeItemBackgroundColorQuery = new TreeItemBackgroundColorQuery(treeItem, index);
        Display.getDefault().syncExec((Runnable)((Object)treeItemBackgroundColorQuery));
        widgetBackgroundColor = (RGBValues)treeItemBackgroundColorQuery.getResult();
        return widgetBackgroundColor;
    }

    private static int getWidgetLabelSize(TreeItem treeItem) {
        int widgetLabelSize = TreeUtils.getWidgetLabelSize(treeItem, 0);
        return widgetLabelSize;
    }

    private static int getWidgetLabelSize(TreeItem treeItem, int index) {
        TreeItemLabelSizeQuery treeItemBackgroundColorQuery = new TreeItemLabelSizeQuery(treeItem, index);
        Display.getDefault().syncExec((Runnable)((Object)treeItemBackgroundColorQuery));
        int widgetLabelSize = (Integer)treeItemBackgroundColorQuery.getResult();
        return widgetLabelSize;
    }

    private static List<FontFormat> getWidgetLabelFormat(TreeItem treeItem) {
        List<FontFormat> widgetLabelFormat = TreeUtils.getWidgetLabelFormat(treeItem, 0);
        return widgetLabelFormat;
    }

    private static List<FontFormat> getWidgetLabelFormat(TreeItem treeItem, int index) {
        TreeItemLabelFontFormatQuery treeItemBackgroundColorQuery = new TreeItemLabelFontFormatQuery(treeItem, index);
        Display.getDefault().syncExec((Runnable)treeItemBackgroundColorQuery);
        return (List)treeItemBackgroundColorQuery.getResult();
    }

    private static boolean hasWidgetWithIcon(TreeItem treeItem) {
        boolean hasWidgetWithIcon = false;
        TreeItemImageQuery treeItemImageQuery = new TreeItemImageQuery(treeItem);
        Display.getDefault().syncExec((Runnable)treeItemImageQuery);
        Image result = (Image)treeItemImageQuery.getResult();
        hasWidgetWithIcon = result != null;
        return hasWidgetWithIcon;
    }

    private static RGBValues getWidgetLabelColor(TreeItem treeItem) {
        RGBValues widgetLabelColor = TreeUtils.getWidgetLabelColor(treeItem, 0);
        return widgetLabelColor;
    }

    private static RGBValues getWidgetLabelColor(TreeItem treeItem, int index) {
        RGBValues widgetLabelColor = null;
        TreeItemLabelColorQuery treeItemLabelColorQuery = new TreeItemLabelColorQuery(treeItem, index);
        Display.getDefault().syncExec((Runnable)((Object)treeItemLabelColorQuery));
        widgetLabelColor = (RGBValues)treeItemLabelColorQuery.getResult();
        return widgetLabelColor;
    }
}

