/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.migration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.osgi.framework.Version;

public class GMFLabelStyleMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("10.1.0.201509162000");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)new DViewQuery(dView).getLoadedRepresentations(), DDiagram.class)) {
                    DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(dDiagram);
                    if (!diagramCreationUtil.findAssociatedGMFDiagram()) continue;
                    Diagram gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
                    this.addFontFormatsFromGMFStyle(gmfDiagram);
                }
            }
            super.postLoad(dAnalysis, loadedVersion);
        }
    }

    private void addFontFormatsFromGMFStyle(Diagram gmfDiagram) {
        UnmodifiableIterator iterator = Iterators.filter((Iterator)gmfDiagram.eAllContents(), View.class);
        while (iterator.hasNext()) {
            View view = (View)iterator.next();
            EObject element = view.getElement();
            if (!(element instanceof DDiagramElement)) continue;
            org.eclipse.sirius.viewpoint.Style siriusStyle = ((DDiagramElement)element).getStyle();
            Style style = view.getStyle(NotationPackage.eINSTANCE.getFontStyle());
            if (!(style instanceof FontStyle) || !(siriusStyle instanceof BasicLabelStyle)) continue;
            HashSet<FontFormat> fontFormatToSet = new HashSet<FontFormat>((Collection<FontFormat>)((BasicLabelStyle)siriusStyle).getLabelFormat());
            int initialSize = fontFormatToSet.size();
            if (((FontStyle)style).isStrikeThrough()) {
                fontFormatToSet.add(FontFormat.STRIKE_THROUGH_LITERAL);
            }
            if (((FontStyle)style).isUnderline()) {
                fontFormatToSet.add(FontFormat.UNDERLINE_LITERAL);
            }
            if (initialSize == fontFormatToSet.size()) continue;
            FontFormatHelper.setFontFormat((List)((BasicLabelStyle)siriusStyle).getLabelFormat(), fontFormatToSet);
            String labelFormatFeatureName = ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName();
            if (((BasicLabelStyle)siriusStyle).getCustomFeatures().contains((Object)labelFormatFeatureName)) continue;
            ((BasicLabelStyle)siriusStyle).getCustomFeatures().add((Object)labelFormatFeatureName);
        }
    }
}

