/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;

public class SiriusSelectAllAction
extends DiagramAction {
    private List siriusOperationSet = Collections.EMPTY_LIST;
    private boolean selectShapes;
    private boolean selectConnections;

    private SiriusSelectAllAction(IWorkbenchPage partService, boolean selectShapes, boolean selectConnections) {
        super(partService);
        this.selectShapes = selectShapes;
        this.selectConnections = selectConnections;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList selectables = new ArrayList();
        EditPart primaryEP = (EditPart)selection.get(selection.size() - 1);
        ArrayList nodeEditParts = new ArrayList();
        nodeEditParts.addAll(this.getSelectableNodes(primaryEP));
        if (this.selectShapes) {
            selectables.addAll(nodeEditParts);
        }
        if (this.selectConnections) {
            selectables.addAll(this.addSelectableConnections(nodeEditParts));
        }
        return this.filterEditPartsMatching(selectables, this.getSelectionConditional());
    }

    protected List getSelectableNodes(EditPart editpart) {
        if (editpart == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList retval = new ArrayList();
        this.getSelectableNodesInside(editpart, true, retval);
        return retval;
    }

    private void getSelectableNodesInside(EditPart editpart, boolean topLevel, List retval) {
        if (editpart instanceof ISurfaceEditPart) {
            this.getSelectableChildrenNodes(editpart, retval);
        } else if (editpart instanceof IPrimaryEditPart) {
            if (topLevel) {
                if (editpart instanceof ConnectionEditPart) {
                    ConnectionEditPart connection = (ConnectionEditPart)editpart;
                    EditPart source = connection.getSource();
                    EditPart target = connection.getTarget();
                    if (source != null && target != null) {
                        this.getSelectableNodesInside(source, true, retval);
                        if (target.getParent() != source.getParent()) {
                            this.getSelectableNodesInside(target, true, retval);
                        }
                    }
                } else {
                    this.getSelectableNodesInside(editpart.getParent(), true, retval);
                }
            } else {
                if (editpart.isSelectable()) {
                    retval.add(editpart);
                }
                if (!(editpart instanceof GroupEditPart)) {
                    this.getSelectableChildrenNodes(editpart, retval);
                }
            }
        }
    }

    private void getSelectableChildrenNodes(EditPart editpart, List retval) {
        for (EditPart child : editpart.getChildren()) {
            this.getSelectableNodesInside(child, false, retval);
        }
    }

    private void getBorderItemEditParts(EditPart parent, Set retval) {
        for (EditPart child : parent.getChildren()) {
            if (child instanceof IBorderItemEditPart) {
                retval.add(child);
                retval.addAll(child.getChildren());
            }
            this.getBorderItemEditParts(child, retval);
        }
    }

    protected List addSelectableConnections(List editparts) {
        ArrayList<ConnectionEditPart> selectableConnections = new ArrayList<ConnectionEditPart>();
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        HashSet connnectableEditParts = new HashSet(editparts);
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            EditPart ep = (EditPart)li.next();
            this.getBorderItemEditParts(ep, connnectableEditParts);
            if (!(ep instanceof GroupEditPart)) continue;
            connnectableEditParts.addAll(((GroupEditPart)ep).getShapeChildren());
        }
        if (diagramEditPart != null) {
            for (ConnectionEditPart connection : diagramEditPart.getConnections()) {
                if (!this.canSelectConnection(connection, connnectableEditParts)) continue;
                selectableConnections.add(connection);
            }
        }
        return selectableConnections;
    }

    private boolean canSelectConnection(ConnectionEditPart connection, Set connectableEditParts) {
        EditPart connectionSource = connection.getSource();
        EditPart connectionTarget = connection.getTarget();
        boolean sourceHasSelectable = false;
        boolean targetHasSelectable = false;
        if (connectableEditParts.contains(connectionSource) || connectableEditParts.contains(connectionTarget)) {
            return true;
        }
        if (connectionSource instanceof ConnectionEditPart) {
            sourceHasSelectable = this.canSelectConnection((ConnectionEditPart)connectionSource, connectableEditParts);
        }
        if (!sourceHasSelectable && connectionTarget instanceof ConnectionEditPart) {
            targetHasSelectable = this.canSelectConnection((ConnectionEditPart)connectionTarget, connectableEditParts);
        }
        return sourceHasSelectable || targetHasSelectable;
    }

    protected EditPartViewer.Conditional getSelectionConditional() {
        return new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                return editpart.isSelectable();
            }
        };
    }

    protected boolean calculateEnabled() {
        return !this.getSiriusOperationSet().isEmpty();
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        this.getDiagramGraphicalViewer().setSelection((ISelection)new StructuredSelection(this.getSiriusOperationSet()));
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }

    public static SiriusSelectAllAction createSelectAllAction(IWorkbenchPage partService) {
        SiriusSelectAllAction action = new SiriusSelectAllAction(partService, true, true);
        action.setId(ActionFactory.SELECT_ALL.getId());
        action.setText(DiagramUIActionsMessages.SelectAllAction_SelectAll);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_SelectAll);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL_DISABLED);
        return action;
    }

    public static SiriusSelectAllAction createToolbarSelectAllAction(IWorkbenchPage partService) {
        SiriusSelectAllAction action = new SiriusSelectAllAction(partService, true, true);
        action.setId("siriusToolbarSelectAllAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectAll);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectAll);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL_DISABLED);
        return action;
    }

    public static SiriusSelectAllAction createSelectAllShapesAction(IWorkbenchPage partService) {
        SiriusSelectAllAction action = new SiriusSelectAllAction(partService, true, false);
        action.setId("siriusSelectAllShapesAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_SelectShapes);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_SelectShapes);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES_DISABLED);
        return action;
    }

    public static SiriusSelectAllAction createToolbarSelectAllShapesAction(IWorkbenchPage partService) {
        SiriusSelectAllAction action = new SiriusSelectAllAction(partService, true, false);
        action.setId("siriusToolbarSelectAllShapesAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectShapes);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectShapes);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES_DISABLED);
        return action;
    }

    public static SiriusSelectAllAction createSelectAllConnectionsAction(IWorkbenchPage partService) {
        SiriusSelectAllAction action = new SiriusSelectAllAction(partService, false, true);
        action.setId("siriusSelectAllConnectorsAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_SelectConnections);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_SelectConnections);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS_DISABLED);
        return action;
    }

    public static SiriusSelectAllAction createToolbarSelectAllConnectionsAction(IWorkbenchPage partService) {
        SiriusSelectAllAction action = new SiriusSelectAllAction(partService, false, true);
        action.setId("siriusToolbarSelectAllConnectorsAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectConnections);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectConnections);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS_DISABLED);
        return action;
    }

    public void dispose() {
        super.dispose();
        this.siriusOperationSet = null;
    }

    protected final List getSiriusOperationSet() {
        if (this.siriusOperationSet == null) {
            this.siriusOperationSet = this.createOperationSet();
            if (this.siriusOperationSet == null) {
                this.siriusOperationSet = Collections.EMPTY_LIST;
            }
        }
        return this.siriusOperationSet;
    }

    public void refresh() {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SiriusSelectAllAction.this.internalRefresh();
                }
            });
        } else {
            this.internalRefresh();
        }
    }

    public void internalRefresh() {
        this.siriusOperationSet = null;
        this.updateTargetRequest();
        this.setEnabled(this.calculateEnabled());
    }
}

