/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathWrappingStatus;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class ImagePathConstraint
extends AbstractConstraint {
    private static final String MESSAGE_ITSELF = "{0}";
    private static final String HTML_IMAGE_ABSOLUTE_PATH_PATTERN = "<img.*?src=\"(file:/.*?)\".*?/>";

    public IStatus validate(IValidationContext ctx) {
        ArrayList<IStatus> failureStatuses = new ArrayList<IStatus>();
        if (ctx.getEventType() == EMFEventType.NULL) {
            EObject eObj = ctx.getTarget();
            if (Arrays.asList(ViewpointPackage.eINSTANCE, DiagramPackage.eINSTANCE).contains(eObj.eClass().getEPackage())) {
                if (eObj instanceof DRepresentation) {
                    DRepresentationDescriptor representationDescriptor = new DRepresentationQuery((DRepresentation)eObj).getRepresentationDescriptor();
                    if (representationDescriptor != null) {
                        failureStatuses.addAll(this.validateImagePathInRichText((EObject)representationDescriptor, ctx, ImagePathWrappingStatus.ImagePathTarget.DREPRESENTATION_DESCRIPTOR));
                    }
                } else if (eObj instanceof WorkspaceImage) {
                    this.validateWorkspaceImagePath((WorkspaceImage)eObj, ctx, failureStatuses);
                }
            } else {
                failureStatuses.addAll(this.validateImagePathInRichText(eObj, ctx, ImagePathWrappingStatus.ImagePathTarget.SEMANTIC_TARGET));
            }
        }
        IStatus returnedStatus = null;
        returnedStatus = failureStatuses.isEmpty() ? ctx.createSuccessStatus() : (failureStatuses.size() == 1 ? (IStatus)failureStatuses.get(0) : ConstraintStatus.createMultiStatus((IValidationContext)ctx, failureStatuses));
        return returnedStatus;
    }

    protected void validateWorkspaceImagePath(WorkspaceImage workspaceImage, IValidationContext context, List<IStatus> statuses) {
        boolean exists;
        String workspacePath = workspaceImage.getWorkspacePath();
        if (!workspacePath.startsWith("/") && !(exists = FileProvider.getDefault().exists((IPath)new Path(workspacePath), Session.of((EObject)workspaceImage).get()))) {
            EObject eContainer = workspaceImage.eContainer();
            String repDescName = "";
            if (eContainer instanceof DDiagramElement) {
                DRepresentationDescriptor representationDescriptor = new DRepresentationQuery((DRepresentation)new EObjectQuery(eContainer).getRepresentation().get()).getRepresentationDescriptor();
                repDescName = representationDescriptor.getName();
            }
            String message = MessageFormat.format(Messages.ImagePathConstraint_workspaceImagePathError, workspacePath, new EditingDomainServices().getLabelProviderText(workspaceImage.eContainer()), repDescName);
            ImagePathWrappingStatus failureStatus = new ImagePathWrappingStatus(ConstraintStatus.createStatus((IValidationContext)context, (EObject)workspaceImage.eContainer(), Arrays.asList(context.getTarget()), (String)MESSAGE_ITSELF, (Object[])new Object[]{message}), ImagePathWrappingStatus.ImagePathTarget.WORKSPACE_IMAGE, workspacePath);
            statuses.add((IStatus)failureStatus);
        }
    }

    protected List<IStatus> validateImagePathInRichText(EObject eObject, IValidationContext context, ImagePathWrappingStatus.ImagePathTarget imagePathTarget) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        EList attrs = eObject.eClass().getEAllAttributes();
        Set richTextAttributes = RichTextAttributeRegistry.INSTANCE.getEAttributes();
        for (EAttribute attr : attrs) {
            Object stringObj;
            if (!richTextAttributes.contains(attr) || !((stringObj = eObject.eGet((EStructuralFeature)attr)) instanceof String)) continue;
            String htmlText = (String)stringObj;
            ArrayList<String> alreadyCheckedPath = new ArrayList<String>();
            statuses.addAll(this.checkAbsolutePathInString(context, eObject, htmlText, attr, imagePathTarget, alreadyCheckedPath));
            statuses.addAll(this.checkRelativePathInString(context, eObject, htmlText, attr, imagePathTarget, alreadyCheckedPath));
        }
        return statuses;
    }

    private Collection<IStatus> checkRelativePathInString(IValidationContext ctx, EObject eObject, String strValue, EAttribute attr, ImagePathWrappingStatus.ImagePathTarget imagePathTarget, List<String> alreadyCheckedPath) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
        Matcher matcher = pattern.matcher(strValue);
        while (matcher.find()) {
            if (matcher.groupCount() != 1) continue;
            String path = matcher.group(1);
            boolean exists = FileProvider.getDefault().exists((IPath)new Path(path), Session.of((EObject)eObject).get());
            if (exists || alreadyCheckedPath.contains(path)) continue;
            alreadyCheckedPath.add(path);
            String message = MessageFormat.format(Messages.ImagePathConstraint_relativePathError, path, new EditingDomainServices().getLabelProviderText(eObject));
            ImagePathWrappingStatus imagePathWrappingStatus = new ImagePathWrappingStatus(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)eObject, (Collection)ctx.getResultLocus(), (String)MESSAGE_ITSELF, (Object[])new Object[]{message}), imagePathTarget, path);
            imagePathWrappingStatus.setEAttribute(attr);
            statuses.add((IStatus)imagePathWrappingStatus);
        }
        return statuses;
    }

    private Collection<IStatus> checkAbsolutePathInString(IValidationContext ctx, EObject eObject, String strValue, EAttribute attr, ImagePathWrappingStatus.ImagePathTarget imagePathTarget, List<String> alreadyCheckedPath) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        Pattern pattern = Pattern.compile(HTML_IMAGE_ABSOLUTE_PATH_PATTERN);
        Matcher matcher = pattern.matcher(strValue);
        while (matcher.find()) {
            String path;
            if (matcher.groupCount() != 1 || alreadyCheckedPath.contains(path = matcher.group(1))) continue;
            alreadyCheckedPath.add(path);
            String message = MessageFormat.format(Messages.ImagePathConstraint_absolutePathError, path, new EditingDomainServices().getLabelProviderText(eObject));
            ImagePathWrappingStatus imagePathWrappingStatus = new ImagePathWrappingStatus(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)eObject, (Collection)ctx.getResultLocus(), (String)MESSAGE_ITSELF, (Object[])new Object[]{message}), imagePathTarget, path);
            imagePathWrappingStatus.setEAttribute(attr);
            statuses.add((IStatus)imagePathWrappingStatus);
        }
        return statuses;
    }
}

