/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.service.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;

public class CompoundGraphElementVisitor
implements IGraphElementVisitor {
    private List<IGraphElementVisitor> graphVisitors = new ArrayList<IGraphElementVisitor>();
    private boolean applyToFullGraphFirst = false;

    public CompoundGraphElementVisitor(IGraphElementVisitor ... visitors) {
        this.graphVisitors.addAll(Arrays.asList(visitors));
    }

    public CompoundGraphElementVisitor(boolean applyToFullGraphFirst, IGraphElementVisitor ... visitors) {
        this(visitors);
        this.applyToFullGraphFirst = applyToFullGraphFirst;
    }

    public void visit(ElkGraphElement element) {
        if (this.applyToFullGraphFirst) {
            if (element.eContainer() == null && element instanceof ElkNode) {
                ElkUtil.applyVisitors((ElkNode)((ElkNode)element), (IGraphElementVisitor[])this.graphVisitors.toArray(new IGraphElementVisitor[this.graphVisitors.size()]));
            }
        } else {
            for (IGraphElementVisitor graphVisitor : this.graphVisitors) {
                graphVisitor.visit(element);
            }
        }
    }

    public void addGraphVisitor(IGraphElementVisitor ... visitors) {
        this.graphVisitors.addAll(Arrays.asList(visitors));
    }

    public List<IGraphElementVisitor> getGraphVisitors() {
        return this.graphVisitors;
    }
}

