/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.InterruptNullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CombinedHover;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHover;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverRegistry;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class EditorTextInfoHoverProxy
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private final InfoHoverDescriptor descriptor;
    private final SourceEditorViewerConfiguration sourceEditorConfig;
    private volatile @Nullable InfoHover hover;

    public EditorTextInfoHoverProxy(InfoHoverDescriptor descriptor, SourceEditorViewerConfiguration config) {
        this.descriptor = descriptor;
        this.sourceEditorConfig = config;
    }

    protected SourceEditor getEditor() {
        return this.sourceEditorConfig.getSourceEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ensureHover() {
        InfoHover hover = this.hover;
        if (hover == null) {
            EditorTextInfoHoverProxy editorTextInfoHoverProxy = this;
            synchronized (editorTextInfoHoverProxy) {
                hover = this.hover;
                if (hover == null) {
                    this.hover = hover = this.createHover();
                }
            }
        }
        return hover != null;
    }

    private @Nullable InfoHover createHover() {
        InfoHover hover = this.descriptor.createHover();
        if (hover instanceof CombinedHover) {
            InfoHoverRegistry.EffectiveHovers effectiveHovers = this.sourceEditorConfig.getConfiguredInfoHovers();
            ((CombinedHover)hover).setHovers(effectiveHovers != null ? effectiveHovers.getDescriptorsForCombined() : ImCollections.emptyList());
        }
        return hover;
    }

    public @Nullable IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return null;
    }

    public @Nullable String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    public @Nullable Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        SourceEditor editor = this.getEditor();
        if (editor != null && this.ensureHover()) {
            try {
                AssistInvocationContext context;
                DocContentSections documentContentInfo = editor.getDocumentContentInfo();
                String contentType = null;
                if (hoverRegion instanceof TypedRegion) {
                    TypedRegion typedRegion = (TypedRegion)hoverRegion;
                    contentType = typedRegion.getType();
                }
                if (contentType == null) {
                    contentType = TextUtils.getContentType((IDocument)editor.getViewer().getDocument(), (DocContentSections)documentContentInfo, (int)hoverRegion.getOffset(), (hoverRegion.getLength() == 0 ? 1 : 0) != 0);
                }
                if ((context = this.createContext((TextRegion)JFaceTextRegion.toTextRegion((IRegion)hoverRegion), documentContentInfo, contentType, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    try {
                        AtomicReference<Object> info = new AtomicReference<Object>();
                        this.getInfo0(context, info, (ProgressMonitor)new InterruptNullProgressMonitor());
                        return info.get();
                    }
                    catch (StatusException e) {
                        return null;
                    }
                }
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", NLS.bind((String)"An error occurred when preparing the information hover ''{0}'' (mouse).", (Object)this.descriptor.getName()), (Throwable)e));
            }
        }
        return null;
    }

    protected abstract @Nullable AssistInvocationContext createContext(TextRegion var1, DocContentSections var2, String var3, IProgressMonitor var4);

    private void getInfo0(AssistInvocationContext context, AtomicReference<Object> infoValue, ProgressMonitor m) throws StatusException {
        block4: {
            try {
                if (m.isCanceled()) {
                    return;
                }
                InfoHover hover = (InfoHover)ObjectUtils.nonNullAssert((Object)this.hover);
                Object info = hover.getHoverInfo(context, m);
                if (info != null) {
                    infoValue.set(info);
                }
            }
            catch (StatusException e) {
                if (e.getStatus().getSeverity() != 8) break block4;
                return;
            }
        }
    }

    public @Nullable IInformationControlCreator getHoverControlCreator() {
        InfoHover hover = this.hover;
        if (hover != null) {
            return hover.getHoverControlCreator();
        }
        return null;
    }
}

