/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.IndexStatisticsDaemon;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.services.daemon.BasicDaemon;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public class IndexStatisticsDaemonImpl
implements IndexStatisticsDaemon,
Runnable {
    private static final boolean AS_BACKGROUND_TASK = true;
    private static final boolean AS_EXPLICIT_TASK = false;
    private static final int MAX_QUEUE_LENGTH = PropertyUtil.getSystemInt("derby.storage.indexStats.debug.queueSize", 20);
    private final HeaderPrintWriter logStream;
    private final boolean doLog;
    private final boolean doTrace;
    private final boolean traceToDerbyLog;
    private final boolean traceToStdOut;
    private boolean daemonDisabled;
    private final ContextManager ctxMgr;
    public final boolean skipDisposableStats;
    private LanguageConnectionContext daemonLCC;
    private final Database db;
    private final String dbOwner;
    private final String databaseName;
    private final ArrayList<TableDescriptor> queue = new ArrayList(MAX_QUEUE_LENGTH);
    private Thread runningThread;
    private int errorsConsecutive;
    private long errorsUnknown;
    private long errorsKnown;
    private long wuProcessed;
    private long wuScheduled;
    private long wuRejectedDup;
    private long wuRejectedFQ;
    private long wuRejectedOther;
    private final long timeOfCreation;
    private long runTime;
    private final StringBuffer tsb = new StringBuffer();

    public IndexStatisticsDaemonImpl(HeaderPrintWriter log, boolean doLog, String traceLevel, Database db, String userName, String databaseName) {
        if (log == null) {
            throw new IllegalArgumentException("log stream cannot be null");
        }
        this.logStream = log;
        this.doLog = doLog;
        this.traceToDerbyLog = traceLevel.equalsIgnoreCase("both") || traceLevel.equalsIgnoreCase("log");
        this.traceToStdOut = traceLevel.equalsIgnoreCase("both") || traceLevel.equalsIgnoreCase("stdout");
        this.doTrace = this.traceToDerbyLog || this.traceToStdOut;
        boolean keepDisposableStats = PropertyUtil.getSystemBoolean("derby.storage.indexStats.debug.keepDisposableStats");
        this.skipDisposableStats = this.dbAtLeast10_9(db) && !keepDisposableStats;
        this.db = db;
        this.dbOwner = userName;
        this.databaseName = databaseName;
        this.ctxMgr = IndexStatisticsDaemonImpl.getContextService().newContextManager();
        this.timeOfCreation = System.currentTimeMillis();
        this.trace(0, "created{log=" + doLog + ", traceLog=" + this.traceToDerbyLog + ", traceOut=" + this.traceToStdOut + ", createThreshold=" + TableDescriptor.ISTATS_CREATE_THRESHOLD + ", absdiffThreshold=" + TableDescriptor.ISTATS_ABSDIFF_THRESHOLD + ", lndiffThreshold=" + TableDescriptor.ISTATS_LNDIFF_THRESHOLD + ", queueLength=" + MAX_QUEUE_LENGTH + "}) -> " + databaseName);
    }

    private boolean dbAtLeast10_9(Database db) {
        try {
            return db.getDataDictionary().checkVersion(210, null);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("dd version check failed", se);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(TableDescriptor td) {
        String schedulingReason = td.getIndexStatsUpdateReason();
        ArrayList<TableDescriptor> arrayList = this.queue;
        synchronized (arrayList) {
            if (this.acceptWork(td)) {
                this.queue.add(td);
                ++this.wuScheduled;
                this.log(true, td, "update scheduled" + (String)(schedulingReason == null ? "" : ", reason=[" + schedulingReason + "]") + " (queueSize=" + this.queue.size() + ")");
                if (this.runningThread == null) {
                    this.runningThread = BasicDaemon.getMonitor().getDaemonThread(this, "index-stat-thread", false);
                    this.runningThread.start();
                }
            }
        }
    }

    private boolean acceptWork(TableDescriptor td) {
        boolean accept;
        boolean bl = accept = !this.daemonDisabled && this.queue.size() < MAX_QUEUE_LENGTH;
        if (accept && !this.queue.isEmpty()) {
            String table = td.getName();
            String schema = td.getSchemaName();
            for (int i = 0; i < this.queue.size(); ++i) {
                TableDescriptor work = this.queue.get(i);
                if (!work.tableNameEquals(table, schema)) continue;
                accept = false;
                break;
            }
        }
        if (!accept) {
            String msg = td.getQualifiedName() + " rejected, ";
            if (this.daemonDisabled) {
                ++this.wuRejectedOther;
                msg = msg + "daemon disabled";
            } else if (this.queue.size() >= MAX_QUEUE_LENGTH) {
                ++this.wuRejectedFQ;
                msg = msg + "queue full";
            } else {
                ++this.wuRejectedDup;
                msg = msg + "duplicate";
            }
            this.trace(1, msg);
        }
        return accept;
    }

    private void generateStatistics(LanguageConnectionContext lcc, TableDescriptor td) throws StandardException {
        this.trace(1, "processing " + td.getQualifiedName());
        boolean lockConflictSeen = false;
        while (true) {
            try {
                this.updateIndexStatsMinion(lcc, td, null, true);
            }
            catch (StandardException se) {
                if (se.isLockTimeout() && !lockConflictSeen) {
                    this.trace(1, "locks unavailable, retrying");
                    lockConflictSeen = true;
                    lcc.internalRollback();
                    IndexStatisticsDaemonImpl.sleep(1000L);
                    continue;
                }
                throw se;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShuttingDown() {
        ArrayList<TableDescriptor> arrayList = this.queue;
        synchronized (arrayList) {
            if (this.daemonDisabled || this.daemonLCC == null) {
                return true;
            }
            return !this.daemonLCC.getDatabase().isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexStatsMinion(LanguageConnectionContext lcc, TableDescriptor td, ConglomerateDescriptor[] cds, boolean asBackgroundTask) throws StandardException {
        boolean identifyDisposableStats;
        boolean bl = identifyDisposableStats = cds == null;
        if (cds == null) {
            cds = td.getConglomerateDescriptors();
        }
        long[] conglomerateNumber = new long[cds.length];
        ExecIndexRow[] indexRow = new ExecIndexRow[cds.length];
        TransactionController tc = lcc.getTransactionExecute();
        UUID[] non_disposable_objectUUID = new UUID[cds.length];
        try (ConglomerateController heapCC = tc.openConglomerate(td.getHeapConglomerateId(), false, 0, 6, asBackgroundTask ? 1 : 4);){
            for (int i = 0; i < cds.length; ++i) {
                if (!cds[i].isIndex()) {
                    conglomerateNumber[i] = -1L;
                    continue;
                }
                IndexRowGenerator irg = cds[i].getIndexDescriptor();
                if (this.skipDisposableStats && irg.isUnique() && irg.numberOfOrderedColumns() == 1) {
                    conglomerateNumber[i] = -1L;
                    continue;
                }
                conglomerateNumber[i] = cds[i].getConglomerateNumber();
                non_disposable_objectUUID[i] = cds[i].getUUID();
                indexRow[i] = irg.getNullIndexRow(td.getColumnDescriptorList(), heapCC.newRowLocationTemplate());
            }
        }
        if (identifyDisposableStats) {
            List<StatisticsDescriptor> existingStats = td.getStatistics();
            StatisticsDescriptor[] stats = existingStats.toArray(new StatisticsDescriptor[existingStats.size()]);
            for (int si = 0; si < stats.length; ++si) {
                UUID referencedIndex = stats[si].getReferenceID();
                boolean isValid = false;
                for (int ci = 0; ci < conglomerateNumber.length; ++ci) {
                    if (!referencedIndex.equals(non_disposable_objectUUID[ci])) continue;
                    isValid = true;
                    break;
                }
                if (isValid) continue;
                String msg = "dropping disposable statistics entry " + stats[si].getUUID() + " for index " + stats[si].getReferenceID() + " (cols=" + stats[si].getColumnCount() + ")";
                this.logAlways(td, null, msg);
                this.trace(1, msg + " on table " + stats[si].getTableUUID());
                DataDictionary dd = lcc.getDataDictionary();
                if (!lcc.dataDictionaryInWriteMode()) {
                    dd.startWriting(lcc);
                }
                dd.dropStatisticsDescriptors(td.getUUID(), stats[si].getReferenceID(), tc);
                if (!asBackgroundTask) continue;
                lcc.internalCommit(true);
            }
        }
        long[][] scanTimes = new long[conglomerateNumber.length][3];
        int sci = 0;
        block12: for (int indexNumber = 0; indexNumber < conglomerateNumber.length; ++indexNumber) {
            if (conglomerateNumber[indexNumber] == -1L) continue;
            if (asBackgroundTask && this.isShuttingDown()) break;
            scanTimes[sci][0] = conglomerateNumber[indexNumber];
            scanTimes[sci][1] = System.currentTimeMillis();
            int numCols = indexRow[indexNumber].nColumns() - 1;
            long[] cardinality = new long[numCols];
            KeyComparator cmp = new KeyComparator(indexRow[indexNumber]);
            GroupFetchScanController gsc = tc.openGroupFetchScan(conglomerateNumber[indexNumber], false, 0, 6, 1, null, null, 0, null, null, 0);
            try {
                int rowsFetched = 0;
                boolean giving_up_on_shutdown = false;
                while ((rowsFetched = cmp.fetchRows(gsc)) > 0) {
                    if (asBackgroundTask && this.isShuttingDown()) {
                        giving_up_on_shutdown = true;
                        break;
                    }
                    for (int i = 0; i < rowsFetched; ++i) {
                        int whichPositionChanged = cmp.compareWithPrevKey(i);
                        if (whichPositionChanged < 0) continue;
                        int j = whichPositionChanged;
                        while (j < numCols) {
                            int n = j++;
                            cardinality[n] = cardinality[n] + 1L;
                        }
                    }
                }
                if (giving_up_on_shutdown) break;
                gsc.setEstimatedRowCount(cmp.getRowCount());
            }
            finally {
                gsc.close();
                gsc = null;
            }
            scanTimes[sci++][2] = System.currentTimeMillis();
            int retries = 0;
            while (true) {
                try {
                    this.writeUpdatedStats(lcc, td, non_disposable_objectUUID[indexNumber], cmp.getRowCount(), cardinality, asBackgroundTask);
                    continue block12;
                }
                catch (StandardException se) {
                    if (se.isLockTimeout() && ++retries < 3) {
                        this.trace(2, "lock timeout when writing stats, retrying");
                        IndexStatisticsDaemonImpl.sleep(100 * retries);
                        continue;
                    }
                    throw se;
                }
                break;
            }
        }
        this.log(asBackgroundTask, td, IndexStatisticsDaemonImpl.fmtScanTimes(scanTimes));
    }

    private void writeUpdatedStats(LanguageConnectionContext lcc, TableDescriptor td, UUID index, long numRows, long[] cardinality, boolean asBackgroundTask) throws StandardException {
        TransactionController tc = lcc.getTransactionExecute();
        this.trace(1, "writing new stats (xid=" + tc.getTransactionIdString() + ")");
        UUID table = td.getUUID();
        DataDictionary dd = lcc.getDataDictionary();
        UUIDFactory uf = dd.getUUIDFactory();
        this.setHeapRowEstimate(tc, td.getHeapConglomerateId(), numRows);
        if (!lcc.dataDictionaryInWriteMode()) {
            dd.startWriting(lcc);
        }
        dd.dropStatisticsDescriptors(table, index, tc);
        boolean conglomerateGone = false;
        if (numRows == 0L) {
            this.trace(2, "empty table, no stats written");
        } else {
            for (int i = 0; i < cardinality.length; ++i) {
                StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, uf.createUUID(), index, table, "I", new StatisticsImpl(numRows, cardinality[i]), i + 1);
                dd.addDescriptor(statDesc, null, 14, true, tc);
            }
            ConglomerateDescriptor cd = dd.getConglomerateDescriptor(index);
            this.log(asBackgroundTask, td, "wrote stats for index " + (cd == null ? "n/a" : cd.getDescriptorName()) + " (" + index + "): rows=" + numRows + ", card=" + IndexStatisticsDaemonImpl.cardToStr(cardinality));
            if (asBackgroundTask && cd == null) {
                this.log(asBackgroundTask, td, "rolled back index stats because index has been dropped");
                lcc.internalRollback();
            }
            boolean bl = conglomerateGone = cd == null;
        }
        if (!conglomerateGone) {
            this.invalidateStatements(lcc, td, asBackgroundTask);
        }
        if (asBackgroundTask) {
            lcc.internalCommit(true);
        }
    }

    private void invalidateStatements(LanguageConnectionContext lcc, TableDescriptor td, boolean asBackgroundTask) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        int retries = 0;
        while (true) {
            try {
                if (!lcc.dataDictionaryInWriteMode()) {
                    dd.startWriting(lcc);
                }
                dm.invalidateFor(td, 40, lcc);
                this.trace(1, "invalidation completed");
            }
            catch (StandardException se) {
                if (se.isLockTimeout() && asBackgroundTask && retries < 3) {
                    if (++retries > 1) {
                        this.trace(2, "releasing locks");
                        lcc.internalRollback();
                    }
                    this.trace(2, "lock timeout when invalidating");
                    IndexStatisticsDaemonImpl.sleep(100 * (1 + retries));
                    continue;
                }
                this.trace(1, "invalidation failed");
                throw se;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHeapRowEstimate(TransactionController tc, long tableId, long rowEstimate) throws StandardException {
        try (ScanController sc = tc.openScan(tableId, false, 0, 6, 1, null, null, 0, null, null, 0);){
            sc.setEstimatedRowCount(rowEstimate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long runStart = System.currentTimeMillis();
        ContextService ctxService = null;
        try {
            ctxService = IndexStatisticsDaemonImpl.getContextService();
            ctxService.setCurrentContextManager(this.ctxMgr);
            this.processingLoop();
        }
        catch (ShutdownException se) {
            this.trace(1, "swallowed shutdown exception: " + IndexStatisticsDaemonImpl.extractIstatInfo(se));
            this.stop();
            this.ctxMgr.cleanupOnError(se, this.db.isActive());
        }
        catch (RuntimeException re) {
            if (!this.isShuttingDown()) {
                this.log(true, null, re, "runtime exception during normal operation");
                throw re;
            }
            this.trace(1, "swallowed runtime exception during shutdown: " + IndexStatisticsDaemonImpl.extractIstatInfo(re));
        }
        finally {
            if (ctxService != null) {
                ctxService.resetCurrentContextManager(this.ctxMgr);
            }
            this.runTime += System.currentTimeMillis() - runStart;
            this.trace(0, "worker thread exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processingLoop() {
        block48: {
            if (this.daemonLCC == null) {
                try {
                    this.daemonLCC = this.db.setupConnection(this.ctxMgr, this.dbOwner, null, this.databaseName);
                    this.daemonLCC.setIsolationLevel(1);
                    this.daemonLCC.getTransactionExecute().setNoLockWait(true);
                }
                catch (StandardException se) {
                    this.log(true, null, se, "failed to initialize index statistics updater");
                    return;
                }
            }
            tc = null;
            try {
                tc = this.daemonLCC.getTransactionExecute();
                this.trace(0, "worker thread started (xid=" + tc.getTransactionIdString() + ")");
                td = null;
                start = 0L;
                while (true) lbl-1000:
                // 5 sources

                {
                    var5_9 = this.queue;
                    synchronized (var5_9) {
                        if (this.daemonDisabled) {
                            try {
                                tc.destroy();
                            }
                            catch (ShutdownException var6_12) {
                                // empty catch block
                            }
                            tc = null;
                            this.daemonLCC = null;
                            this.queue.clear();
                            this.trace(1, "daemon disabled");
                            break block48;
                        }
                        if (this.queue.isEmpty()) {
                            this.trace(1, "queue empty");
                            break block48;
                        }
                        td = this.queue.get(0);
                    }
                    try {
                        start = System.currentTimeMillis();
                        this.generateStatistics(this.daemonLCC, (TableDescriptor)td);
                        ++this.wuProcessed;
                        this.errorsConsecutive = 0;
                        this.log(true, (TableDescriptor)td, "generation complete (" + (System.currentTimeMillis() - start) + " ms)");
                    }
                    catch (StandardException se) {
                        ++this.errorsConsecutive;
                        if (this.handleFatalErrors(this.ctxMgr, se)) ** GOTO lbl-1000
                        handled = this.handleExpectedErrors((TableDescriptor)td, se);
                        if (!handled) {
                            handled = this.handleUnexpectedErrors((TableDescriptor)td, se);
                        }
                        this.daemonLCC.internalRollback();
                        SanityManager.ASSERT(handled);
                    }
                    finally {
                        var5_9 = this.queue;
                        synchronized (var5_9) {
                            if (!this.queue.isEmpty()) {
                                this.queue.remove(0);
                            }
                        }
                        if (this.errorsConsecutive < 50) continue;
                        this.log(true, null, new IllegalStateException("degraded state"), "shutting down daemon, " + this.errorsConsecutive + " consecutive errors seen");
                        this.stop();
                        continue;
                    }
                    break;
                }
            }
            catch (StandardException se) {
                this.log(true, null, se, "thread died");
                break block48;
            }
            finally {
                se = this.queue;
                synchronized (se) {
                    this.runningThread = null;
                }
                if (this.daemonLCC != null && !this.daemonLCC.isTransactionPristine()) {
                    SanityManager.THROWASSERT("transaction not pristine");
                    this.log(true, null, "transaction not pristine - forcing rollback");
                    try {
                        this.daemonLCC.internalRollback();
                    }
                    catch (StandardException se) {
                        this.log(true, null, se, "forced rollback failed");
                    }
                }
            }
            ** GOTO lbl-1000
        }
    }

    @Override
    public void runExplicitly(LanguageConnectionContext lcc, TableDescriptor td, ConglomerateDescriptor[] cds, String runContext) throws StandardException {
        this.updateIndexStatsMinion(lcc, td, cds, false);
        this.trace(0, "explicit run completed" + (String)(runContext != null ? " (" + runContext + "): " : ": ") + td.getQualifiedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Thread threadToWaitFor = null;
        boolean clearContext = false;
        ArrayList<TableDescriptor> arrayList = this.queue;
        synchronized (arrayList) {
            if (!this.daemonDisabled) {
                clearContext = true;
                StringBuffer sb = new StringBuffer(100);
                sb.append("stopping daemon, active=").append(this.runningThread != null).append(", work/age=").append(this.runTime).append('/').append(System.currentTimeMillis() - this.timeOfCreation).append(' ');
                this.appendRunStats(sb);
                this.log(true, null, sb.toString());
                if (this.runningThread == null && this.daemonLCC != null && !this.isShuttingDown()) {
                    try {
                        this.daemonLCC.getTransactionExecute().destroy();
                    }
                    catch (ShutdownException shutdownException) {
                        // empty catch block
                    }
                    this.daemonLCC = null;
                }
                this.daemonDisabled = true;
                threadToWaitFor = this.runningThread;
                this.runningThread = null;
                this.queue.clear();
            }
        }
        if (threadToWaitFor != null) {
            while (true) {
                try {
                    threadToWaitFor.join();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                    continue;
                }
                break;
            }
        }
        if (clearContext) {
            this.ctxMgr.cleanupOnError(StandardException.normalClose(), false);
        }
    }

    private boolean handleFatalErrors(ContextManager cm, StandardException se) {
        boolean disable = false;
        if ("40XD1".equals(se.getMessageId())) {
            disable = true;
        } else if (this.isShuttingDown() || se.getSeverity() >= 45000) {
            this.trace(1, "swallowed exception during shutdown: " + IndexStatisticsDaemonImpl.extractIstatInfo(se));
            disable = true;
            cm.cleanupOnError(se, this.db.isActive());
        }
        if (disable) {
            this.daemonLCC.getDataDictionary().disableIndexStatsRefresher();
        }
        return disable;
    }

    private boolean handleExpectedErrors(TableDescriptor td, StandardException se) {
        String state = se.getMessageId();
        if ("XSAI2.S".equals(state) || "XSCH1.S".equals(state) || "XSDG9.D".equals(state) || se.isLockTimeout()) {
            ++this.errorsKnown;
            this.log(true, td, "generation aborted (reason: " + state + ") {" + IndexStatisticsDaemonImpl.extractIstatInfo(se) + "}");
            return true;
        }
        return false;
    }

    private boolean handleUnexpectedErrors(TableDescriptor td, StandardException se) {
        ++this.errorsUnknown;
        this.log(true, td, se, "generation failed");
        return true;
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            InterruptStatus.setInterrupted();
        }
    }

    private static String fmtScanTimes(long[][] timings) {
        StringBuffer sb = new StringBuffer("scan durations (");
        for (int i = 0; i < timings.length && timings[i][0] > 0L; ++i) {
            sb.append('c').append(timings[i][0]).append('=');
            if (timings[i][2] == 0L) {
                sb.append("ABORTED,");
                continue;
            }
            long duration = timings[i][2] - timings[i][1];
            sb.append(duration).append("ms,");
        }
        sb.deleteCharAt(sb.length() - 1).append(")");
        return sb.toString();
    }

    private void log(boolean asBackgroundTask, TableDescriptor td, String msg) {
        this.log(asBackgroundTask, td, null, msg);
    }

    private void log(boolean asBackgroundTask, TableDescriptor td, Throwable t, String msg) {
        if (asBackgroundTask && (this.doLog || t != null)) {
            this.logAlways(td, t, msg);
        }
    }

    private void logAlways(TableDescriptor td, Throwable t, String msg) {
        String hdrMsg = "{istat} " + (String)(td == null ? "" : td.getQualifiedName() + ": ") + msg;
        if (t != null) {
            PrintWriter pw = new PrintWriter((Writer)this.logStream.getPrintWriter(), false);
            pw.print(this.logStream.getHeader().getHeader());
            pw.println(hdrMsg);
            t.printStackTrace(pw);
            pw.flush();
        } else {
            this.logStream.printlnWithHeader(hdrMsg);
        }
    }

    private synchronized void trace(int indentLevel, String msg) {
        if (this.doTrace) {
            this.tsb.setLength(0);
            this.tsb.append("{istat,trace@").append(this.hashCode()).append("} ");
            for (int i = 0; i < indentLevel; ++i) {
                this.tsb.append("    ");
            }
            this.tsb.append(msg).append(' ');
            if (indentLevel == 0) {
                this.appendRunStats(this.tsb);
            }
            if (this.traceToDerbyLog && this.logStream != null) {
                this.logStream.printlnWithHeader(this.tsb.toString());
            }
            if (this.traceToStdOut) {
                System.out.println(this.tsb.toString());
            }
        }
    }

    private void appendRunStats(StringBuffer sb) {
        sb.append("[q/p/s=").append(this.queue.size()).append('/').append(this.wuProcessed).append('/').append(this.wuScheduled).append(",err:k/u/c=").append(this.errorsKnown).append('/').append(this.errorsUnknown).append('/').append(this.errorsConsecutive).append(",rej:f/d/o=").append(this.wuRejectedFQ).append('/').append(this.wuRejectedDup).append('/').append(this.wuRejectedOther).append(']');
    }

    private static String cardToStr(long[] cardinality) {
        if (cardinality.length == 1) {
            return "[" + Long.toString(cardinality[0]) + "]";
        }
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < cardinality.length; ++i) {
            sb.append(cardinality[i]).append(',');
        }
        sb.deleteCharAt(sb.length() - 1).append(']');
        return sb.toString();
    }

    private static String extractIstatInfo(Throwable t) {
        String istatClass = IndexStatisticsDaemonImpl.class.getName();
        StackTraceElement[] stack = t.getStackTrace();
        Object trace = "<no stacktrace>";
        Object sqlState = "";
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement ste = stack[i];
            if (!ste.getClassName().startsWith(istatClass)) continue;
            trace = ste.getMethodName() + "#" + ste.getLineNumber();
            if (i <= 0) break;
            ste = stack[i - 1];
            trace = (String)trace + " -> " + ste.getClassName() + "." + ste.getMethodName() + "#" + ste.getLineNumber();
            break;
        }
        if (t instanceof StandardException) {
            sqlState = ", SQLSTate=" + ((StandardException)t).getSQLState();
        }
        return "<" + t.getClass() + ", msg=" + t.getMessage() + (String)sqlState + "> " + (String)trace;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static class KeyComparator {
        private static final int FETCH_SIZE = 16;
        private final DataValueDescriptor[][] rowBufferArray = new DataValueDescriptor[16][];
        private DataValueDescriptor[] lastUniqueKey;
        private DataValueDescriptor[] curr;
        private DataValueDescriptor[] prev;
        private int rowsReadLastRead = -1;
        private long numRows;

        public KeyComparator(ExecIndexRow ir) {
            this.rowBufferArray[0] = ir.getRowArray();
            this.lastUniqueKey = ir.getRowArrayClone();
        }

        public int fetchRows(GroupFetchScanController gsc) throws StandardException {
            if (this.rowsReadLastRead == 16) {
                this.curr = this.rowBufferArray[15];
                this.rowBufferArray[15] = this.lastUniqueKey;
                this.lastUniqueKey = this.curr;
            }
            this.rowsReadLastRead = gsc.fetchNextGroup(this.rowBufferArray, null);
            return this.rowsReadLastRead;
        }

        public int compareWithPrevKey(int index) throws StandardException {
            if (index > this.rowsReadLastRead) {
                throw new IllegalStateException("invalid access, rowsReadLastRead=" + this.rowsReadLastRead + ", index=" + index + ", numRows=" + this.numRows);
            }
            ++this.numRows;
            if (this.numRows == 1L) {
                return 0;
            }
            this.prev = index == 0 ? this.lastUniqueKey : this.rowBufferArray[index - 1];
            this.curr = this.rowBufferArray[index];
            for (int i = 0; i < this.prev.length - 1; ++i) {
                DataValueDescriptor dvd = this.prev[i];
                if (!dvd.isNull() && this.prev[i].compare(this.curr[i]) == 0) continue;
                return i;
            }
            return -1;
        }

        public long getRowCount() {
            return this.numRows;
        }
    }
}

