/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.impl.store.access.RAMAccessManager;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CacheableConglomerate
implements Cacheable {
    private final RAMAccessManager accessManager;
    private Long conglomid;
    private Conglomerate conglom;

    CacheableConglomerate(RAMAccessManager parent) {
        this.accessManager = parent;
    }

    protected Conglomerate getConglom() {
        return this.conglom;
    }

    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        this.conglomid = (Long)key;
        long id = this.conglomid;
        this.conglom = this.accessManager.getFactoryFromConglomId(id).readConglomerate(this.accessManager.getCurrentTransactionContext().getTransaction(), new ContainerKey(0L, id));
        return this;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        SanityManager.ASSERT(key instanceof Long, "key is not instanceof Long");
        SanityManager.ASSERT(createParameter instanceof Conglomerate, "createParameter is not instanceof Conglomerate");
        this.conglomid = (Long)key;
        this.conglom = (Conglomerate)createParameter;
        return this;
    }

    @Override
    public void clearIdentity() {
        this.conglomid = null;
        this.conglom = null;
    }

    @Override
    public Object getIdentity() {
        return this.conglomid;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void clean(boolean forRemove) throws StandardException {
    }
}

