/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.util;

import java.util.EnumSet;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;

public class HistoryTrackingConfiguration
extends TrackingConfiguration {
    public static final String HISTORY_TRACKING_ID = "history";
    private boolean fLoadHistory;

    public HistoryTrackingConfiguration(String id) {
        super(id);
    }

    public HistoryTrackingConfiguration(String id, HistoryTrackingConfiguration template) {
        super(id, template);
        this.fLoadHistory = template.fLoadHistory;
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.setTrackStreamInfo(false);
        this.setTrackStreamInput(true);
        this.setTrackStreamInputHistoryOnly(true);
        this.setTrackStreamOutput(false);
        this.setTrackStreamOutputTruncate(false);
        this.setSubmitTypes(EnumSet.of(SubmitType.CONSOLE));
        this.setLoadHistory(true);
    }

    public boolean getLoadHistory() {
        return this.fLoadHistory;
    }

    public void setLoadHistory(boolean enable) {
        boolean oldValue = this.fLoadHistory;
        this.fLoadHistory = enable;
        this.firePropertyChange("loadHistory", oldValue, enable);
    }
}

