/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.util.HistoryTrackingConfiguration;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;

public class TrackingConfiguration2LaunchConfiguration {
    public static final String LABEL_KEY = "label";
    public static final String TRACK_STREAM_INFO = "TrackInfo.enable";
    public static final String TRACK_STREAM_INPUT = "TrackInput.enable";
    public static final String TRACK_STREAM_INPUT_HISTORYONLY = "TrackInput.HistoryOnly.enable";
    public static final String TRACK_STREAM_OUTPUT = "TrackOutput.enable";
    public static final String TRACK_STREAM_OUTPUT_TRUNCATE = "TrackOutput.Truncate.enable";
    public static final String TRACK_STREAM_OUTPUT_TRUNCATE_LINES = "TrackOutput.Truncate.lines";
    public static final String SUBMIT_TYPES = "SubmitTypes.ids";
    public static final String FILE_PATH = "File.path";
    public static final String FILE_MODE = "File.mode";
    public static final String PREPEND_TIMESTAMP = "Prepend.Timestamp.enable";
    public static final String LOAD_HISTORY = "History.LoadAtStartup.enable";

    public void load(TrackingConfiguration trackingConfig, ILaunchConfiguration launchConfig) throws CoreException {
        String id = trackingConfig.getId();
        trackingConfig.setName(launchConfig.getAttribute(id + ".label", ""));
        trackingConfig.setTrackStreamInfo(launchConfig.getAttribute(id + ".TrackInfo.enable", false));
        trackingConfig.setTrackStreamInput(launchConfig.getAttribute(id + ".TrackInput.enable", false));
        trackingConfig.setTrackStreamInputHistoryOnly(launchConfig.getAttribute(id + ".TrackInput.HistoryOnly.enable", false));
        trackingConfig.setTrackStreamOutput(launchConfig.getAttribute(id + ".TrackOutput.enable", false));
        trackingConfig.setTrackStreamOutputTruncate(launchConfig.getAttribute(id + ".TrackOutput.Truncate.enable", false));
        trackingConfig.setTrackStreamOutputTruncateLines(launchConfig.getAttribute(id + ".TrackOutput.Truncate.lines", 1000000));
        List submitTypeNames = launchConfig.getAttribute(id + ".SubmitTypes.ids", null);
        if (submitTypeNames != null) {
            EnumSet<SubmitType> submitTypes = EnumSet.noneOf(SubmitType.class);
            for (String name : submitTypeNames) {
                submitTypes.add(SubmitType.valueOf(name));
            }
            trackingConfig.setSubmitTypes(submitTypes);
        } else {
            trackingConfig.setSubmitTypes(SubmitType.getDefaultSet());
        }
        trackingConfig.setFilePath(launchConfig.getAttribute(id + ".File.path", ""));
        trackingConfig.setFileMode(launchConfig.getAttribute(id + ".File.mode", TrackingConfiguration.DEFAULT_FILE_MODE));
        trackingConfig.setPrependTimestamp(launchConfig.getAttribute(id + ".Prepend.Timestamp.enable", false));
        if (id.equals("history") && launchConfig instanceof HistoryTrackingConfiguration) {
            ((HistoryTrackingConfiguration)launchConfig).setLoadHistory(launchConfig.getAttribute(id + ".History.LoadAtStartup.enable", false));
        }
    }

    public void save(TrackingConfiguration trackingConfig, ILaunchConfigurationWorkingCopy launchConfig) {
        String id = trackingConfig.getId();
        launchConfig.setAttribute(id + ".label", trackingConfig.getName());
        launchConfig.setAttribute(id + ".TrackInfo.enable", trackingConfig.getTrackStreamInfo());
        launchConfig.setAttribute(id + ".TrackInput.enable", trackingConfig.getTrackStreamInput());
        launchConfig.setAttribute(id + ".TrackInput.HistoryOnly.enable", trackingConfig.getTrackStreamInputHistoryOnly());
        launchConfig.setAttribute(id + ".TrackOutput.enable", trackingConfig.getTrackStreamOutput());
        launchConfig.setAttribute(id + ".TrackOutput.Truncate.enable", trackingConfig.getTrackStreamOutputTruncate());
        launchConfig.setAttribute(id + ".TrackOutput.Truncate.lines", trackingConfig.getTrackStreamOutputTruncateLines());
        EnumSet<SubmitType> submitTypes = trackingConfig.getSubmitTypes();
        ArrayList<String> submitTypeNames = new ArrayList<String>(submitTypes.size());
        for (SubmitType submitType : submitTypes) {
            submitTypeNames.add(submitType.name());
        }
        launchConfig.setAttribute(id + ".SubmitTypes.ids", submitTypeNames);
        launchConfig.setAttribute(id + ".File.path", trackingConfig.getFilePath());
        launchConfig.setAttribute(id + ".File.mode", trackingConfig.getFileMode());
        launchConfig.setAttribute(id + ".Prepend.Timestamp.enable", trackingConfig.getPrependTimestamp());
        if (id.equals("history") && launchConfig instanceof HistoryTrackingConfiguration) {
            launchConfig.setAttribute(id + ".History.LoadAtStartup.enable", ((HistoryTrackingConfiguration)launchConfig).getLoadHistory());
        }
    }
}

