/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.IMarkerPositionResolver;
import org.eclipse.statet.ecommons.text.ui.AnnotationMarkerPositionResolver;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.debug.core.RDebugModel;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpointValidator;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class RToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension,
IToggleBreakpointsTargetExtension2 {
    private RBreakpoint fLastBreakpoint;
    private long fLastStamp;

    private Data createData(RSourceEditor editor) {
        if (editor == null) {
            return null;
        }
        RSourceUnit su = editor.getSourceUnit();
        if (!(su instanceof RWorkspaceSourceUnit)) {
            return null;
        }
        return new Data(editor, (RWorkspaceSourceUnit)su);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        RSourceEditor editor = this.getREditor(part, selection);
        return editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, final ISelection selection) throws CoreException {
        final Data data = this.createData(this.getREditor(part, selection));
        if (data == null) {
            return;
        }
        IProgressService progressService = (IProgressService)part.getSite().getWorkbenchWindow().getService(IProgressService.class);
        try {
            progressService.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        data.init2(monitor);
                        if (selection instanceof ITextSelection) {
                            ITextSelection textSelection = (ITextSelection)selection;
                            RToggleBreakpointAdapter.this.doToggleLineBreakpoint(data, textSelection.getOffset(), monitor);
                        }
                    }
                    catch (BadLocationException textSelection) {
                    }
                    catch (CoreException e) {
                        RToggleBreakpointAdapter.this.log(data, e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        RSourceEditor editor = this.getREditor(part, selection);
        return editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, final ISelection selection) throws CoreException {
        final Data data = this.createData(this.getREditor(part, selection));
        if (data == null) {
            return;
        }
        IProgressService progressService = (IProgressService)part.getSite().getWorkbenchWindow().getService(IProgressService.class);
        try {
            progressService.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        data.init2(monitor);
                        if (selection instanceof ITextSelection) {
                            ITextSelection textSelection = (ITextSelection)selection;
                            RToggleBreakpointAdapter.this.doToggleMethodBreakpoint(data, textSelection.getOffset(), monitor);
                        }
                    }
                    catch (BadLocationException textSelection) {
                    }
                    catch (CoreException e) {
                        RToggleBreakpointAdapter.this.log(data, e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        RSourceEditor editor = this.getREditor(part, selection);
        return editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection;
    }

    public void toggleBreakpoints(IWorkbenchPart part, final ISelection selection) throws CoreException {
        final Data data = this.createData(this.getREditor(part, selection));
        IProgressService progressService = (IProgressService)part.getSite().getWorkbenchWindow().getService(IProgressService.class);
        try {
            progressService.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        data.init2(monitor);
                        if (selection instanceof ITextSelection) {
                            ITextSelection textSelection = (ITextSelection)selection;
                            RToggleBreakpointAdapter.this.doToggleBestBreakpoint(data, textSelection.getOffset(), monitor);
                        }
                    }
                    catch (BadLocationException textSelection) {
                    }
                    catch (CoreException e) {
                        RToggleBreakpointAdapter.this.log(data, e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public boolean canToggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) {
        return this.canToggleBreakpoints(part, selection);
    }

    public void toggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) throws CoreException {
        RSourceEditor rSourceEditor;
        if (event != null && (event.stateMask & SWT.MOD2) > 0 && (rSourceEditor = this.getREditor(part, selection)) != null && selection instanceof ITextSelection) {
            try {
                Data data = this.createData(rSourceEditor);
                if (data == null) {
                    return;
                }
                ITextSelection textSelection = (ITextSelection)selection;
                data.init2(null);
                int lineNumber = data.getDocument().getLineOfOffset(textSelection.getOffset()) + 1;
                RLineBreakpoint breakpoint = this.findFirst(data, lineNumber, null, null);
                if (breakpoint != null) {
                    breakpoint.setEnabled(!breakpoint.isEnabled());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return;
        }
        this.toggleBreakpoints(part, selection);
    }

    public boolean removeBreakpoints(IWorkbenchPart part, ISelection selection, IProgressMonitor monitor) throws CoreException {
        Data data = this.createData(this.getREditor(part, selection));
        if (data == null) {
            return false;
        }
        if (selection instanceof ITextSelection) {
            try {
                data.init2(null);
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    return this.checkSelectedLine(data, textSelection.getOffset(), null, monitor);
                }
            }
            catch (BadLocationException textSelection) {
            }
            catch (CoreException e) {
                this.log(data, e);
            }
        }
        return false;
    }

    private void doToggleLineBreakpoint(Data data, int offset, IProgressMonitor monitor) throws BadLocationException, CoreException {
        if (this.checkSelectedLine(data, offset, "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint", monitor)) {
            return;
        }
        RLineBreakpointValidator validator = new RLineBreakpointValidator(data.getSourceUnit(), "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint", offset, monitor);
        if (this.checkNewLine(data, validator, "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint", monitor)) {
            return;
        }
        this.createNew(validator, monitor);
    }

    private void doToggleMethodBreakpoint(Data data, int offset, IProgressMonitor monitor) throws BadLocationException, CoreException {
        if (this.checkSelectedLine(data, offset, "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint", monitor)) {
            return;
        }
        RLineBreakpointValidator validator = new RLineBreakpointValidator(data.getSourceUnit(), "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint", offset, monitor);
        if (this.checkNewLine(data, validator, "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint", monitor)) {
            return;
        }
        this.createNew(validator, monitor);
    }

    private void doToggleBestBreakpoint(Data data, int offset, IProgressMonitor monitor) throws BadLocationException, CoreException {
        if (this.checkSelectedLine(data, offset, null, monitor)) {
            return;
        }
        RLineBreakpointValidator validator = new RLineBreakpointValidator(data.getSourceUnit(), null, offset, monitor);
        if (this.checkNewLine(data, validator, null, monitor)) {
            return;
        }
        this.createNew(validator, monitor);
    }

    private boolean checkSelectedLine(Data data, int offset, String type, IProgressMonitor monitor) throws BadLocationException, CoreException {
        int lineNumber = data.getDocument().getLineOfOffset(offset) + 1;
        RLineBreakpoint breakpoint = this.findFirst(data, lineNumber, type, this.fLastBreakpoint);
        if (breakpoint != null) {
            DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)this.getShell(data), (IProgressMonitor)monitor);
            return true;
        }
        return false;
    }

    private boolean checkNewLine(Data data, RLineBreakpointValidator validator, String type, IProgressMonitor monitor) throws CoreException {
        RLineBreakpoint breakpoint;
        int lineCorr;
        if (validator.getLineNumber() >= 0 && (lineCorr = Math.abs(validator.getLineNumber() - validator.getOriginalLineNumber())) > 0 && (breakpoint = this.findFirst(data, validator.getLineNumber(), type, this.fLastBreakpoint)) != null) {
            if (breakpoint == this.fLastBreakpoint || type == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint" || lineCorr <= 2) {
                DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)this.getShell(data), (IProgressMonitor)monitor);
            }
            return true;
        }
        return false;
    }

    private RLineBreakpoint findFirst(Data data, int lineNumber, String type, RBreakpoint last) throws CoreException {
        List breakpoints = RDebugModel.getLineBreakpoints((IFile)((IFile)data.getSourceUnit().getResource()));
        if (breakpoints.isEmpty()) {
            return null;
        }
        IMarkerPositionResolver resolver = this.getMarkerPositionResolver(data);
        if (last != null && (type == null || last.getBreakpointType() == type)) {
            for (RLineBreakpoint breakpoint : breakpoints) {
                if (breakpoint != last || (resolver != null ? resolver.getLine(breakpoint.getMarker()) : breakpoint.getLineNumber()) != lineNumber) continue;
                return breakpoint;
            }
        }
        for (RLineBreakpoint breakpoint : breakpoints) {
            if (type != null && breakpoint.getBreakpointType() != type || (resolver != null ? resolver.getLine(breakpoint.getMarker()) : breakpoint.getLineNumber()) != lineNumber) continue;
            return breakpoint;
        }
        return null;
    }

    private boolean createNew(RLineBreakpointValidator validator, IProgressMonitor monitor) {
        RBreakpoint breakpoint = validator.createBreakpoint(monitor);
        if (breakpoint != null) {
            this.fLastBreakpoint = breakpoint;
            this.fLastStamp = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    private RSourceEditor getREditor(IWorkbenchPart part, ISelection selection) {
        if (part instanceof RSourceEditor) {
            return (RSourceEditor)part;
        }
        Object adapter = part.getAdapter(SourceEditor.class);
        if (adapter instanceof RSourceEditor) {
            return (RSourceEditor)adapter;
        }
        return null;
    }

    protected IMarkerPositionResolver getMarkerPositionResolver(Data data) {
        AbstractDocument document = data.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel(data.getEditor());
        if (document != null && model != null) {
            return new AnnotationMarkerPositionResolver((IDocument)document, model);
        }
        return null;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel(RSourceEditor editor) {
        AbstractTextEditor textEditor;
        IDocumentProvider provider;
        IAnnotationModel model;
        if (editor instanceof AbstractTextEditor && (model = (provider = (textEditor = (AbstractTextEditor)editor).getDocumentProvider()).getAnnotationModel((Object)textEditor.getEditorInput())) instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected void log(Data data, CoreException e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, NLS.bind((String)"An error occurred when toggling an R method breakpoint in ''{0}''.", (Object)data.getSourceUnit().getElementName().getDisplayName()), (Throwable)e));
    }

    private Shell getShell(Data data) {
        IWorkbenchPart part = data.getEditor().getWorkbenchPart();
        if (part != null) {
            return part.getSite().getShell();
        }
        return null;
    }

    private static class Data {
        private final RSourceEditor fEditor;
        private final RWorkspaceSourceUnit fSourceUnit;
        private AbstractDocument fDocument;

        Data(RSourceEditor editor, RWorkspaceSourceUnit su) {
            this.fEditor = editor;
            this.fSourceUnit = su;
        }

        public RSourceEditor getEditor() {
            return this.fEditor;
        }

        public RWorkspaceSourceUnit getSourceUnit() {
            return this.fSourceUnit;
        }

        public void init2(IProgressMonitor monitor) {
            this.fDocument = this.fSourceUnit.getDocument(monitor);
        }

        public AbstractDocument getDocument() {
            return this.fDocument;
        }
    }
}

