/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.collections;

import java.lang.reflect.Array;
import java.util.Arrays;

@Deprecated
public final class FastList<T> {
    public static final int EQUALITY = 0;
    public static final int IDENTITY = 1;
    private final boolean identity;
    private final Class<T> type;
    private final T[] emptyArray;
    private volatile T[] items;

    public FastList(Class<T> type) {
        this(type, 0, null);
    }

    public FastList(Class<T> type, int mode) {
        this(type, mode, null);
    }

    public FastList(Class<T> type, int mode, T[] initial) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.identity = mode == 1;
        this.emptyArray = (Object[])Array.newInstance(type, 0);
        this.items = initial != null ? initial : this.emptyArray;
    }

    public synchronized void add(T item) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.items.length;
        int i = 0;
        while (i < oldSize) {
            T item2 = this.items[i];
            if (this.identity ? item == item2 : item.equals(item2)) {
                return;
            }
            ++i;
        }
        Object[] newListeners = (Object[])Array.newInstance(this.type, oldSize + 1);
        System.arraycopy(this.items, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = item;
        this.items = newListeners;
    }

    public T[] toArray() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.items.length == 0;
    }

    public synchronized void remove(T item) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.items.length;
        int i = 0;
        while (i < oldSize) {
            T item2 = this.items[i];
            if (this.identity ? item == item2 : item.equals(item2)) {
                if (oldSize == 1) {
                    this.items = this.emptyArray;
                } else {
                    Object[] newListeners = (Object[])Array.newInstance(this.type, oldSize - 1);
                    System.arraycopy(this.items, 0, newListeners, 0, i);
                    System.arraycopy(this.items, i + 1, newListeners, i, oldSize - i - 1);
                    this.items = newListeners;
                }
                return;
            }
            ++i;
        }
    }

    public synchronized void replace(T oldItem, T newItem) {
        if (newItem == null) {
            throw new IllegalArgumentException();
        }
        int remove = -1;
        int oldSize = this.items.length;
        if (oldItem != null) {
            T item2;
            int i;
            if (this.identity ? oldItem != newItem : !oldItem.equals(newItem)) {
                i = 0;
                while (i < oldSize) {
                    item2 = this.items[i];
                    if (this.identity ? newItem == item2 : newItem.equals(item2)) {
                        remove = i;
                        break;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < oldSize) {
                item2 = this.items[i];
                if (this.identity ? oldItem == item2 : oldItem.equals(item2)) {
                    if (remove >= 0 && remove != i) {
                        Object[] newListeners = (Object[])Array.newInstance(this.type, oldSize - 1);
                        System.arraycopy(this.items, 0, newListeners, 0, remove);
                        System.arraycopy(this.items, remove + 1, newListeners, remove, oldSize - remove - 1);
                        newListeners[i < remove ? i : i - 1] = newItem;
                        this.items = newListeners;
                    } else {
                        Object[] newListeners = (Object[])Array.newInstance(this.type, oldSize);
                        System.arraycopy(this.items, 0, newListeners, 0, oldSize);
                        newListeners[i] = newItem;
                        this.items = newListeners;
                    }
                    return;
                }
                ++i;
            }
        }
        if (remove >= 0) {
            Object[] newListeners = (Object[])Array.newInstance(this.type, oldSize);
            System.arraycopy(this.items, 0, newListeners, 0, remove);
            System.arraycopy(this.items, remove + 1, newListeners, remove, oldSize - remove - 1);
            newListeners[oldSize - 1] = newItem;
            this.items = newListeners;
        } else {
            Object[] newListeners = (Object[])Array.newInstance(this.type, oldSize + 1);
            System.arraycopy(this.items, 0, newListeners, 0, oldSize);
            newListeners[oldSize] = newItem;
            this.items = newListeners;
        }
    }

    public int size() {
        return this.items.length;
    }

    public synchronized T[] clear() {
        T[] oldListeners = this.items;
        this.items = this.emptyArray;
        return oldListeners;
    }

    public String toString() {
        return Arrays.toString(this.items);
    }
}

