/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.internal.ecommons.preferences.Messages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class SettingsChangeNotifier
implements ISchedulingRule,
Disposable {
    private volatile boolean isDisposed = false;
    private final CopyOnWriteIdentityListSet<ManageListener> managers = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<ChangeListener> listeners = new CopyOnWriteIdentityListSet();
    private final Map<String, NotifyJob> pendingJobs = new HashMap<String, NotifyJob>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Job getNotifyJob(@Nullable String source, ImCollection<String> groupIds) {
        if (this.isDisposed) {
            return null;
        }
        if (source == null) {
            source = "direct";
        }
        SettingsChangeNotifier settingsChangeNotifier = this;
        synchronized (settingsChangeNotifier) {
            NotifyJob job;
            block6: {
                job = this.pendingJobs.get(source);
                if (job == null) break block6;
                job.addGroups(groupIds);
                return null;
            }
            job = new NotifyJob(source);
            this.pendingJobs.put(source, job);
            job.addGroups(groupIds);
            return job;
        }
    }

    @Deprecated
    public @Nullable Job getNotifyJob(@Nullable String source, @NonNull String[] groupIds) {
        return this.getNotifyJob(source, (ImCollection<String>)ImCollections.newList((Object[])groupIds));
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.isDisposed) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (!this.isDisposed) {
            this.listeners.remove((Object)listener);
        }
    }

    public void addManageListener(ManageListener listener) {
        if (!this.isDisposed) {
            this.managers.add((Object)listener);
        }
    }

    public void removeManageListener(ManageListener listener) {
        if (!this.isDisposed) {
            this.managers.remove((Object)listener);
        }
    }

    public void dispose() {
        this.isDisposed = true;
        this.managers.clear();
        this.listeners.clear();
    }

    public static interface ChangeListener {
        public void settingsChanged(Set<String> var1);
    }

    public static interface ManageListener {
        public void beforeSettingsChangeNotification(Set<String> var1);

        public void afterSettingsChangeNotification(Set<String> var1);
    }

    private class NotifyJob
    extends Job {
        private final String source;
        private final Set<String> changedGroupIds;

        public NotifyJob(String source) {
            super(Messages.SettingsChangeNotifier_Job_title);
            this.changedGroupIds = new HashSet<String>();
            this.setPriority(20);
            this.setRule(SettingsChangeNotifier.this);
            this.source = source;
        }

        public void addGroups(ImCollection<String> groupIds) {
            this.changedGroupIds.addAll((Collection<String>)groupIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ImIdentityList listeners;
            ImIdentityList managers;
            SettingsChangeNotifier settingsChangeNotifier = SettingsChangeNotifier.this;
            synchronized (settingsChangeNotifier) {
                managers = SettingsChangeNotifier.this.managers.toList();
                listeners = SettingsChangeNotifier.this.listeners.toList();
                SettingsChangeNotifier.this.pendingJobs.remove(this.source);
            }
            monitor.beginTask(Messages.SettingsChangeNotifier_Task_name, managers.size() * 5 + listeners.size() * 5);
            for (Object obj : managers) {
                ((ManageListener)obj).beforeSettingsChangeNotification(this.changedGroupIds);
                monitor.worked(3);
            }
            for (Object obj : listeners) {
                ((ChangeListener)obj).settingsChanged(this.changedGroupIds);
                monitor.worked(5);
            }
            for (Object obj : managers) {
                ((ManageListener)obj).afterSettingsChangeNotification(this.changedGroupIds);
                monitor.worked(2);
            }
            return Status.OK_STATUS;
        }
    }
}

