/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.breakpoints;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.databinding.core.util.DirtyTracker;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractBreakpointDetailEditor {
    private final boolean mnemonics;
    private Composite composite;
    private boolean isDirty;
    private DataBindingContext dbc;
    private boolean ignoreChanges;
    private AggregateValidationStatus aggregateStatus;
    private IStatus currentStatus;
    private final Set<IObservable> autosaveBindings;
    private final IdentitySet<IPropertyListener> propertyListeners;
    private boolean saveError;

    protected AbstractBreakpointDetailEditor(boolean mnemonics, boolean autosave, IdentitySet<IPropertyListener> listeners) {
        this.mnemonics = mnemonics;
        this.autosaveBindings = autosave ? new HashSet() : null;
        this.propertyListeners = listeners;
    }

    public Composite createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)LayoutUtils.newCompositeGrid());
        this.addContent(this.composite);
        this.initBindings();
        return this.composite;
    }

    protected void addContent(Composite parent) {
    }

    protected Control getComposite() {
        return this.composite;
    }

    protected String checkLabel(String text) {
        if (this.mnemonics) {
            return text;
        }
        return MessageUtils.removeMnemonics((String)text);
    }

    protected DataBindingContext getDataBindingContext() {
        return this.dbc;
    }

    protected void initBindings() {
        Realm realm = Realm.getDefault();
        this.dbc = new DataBindingContext(realm);
        this.addBindings(this.dbc, realm);
        this.aggregateStatus = new AggregateValidationStatus(this.dbc, 2);
        this.aggregateStatus.addValueChangeListener((IValueChangeListener)new IValueChangeListener<IStatus>(){

            public void handleValueChange(ValueChangeEvent<? extends IStatus> event) {
                AbstractBreakpointDetailEditor.this.currentStatus = (IStatus)event.diff.getNewValue();
            }
        });
        this.currentStatus = ValidationStatus.ok();
        new DirtyTracker(this.dbc){

            public void handleChange(ObservableEvent event) {
                if (!AbstractBreakpointDetailEditor.this.ignoreChanges && AbstractBreakpointDetailEditor.this.autosaveBindings != null && event != null && AbstractBreakpointDetailEditor.this.autosaveBindings.contains(event.getObservable())) {
                    AbstractBreakpointDetailEditor.this.save();
                    return;
                }
                if (!this.isDirty()) {
                    AbstractBreakpointDetailEditor.this.setDirty(true);
                }
            }
        };
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractBreakpointDetailEditor.this.disposeBindings();
            }
        });
    }

    protected void enableAutosave(Binding binding) {
        this.autosaveBindings.add(binding.getModel());
    }

    private void disposeBindings() {
        if (this.aggregateStatus != null) {
            this.aggregateStatus.dispose();
            this.aggregateStatus = null;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
        if (this.autosaveBindings != null) {
            this.autosaveBindings.clear();
        }
    }

    protected void addBindings(DataBindingContext dbc, Realm realm) {
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void firePropertyChange(int propId) {
        if (this.propertyListeners != null) {
            for (IPropertyListener listener : this.propertyListeners) {
                listener.propertyChanged((Object)this, propId);
            }
        }
    }

    public IStatus getStatus() {
        return this.currentStatus;
    }

    public final void setInput(Object input) {
        this.ignoreChanges = true;
        try {
            this.doSetInput(input);
        }
        finally {
            this.ignoreChanges = false;
            this.setDirty(false);
        }
    }

    protected void doSetInput(Object input) {
    }

    protected void logLoadError(CoreException e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", "An error occurred when loading settings for the selected breakpoint."));
    }

    public final IStatus save() {
        this.saveError = false;
        try {
            this.doSave();
        }
        finally {
            if (!this.saveError) {
                this.setDirty(false);
            }
        }
        IStatus status = (IStatus)this.aggregateStatus.getValue();
        if ((status == null || status.isOK()) && this.saveError) {
            return new Status(4, "org.eclipse.statet.ecommons.debug.ui", "Failed to save all changes.");
        }
        return status;
    }

    protected void doSave() {
    }

    protected void logSaveError(CoreException e) {
        this.saveError = true;
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", "An error occurred when saving settings for the selected breakpoint."));
    }
}

