/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt;

import org.eclipse.statet.ecommons.ui.swt.util.ColorCache;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public final class SwtUtils {
    private static final ColorCache COLOR_CACHE = new ColorCache();

    static {
        COLOR_CACHE.get(0);
        COLOR_CACHE.get(0xFFFFFF);
        COLOR_CACHE.get(0xFF0000);
    }

    public static @Nullable Display getDisplay(@Nullable Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            try {
                return widget.getDisplay();
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ColorCache getColors() {
        return COLOR_CACHE;
    }

    public static void setSelection(StyledText styledText, int start, int end, int time) {
        Point prevSelection = styledText.getSelection();
        styledText.setSelection(start, end);
        Point newSelection = styledText.getSelection();
        if (!newSelection.equals((Object)prevSelection)) {
            Event event = new Event();
            event.display = styledText.getDisplay();
            event.widget = styledText;
            event.type = 13;
            event.time = time;
            event.x = newSelection.x;
            event.y = newSelection.y;
            styledText.notifyListeners(13, event);
        }
    }

    public static void setSelection(StyledText styledText, int offset, int time) {
        SwtUtils.setSelection(styledText, offset, offset, time);
    }

    public static <T extends Resource> @Nullable T dispose(@Nullable T resource) {
        if (resource != null) {
            resource.dispose();
        }
        return null;
    }

    public static <T extends Resource> @Nullable T dispose(@Nullable T resource1, @Nullable T resource2) {
        if (resource1 != null) {
            resource1.dispose();
        }
        if (resource2 != null) {
            resource2.dispose();
        }
        return null;
    }

    public static <T extends Widget> @Nullable T dispose(@Nullable T widget) {
        if (widget != null) {
            widget.dispose();
        }
        return null;
    }

    public static <T extends Resource> AutoDisposeReference<T> autoDispose(T resource) {
        return new AutoDisposeReference<T>(resource){

            @Override
            public void close() {
                ((Resource)this.get()).dispose();
            }
        };
    }

    public static <T extends Widget> AutoDisposeReference<T> autoDispose(T resource) {
        return new AutoDisposeReference<T>(resource){

            @Override
            public void close() {
                ((Widget)this.get()).dispose();
            }
        };
    }

    private SwtUtils() {
    }

    public static abstract class AutoDisposeReference<TResource>
    implements AutoCloseable {
        private final TResource resource;

        private AutoDisposeReference(TResource resource) {
            this.resource = resource;
        }

        public final TResource get() {
            return this.resource;
        }

        @Override
        public abstract void close();
    }
}

