/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.UIResources;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchLabelUtil;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpSearchUIMatch;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.r.ui.rhelp.RHelpUI;
import org.eclipse.statet.rhelp.core.RHelpKeyword;
import org.eclipse.statet.rhelp.core.RHelpKeywordGroup;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;

public class RHelpLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String TITLE_SEP = " \u2013 ";
    public static final int WITH_TITLE = 1;
    public static final int WITH_QUALIFIER = 2;
    public static final int HEADER = 32;
    public static final int TOOLTIP = 16;
    private boolean tooltip;
    private final boolean withTitle;
    private boolean withQualifier;
    private Object focusObject;
    private final StyledString.Styler defaultStyler;
    private final SharedUIResources commonUIResources = SharedUIResources.INSTANCE;
    private final UIResources helpUIResources = RHelpUI.getUIResources();

    public static void append(StyledString string, RHelpSearchMatch.MatchFragment fragment) {
        String text = fragment.getText();
        int startIdx = 0;
        int endIdx = 0;
        while ((startIdx = text.indexOf("<SMATCH-", endIdx)) >= 0) {
            int m;
            if (startIdx > endIdx) {
                string.append(text.substring(endIdx, startIdx));
            }
            if ((endIdx = text.indexOf(RHelpSearchMatch.POST_TAGS[m = text.charAt(startIdx + 8) - 65], startIdx += 10)) < 0) {
                return;
            }
            string.append(text.substring(startIdx, endIdx), TextSearchLabelUtil.HIGHLIGHT_STYLE);
            endIdx += 11;
        }
        if (endIdx < text.length()) {
            string.append(text.substring(endIdx, text.length()));
        }
    }

    public RHelpLabelProvider() {
        this(1);
    }

    public RHelpLabelProvider(int style) {
        this.tooltip = (style & 0x10) != 0;
        this.withQualifier = (style & 2) != 0;
        this.withTitle = (style & 0x11) != 0;
        this.defaultStyler = (style & 0x20) != 0 ? ElementLabelProvider.TITLE_STYLER : null;
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        if (viewer instanceof TableViewer) {
            this.withQualifier = true;
        }
    }

    public void setFocusObject(Object object) {
        this.focusObject = object;
    }

    public Image getImage(Object element) {
        if (element instanceof RHelpSearchUIMatch) {
            element = ((RHelpSearchUIMatch)element).getRHelpMatch().getPage();
        }
        if (element instanceof RHelpPage) {
            if (((RHelpPage)element).isInternal()) {
                return this.helpUIResources.getImage("org.eclipse.statet.r.ui.rhelp/images/obj/RHelp-Page.internal");
            }
            return this.helpUIResources.getImage("org.eclipse.statet.r.ui.rhelp/images/obj/RHelp-Page");
        }
        if (element instanceof RPkgHelp) {
            return this.helpUIResources.getImage("org.eclipse.statet.r/images/obj/R-Package");
        }
        if (element instanceof REnvConfiguration || element instanceof REnv) {
            return RUI.getImage("org.eclipse.statet.r/images/obj/REnv");
        }
        if (element instanceof RHelpSearchMatch.MatchFragment) {
            return this.commonUIResources.getImage("org.eclipse.statet.ecommons.uimisc/images/obj/LineMatch");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof RHelpSearchUIMatch) {
            element = ((RHelpSearchUIMatch)element).getRHelpMatch().getPage();
        }
        if (element instanceof RHelpPage) {
            StringBuilder sb = new StringBuilder(32);
            RHelpPage page = (RHelpPage)element;
            sb.append(page.getName());
            if (this.tooltip) {
                sb.append(" {");
                sb.append(page.getPackage().getName());
                sb.append("}\n");
                sb.append(page.getTitle());
            } else if (this.withTitle && page.getTitle().length() > 0) {
                sb.append(TITLE_SEP);
                sb.append(page.getTitle());
            }
            return sb.toString();
        }
        if (element instanceof RPkgHelp) {
            StringBuilder sb = new StringBuilder(32);
            RPkgHelp packageHelp = (RPkgHelp)element;
            if (this.tooltip) {
                sb.append(packageHelp.getName());
                sb.append(" [");
                sb.append(packageHelp.getVersion());
                sb.append("]\n");
                sb.append(packageHelp.getTitle());
            } else {
                sb.append(packageHelp.getName());
                if (element == this.focusObject && packageHelp.getTitle().length() > 0) {
                    sb.append(TITLE_SEP);
                    sb.append(packageHelp.getTitle());
                }
            }
            return sb.toString();
        }
        if (element instanceof REnvConfiguration) {
            REnvConfiguration rEnv = (REnvConfiguration)element;
            return rEnv.getName();
        }
        if (element instanceof REnv) {
            REnv rEnv = (REnv)element;
            String name = rEnv.getName();
            return name != null ? name : "";
        }
        if (element instanceof RHelpKeywordGroup) {
            RHelpKeywordGroup group = (RHelpKeywordGroup)element;
            return group.getLabel() + TITLE_SEP + group.getDescription();
        }
        if (element instanceof RPkgHelp) {
            RHelpKeyword keyword = (RHelpKeyword)element;
            return keyword.getKeyword() + TITLE_SEP + keyword.getDescription();
        }
        if (element instanceof RHelpSearchMatch.MatchFragment) {
            RHelpSearchMatch.MatchFragment fragment = (RHelpSearchMatch.MatchFragment)element;
            return RHelpSearchMatch.ALL_TAGS_PATTERN.matcher(fragment.getText()).replaceAll("");
        }
        if (element instanceof Object[]) {
            Object[] array = (Object[])element;
            return array[array.length - 1].toString();
        }
        return element.toString();
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }

    public String getToolTipText(Object element) {
        boolean wasTooltip = this.tooltip;
        try {
            this.tooltip = true;
            String string = this.getText(element);
            return string;
        }
        finally {
            this.tooltip = wasTooltip;
        }
    }

    public StyledString getStyledText(Object element) {
        StyledString text = new StyledString();
        if (element instanceof RHelpSearchUIMatch) {
            RHelpSearchMatch match = ((RHelpSearchUIMatch)element).getRHelpMatch();
            RHelpPage page = match.getPage();
            text.append(page.getName(), this.defaultStyler);
            if (this.withTitle && page.getTitle().length() > 0) {
                text.append(TITLE_SEP, this.defaultStyler);
                text.append(page.getTitle(), this.defaultStyler);
            }
            if (this.withQualifier) {
                text.append(" - ", StyledString.QUALIFIER_STYLER);
                text.append(page.getPackage().getName(), StyledString.QUALIFIER_STYLER);
            } else if (match.getMatchCount() > 0) {
                text.append(" (", StyledString.COUNTER_STYLER);
                text.append(Integer.toString(match.getMatchCount()), StyledString.COUNTER_STYLER);
                text.append(")", StyledString.COUNTER_STYLER);
            }
        } else if (element instanceof RHelpPage) {
            RHelpPage page = (RHelpPage)element;
            text.append(page.getName(), this.defaultStyler);
            if (this.withTitle && page.getTitle().length() > 0) {
                text.append(TITLE_SEP, this.defaultStyler);
                text.append(page.getTitle(), this.defaultStyler);
            }
            if (this.withQualifier) {
                text.append(" - ", StyledString.QUALIFIER_STYLER);
                text.append(page.getPackage().getName(), StyledString.QUALIFIER_STYLER);
            }
        } else if (element instanceof RPkgHelp) {
            RPkgHelp packageHelp = (RPkgHelp)element;
            text.append(packageHelp.getName(), this.defaultStyler);
            if (packageHelp == this.focusObject && packageHelp.getTitle().length() > 0) {
                text.append(TITLE_SEP, this.defaultStyler);
                text.append(packageHelp.getTitle(), this.defaultStyler);
            }
        } else if (element instanceof RHelpKeywordGroup) {
            RHelpKeywordGroup group = (RHelpKeywordGroup)element;
            text.append(group.getLabel());
            text.append(" - " + group.getDescription(), StyledString.QUALIFIER_STYLER);
        } else if (element instanceof RHelpKeyword) {
            RHelpKeyword keyword = (RHelpKeyword)element;
            text.append(keyword.getKeyword());
            text.append(" - " + keyword.getDescription(), StyledString.QUALIFIER_STYLER);
        } else if (element instanceof REnvConfiguration) {
            REnvConfiguration rEnv = (REnvConfiguration)element;
            text.append(rEnv.getName());
        } else if (element instanceof REnv) {
            REnv rEnv = (REnv)element;
            String name = rEnv.getName();
            text.append(name != null ? name : "", this.defaultStyler);
        } else if (element instanceof RHelpSearchMatch.MatchFragment) {
            RHelpSearchMatch.MatchFragment fragment = (RHelpSearchMatch.MatchFragment)element;
            String fieldLabel = fragment.getFieldLabel();
            if (fieldLabel != null) {
                text.append(fieldLabel, StyledString.QUALIFIER_STYLER);
                text.append(": ", StyledString.QUALIFIER_STYLER);
            }
            RHelpLabelProvider.append(text, fragment);
        } else if (element instanceof Object[]) {
            Object[] array = (Object[])element;
            text.append(array[array.length - 1].toString());
        } else {
            text.append(element.toString());
        }
        return text;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        Image image = this.getImage(element);
        StyledString text = this.getStyledText(element);
        cell.setImage(image);
        cell.setText(text.getString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
        if (!applyColors && styleRange.background != null) {
            styleRange = super.prepareStyleRange(styleRange, applyColors);
            styleRange.borderStyle = 4;
            return styleRange;
        }
        return super.prepareStyleRange(styleRange, applyColors);
    }
}

