/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.coordinate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.jcommons.collections.LongIterator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class LRangeList
extends ArrayList<LRange>
implements Set<LRange> {
    private static final long serialVersionUID = 1L;
    private final Values values = new Values();

    public static LRangeList toRangeList(Collection<LRange> collection) {
        if (collection instanceof LRangeList) {
            return (LRangeList)collection;
        }
        LRangeList list = new LRangeList();
        for (LRange lRange : collection) {
            list.add(lRange);
        }
        return list;
    }

    public LRangeList() {
    }

    public LRangeList(LRange ... initialRanges) {
        this();
        int i = 0;
        while (i < initialRanges.length) {
            this.add(initialRanges[i]);
            ++i;
        }
    }

    public LRangeList(long ... initialValues) {
        this();
        int i = 0;
        while (i < initialValues.length) {
            this.values.add(initialValues[i]);
            ++i;
        }
    }

    private int indexOfStart(long value) {
        int low = 0;
        int high = super.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midValue = ((LRange)this.get((int)mid)).start;
            if (value > midValue) {
                low = mid + 1;
                continue;
            }
            if (value < midValue) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }

    @Override
    public boolean add(LRange lRange) {
        if (lRange.start == lRange.end) {
            return false;
        }
        int idx = this.indexOfStart(lRange.start);
        if (idx >= 0) {
            LRange range1 = (LRange)this.get(idx);
            if (lRange.end <= range1.end) {
                return false;
            }
            range1.end = lRange.end;
            this.checkMergeNext(range1, idx + 1);
            return true;
        }
        if ((idx ^= 0xFFFFFFFF) > 0) {
            LRange range1 = (LRange)this.get(idx - 1);
            if (lRange.end <= range1.end) {
                return false;
            }
            if (lRange.start <= range1.end) {
                range1.end = lRange.end;
                this.checkMergeNext(range1, idx);
                return true;
            }
        }
        if (idx < this.size()) {
            LRange range2 = (LRange)this.get(idx);
            if (lRange.end >= range2.start) {
                range2.start = lRange.start;
                if (lRange.end > range2.end) {
                    range2.end = lRange.end;
                    this.checkMergeNext(range2, idx + 1);
                }
                return true;
            }
        }
        super.add(idx, lRange);
        return true;
    }

    @Override
    public void add(int index, LRange element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends LRange> c) {
        boolean changed = false;
        for (LRange lRange : c) {
            changed |= this.add(lRange);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends LRange> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LRange set(int index, LRange element) {
        throw new UnsupportedOperationException();
    }

    private void checkMergeNext(LRange lRange, int nextIdx) {
        while (nextIdx < this.size()) {
            LRange range2 = (LRange)this.get(nextIdx);
            if (lRange.end < range2.start) break;
            this.remove(nextIdx);
            if (lRange.end > range2.end) continue;
            lRange.end = range2.end;
            return;
        }
    }

    public boolean remove(LRange lRange) {
        if (lRange.size() == 0L) {
            return false;
        }
        int idx = this.indexOfStart(lRange.start);
        if (idx >= 0) {
            LRange range1 = (LRange)this.get(idx);
            if (lRange.end < range1.end) {
                range1.start = lRange.end;
                return true;
            }
            super.remove(idx);
            if (lRange.end == range1.end) {
                return true;
            }
            this.checkRemoveNext(lRange, idx);
            return true;
        }
        if ((idx ^= 0xFFFFFFFF) > 0) {
            LRange range1 = (LRange)this.get(idx - 1);
            if (lRange.start < range1.end) {
                if (lRange.end < range1.end) {
                    super.add(idx++, new LRange(lRange.end, range1.end));
                }
                range1.end = lRange.start;
                this.checkRemoveNext(lRange, idx);
                return true;
            }
        }
        return this.checkRemoveNext(lRange, idx);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        if (o instanceof LRange) {
            return this.remove((LRange)o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!(o instanceof LRange)) continue;
            changed |= this.remove((LRange)o);
        }
        return changed;
    }

    private boolean checkRemoveNext(LRange lRange, int nextIdx) {
        boolean changed = false;
        while (nextIdx < this.size()) {
            LRange range2 = (LRange)this.get(nextIdx);
            if (lRange.end < range2.start) break;
            if (lRange.end < range2.end) {
                range2.start = lRange.end;
                return true;
            }
            this.remove(nextIdx);
            changed = true;
            if (lRange.end != range2.end) continue;
            return true;
        }
        return changed;
    }

    public Values values() {
        return this.values;
    }

    public static final class ValueIterator
    implements LongIterator {
        private final Iterator<LRange> rangeIter;
        private long nextValue;
        private long rangeEnd = -1L;

        public ValueIterator(Collection<LRange> c) {
            this.rangeIter = c.iterator();
        }

        public boolean hasNext() {
            while (this.nextValue >= this.rangeEnd) {
                if (!this.rangeIter.hasNext()) {
                    return false;
                }
                LRange lRange = this.rangeIter.next();
                this.nextValue = lRange.start;
                this.rangeEnd = lRange.end;
            }
            return true;
        }

        public long nextLong() {
            while (this.nextValue >= this.rangeEnd) {
                LRange lRange = this.rangeIter.next();
                this.nextValue = lRange.start;
                this.rangeEnd = lRange.end;
            }
            return this.nextValue++;
        }

        @Deprecated
        public long nextValue() {
            return this.nextLong();
        }
    }

    public final class Values
    implements Iterable<Long> {
        public boolean isEmpty() {
            return LRangeList.this.isEmpty();
        }

        public long size() {
            long count = 0L;
            int size = LRangeList.super.size();
            int i = 0;
            while (i < size) {
                count += ((LRange)LRangeList.super.get(i)).size();
                ++i;
            }
            return count;
        }

        public boolean contains(long value) {
            int idx = LRangeList.this.indexOfStart(value);
            if (idx >= 0) {
                return true;
            }
            if ((idx ^= 0xFFFFFFFF) > 0) {
                LRange range1 = (LRange)LRangeList.super.get(idx - 1);
                return value < range1.end;
            }
            return false;
        }

        public LongIterator iterator() {
            return new ValueIterator(LRangeList.this);
        }

        public boolean add(long value) {
            int idx = LRangeList.this.indexOfStart(value);
            if (idx >= 0) {
                return false;
            }
            if ((idx ^= 0xFFFFFFFF) > 0) {
                LRange range1 = (LRange)LRangeList.super.get(idx - 1);
                if (value < range1.end) {
                    return false;
                }
                if (value == range1.end) {
                    range1.end = value + 1L;
                    LRangeList.this.checkMergeNext(range1, idx);
                    return true;
                }
            }
            if (idx < LRangeList.super.size()) {
                LRange range2 = (LRange)LRangeList.super.get(idx);
                if (value == range2.start - 1L) {
                    range2.start = value;
                    return true;
                }
            }
            LRangeList.super.add(idx, new LRange(value));
            return true;
        }

        public boolean remove(long value) {
            int idx = LRangeList.this.indexOfStart(value);
            if (idx >= 0) {
                LRange range1 = (LRange)LRangeList.super.get(idx);
                if (value == range1.end - 1L) {
                    LRangeList.super.remove(idx);
                    return true;
                }
                ++range1.start;
                return true;
            }
            if ((idx ^= 0xFFFFFFFF) > 0) {
                LRange range1 = (LRange)LRangeList.super.get(idx - 1);
                if (value >= range1.end) {
                    return false;
                }
                if (value == range1.end - 1L) {
                    --range1.end;
                    return true;
                }
                LRangeList.super.add(idx, new LRange(value + 1L, range1.end));
                range1.end = value;
                return true;
            }
            return false;
        }

        public void clear() {
            LRangeList.this.clear();
        }

        public long first() {
            return ((LRange)LRangeList.super.getFirst()).start;
        }

        public long last() {
            return ((LRange)LRangeList.super.getLast()).end - 1L;
        }

        public @Nullable LRange getRangeOf(long value) {
            int idx = LRangeList.this.indexOfStart(value);
            if (idx >= 0) {
                return (LRange)LRangeList.super.get(idx);
            }
            if ((idx ^= 0xFFFFFFFF) > 0) {
                LRange range1 = (LRange)LRangeList.super.get(idx - 1);
                if (value < range1.end) {
                    return range1;
                }
            }
            return null;
        }

        private List<LRange> getRangeList() {
            return LRangeList.this;
        }

        public int hashCode() {
            return LRangeList.this.hashCode() ^ 0x159;
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Values && LRangeList.this.equals(((Values)obj).getRangeList());
        }
    }
}

