/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class TransformLayer<TLayerDim extends ForwardLayerDim<? extends TransformLayer<TLayerDim>>>
extends ForwardLayer<TLayerDim> {
    public TransformLayer(Layer underlyingLayer, @Nullable LayerPainter layerPainter) {
        super(underlyingLayer, layerPainter);
    }

    public TransformLayer(Layer underlyingLayer) {
        this(underlyingLayer, null);
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        LayerCell underlyingCell = this.getUnderlyingLayer().getCellByPosition(((ForwardLayerDim)this.getDim(Orientation.HORIZONTAL)).localToUnderlyingPosition(columnPosition, columnPosition), ((ForwardLayerDim)this.getDim(Orientation.VERTICAL)).localToUnderlyingPosition(rowPosition, rowPosition));
        return this.createCell(this.transformCellDim(underlyingCell.getDim(Orientation.HORIZONTAL), columnPosition), this.transformCellDim(underlyingCell.getDim(Orientation.VERTICAL), rowPosition), underlyingCell);
    }

    protected LayerCellDim transformCellDim(LayerCellDim underlyingDim, long position) {
        if (underlyingDim.getPosition() == position) {
            return underlyingDim;
        }
        long originPosition = position - (underlyingDim.getPosition() - underlyingDim.getOriginPosition());
        return new BasicLayerCellDim(underlyingDim.getOrientation(), underlyingDim.getId(), position, originPosition, underlyingDim.getPositionSpan());
    }
}

