/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.page;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.AbstractFragmentDocument;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.internal.r.console.ui.page.RConsolePage;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.nico.ui.console.GenericConsoleSourceUnit;
import org.eclipse.statet.r.console.ui.RConsole;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.build.RSourceUnitModelContainer;
import org.eclipse.statet.r.core.source.doc.RDocumentContentInfo;

@NonNullByDefault
public class RConsoleSourceUnit
extends GenericConsoleSourceUnit
implements RSourceUnit {
    private final RConsole rConsole;
    private final RSourceUnitModelContainer model = new RSourceUnitModelContainer(this, (SourceUnitIssueSupport)RUIPlugin.getInstance().getRDocumentProvider()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SourceContent getParseContent(IProgressMonitor monitor) {
            AbstractFragmentDocument doc = RConsoleSourceUnit.this.getDocument();
            Object object = TextUtils.getLockObject((Object)doc);
            synchronized (object) {
                return new SourceContent(doc.getModificationStamp(), doc.getMasterDocument().get(), -doc.getOffsetInMasterDocument());
            }
        }
    };

    public RConsoleSourceUnit(RConsolePage page, AbstractFragmentDocument document) {
        super(((Object)((Object)page)).toString(), document);
        this.rConsole = page.getConsole();
    }

    public String getModelTypeId() {
        return "R";
    }

    public DocContentSections getDocumentContentInfo() {
        return RDocumentContentInfo.INSTANCE;
    }

    public @Nullable AstInfo getAstInfo(@Nullable String type, boolean ensureSync, IProgressMonitor monitor) {
        if (type == null || this.model.isContainerFor(type)) {
            return this.model.getAstInfo(ensureSync, monitor);
        }
        return null;
    }

    public @Nullable SourceUnitModelInfo getModelInfo(@Nullable String type, int flags, IProgressMonitor monitor) {
        if (type == null || this.model.isContainerFor(type)) {
            return this.model.getModelInfo(flags, monitor);
        }
        return null;
    }

    public void syncExec(SourceDocumentRunnable runnable) throws InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public RCoreAccess getRCoreAccess() {
        return this.rConsole;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RCoreAccess.class) {
            return (T)this.getRCoreAccess();
        }
        if (adapterType == PreferenceAccess.class) {
            return (T)this.getRCoreAccess().getPrefs();
        }
        return (T)super.getAdapter(adapterType);
    }
}

