# This file contains tests for the routines in the file tclUnixFile.c
#
# This file contains a collection of tests for one or more of the Tcl
# built-in commands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: unixFile.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $

if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest
    namespace import -force ::tcltest::*
}

if {[info commands testobj] == {}} {
    puts "This application hasn't been compiled with the \"testfindexecutable\""
    puts "command, so I can't test the Tcl_FindExecutable function"
    ::tcltest::cleanupTests
    return
}

set oldpwd [pwd]
cd [temporaryDirectory]

catch {
    set oldPath $env(PATH)
    file attributes [makeFile "" junk] -perm 0777
}
set absPath [file join [temporaryDirectory] junk]

test unixFile-1.1 {Tcl_FindExecutable} {unixOnly} {
    set env(PATH) ""
    testfindexecutable junk
} $absPath
test unixFile-1.2 {Tcl_FindExecutable} {unixOnly} {
    set env(PATH) "/dummy"
    testfindexecutable junk
} {}
test unixFile-1.3 {Tcl_FindExecutable} {unixOnly} {
    set env(PATH) "/dummy:[pwd]"
    testfindexecutable junk
} $absPath
test unixFile-1.4 {Tcl_FindExecutable} {unixOnly} {
    set env(PATH) "/dummy:"
    testfindexecutable junk
} $absPath
test unixFile-1.5 {Tcl_FindExecutable} {unixOnly} {
    set env(PATH) "/dummy:/dummy"
    testfindexecutable junk
} {}
test unixFile-1.6 {Tcl_FindExecutable} {unixOnly} {
    set env(PATH) "/dummy::/dummy"
    testfindexecutable junk
} $absPath
test unixFile-1.7 {Tcl_FindExecutable} {unixOnly} {
    set env(PATH) ":/dummy"
    testfindexecutable junk
} $absPath

# cleanup
catch {set env(PATH) $oldPath}
removeFile junk
cd $oldpwd
::tcltest::cleanupTests
return
