/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DLTKTclHelper {
    public static List getScriptOutput(InputStream stream) {
        ArrayList elements;
        block2: {
            elements = new ArrayList();
            final BufferedReader input = new BufferedReader(new InputStreamReader(stream));
            Thread t = new Thread(new Runnable(){

                public void run() {
                    block3: {
                        try {
                            String line;
                            while ((line = input.readLine()) != null) {
                                elements.add(line);
                            }
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block3;
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
            try {
                t.join(50000L);
            }
            catch (InterruptedException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return elements;
    }

    private static List deployExecute(IExecutionEnvironment exeEnv, String installLocation, String[] arguments, EnvironmentVariable[] env) {
        Process process;
        IDeployment deployment;
        block5: {
            deployment = exeEnv.createDeployment();
            IFileHandle script = DLTKTclHelper.deploy(deployment);
            if (script == null) {
                return null;
            }
            IFileHandle workingDir = script.getParent();
            InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])env);
            config.removeEnvVar("DISPLAY");
            if (arguments != null) {
                config.addScriptArgs(arguments);
            }
            process = null;
            try {
                process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)installLocation, (InterpreterConfig)config);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (process == null) {
            return new ArrayList();
        }
        List output = DLTKTclHelper.getScriptOutput(process.getInputStream());
        DLTKTclHelper.getScriptOutput(process.getErrorStream());
        process.destroy();
        deployment.dispose();
        return output;
    }

    private static IFileHandle deploy(IDeployment deployment) {
        IFileHandle script;
        try {
            IPath path = deployment.add(TclPlugin.getDefault().getBundle(), "scripts/dltk.tcl");
            script = deployment.getFile(path);
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        return script;
    }

    public static String[] getDefaultPath(IFileHandle installLocation, EnvironmentVariable[] environment) {
        return new String[0];
    }

    public static TclPackage[] getSrcs(IExecutionEnvironment exeEnv, IFileHandle installLocation, EnvironmentVariable[] environment, String packageName) {
        Process process;
        IDeployment deployment;
        block7: {
            deployment = exeEnv.createDeployment();
            IFileHandle script = DLTKTclHelper.deploy(deployment);
            if (script == null) {
                return null;
            }
            IFileHandle workingDir = script.getParent();
            InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])environment);
            String names = packageName;
            ByteArrayInputStream bais = new ByteArrayInputStream(names.getBytes());
            IPath packagesPath = null;
            try {
                packagesPath = deployment.add((InputStream)bais, "packages.txt");
            }
            catch (IOException e1) {
                if (DLTKCore.DEBUG) {
                    e1.printStackTrace();
                }
                return null;
            }
            IFileHandle file = deployment.getFile(packagesPath);
            config.removeEnvVar("DISPLAY");
            String[] arguments = new String[]{"get-srcs", "-fpkgs", file.toOSString()};
            config.addScriptArgs(arguments);
            process = null;
            try {
                process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)installLocation.toOSString(), (InterpreterConfig)config);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block7;
                e.printStackTrace();
            }
        }
        if (process == null) {
            return null;
        }
        List output = DLTKTclHelper.getScriptOutput(process.getInputStream());
        DLTKTclHelper.getScriptOutput(process.getErrorStream());
        process.destroy();
        deployment.dispose();
        return DLTKTclHelper.getPackagePath(output);
    }

    private static boolean isElementName(Node nde, String name) {
        return nde != null && nde.getNodeType() == 1 && name.equalsIgnoreCase(nde.getNodeName());
    }

    private static String[] getAutoPath(List content) {
        String text = DLTKTclHelper.getXMLContent(content);
        Document document = DLTKTclHelper.getDocument(text);
        HashSet<String> paths = new HashSet<String>();
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList childNodes = element.getChildNodes();
            int len = childNodes.getLength();
            int i = 0;
            while (i < len) {
                Element el;
                String path;
                Node nde = childNodes.item(i);
                if (DLTKTclHelper.isElementName(nde, "path") && (path = (el = (Element)nde).getAttribute("name")).length() > 0) {
                    paths.add(path);
                }
                ++i;
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    public static TclPackage[] getPackagePath(List content) {
        String text = DLTKTclHelper.getXMLContent(content);
        Document document = DLTKTclHelper.getDocument(text);
        HashMap packages = new HashMap();
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList childNodes = element.getChildNodes();
            int len = childNodes.getLength();
            int i = 0;
            while (i < len) {
                Node nde = childNodes.item(i);
                if (DLTKTclHelper.isElementName(nde, "path")) {
                    Element el = (Element)nde;
                    NodeList elChilds = el.getChildNodes();
                    int j = 0;
                    while (j < elChilds.getLength()) {
                        Node pkgNde = elChilds.item(j);
                        if (DLTKTclHelper.isElementName(pkgNde, "package")) {
                            DLTKTclHelper.populatePackage(packages, pkgNde);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return packages.values().toArray(new TclPackage[packages.size()]);
    }

    private static void populatePackage(Map packages, Node pkgNde) {
        Element pkg = (Element)pkgNde;
        String pkgName = pkg.getAttribute("name");
        TclPackage tclPackage = new TclPackage(pkgName);
        if (packages.containsKey(tclPackage)) {
            tclPackage = (TclPackage)packages.get(tclPackage);
        } else {
            packages.put(tclPackage, tclPackage);
        }
        NodeList childs = pkg.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            String name;
            Element el;
            Node nde = childs.item(i);
            if (DLTKTclHelper.isElementName(nde, "source")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                IPath path = new Path(name).removeLastSegments(1);
                tclPackage.getPaths().add(path);
            } else if (DLTKTclHelper.isElementName(nde, "require")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                tclPackage.getDependencies().add(name);
            }
            ++i;
        }
    }

    private static Document getDocument(String text) {
        block5: {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                Document document = parser.parse(new ByteArrayInputStream(text.getBytes()));
                return document;
            }
            catch (IOException iOException) {
            }
            catch (ParserConfigurationException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (SAXException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String getXMLContent(List content) {
        StringBuffer newList = new StringBuffer();
        if (content != null) {
            Iterator iterator = content.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if (!line.trim().startsWith("<")) continue;
                newList.append(line).append("\n");
            }
        }
        return newList.toString();
    }

    public static Set getPackages(IInterpreterInstall install) {
        IExecutionEnvironment exeEnv = install.getExecEnvironment();
        List content = DLTKTclHelper.deployExecute(exeEnv, install.getInstallLocation().toOSString(), new String[]{"get-pkgs"}, install.getEnvironmentVariables());
        HashSet<String> packages = new HashSet<String>();
        TclPackage[] packagePath = DLTKTclHelper.getPackagePath(content);
        int i = 0;
        while (i < packagePath.length) {
            packages.add(packagePath[i].getName());
            ++i;
        }
        return packages;
    }

    public static class TclPackage {
        private String name;
        private Set paths = new HashSet();
        private Set dependencies = new HashSet();

        public TclPackage(String name) {
            this.name = name;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TclPackage other = (TclPackage)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set getPaths() {
            return this.paths;
        }

        public void setPaths(Set paths) {
            this.paths = paths;
        }

        public Set getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Set dependencies) {
            this.dependencies = dependencies;
        }
    }
}

