/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.declarations;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.Modifiers;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.utils.CorePrinter;

public abstract class Declaration
extends Statement
implements Modifiers {
    public static final int D_ARGUMENT = 3000;
    public static final int D_CLASS = 3001;
    public static final int D_METHOD = 3002;
    public static final int D_DECLARATOR = 3004;
    SimpleReference ref;
    protected int modifiers;
    private String comments;

    protected Declaration() {
        this.modifiers = 0;
        this.ref = new SimpleReference(0, 0, null);
    }

    protected Declaration(int start, int end) {
        super(start, end);
        this.modifiers = 0;
    }

    protected Declaration(DLTKToken name, int start, int end) {
        super(start, end);
        this.ref = name != null ? new SimpleReference(name) : new SimpleReference(start, end, null);
    }

    public final int getNameStart() {
        return this.ref.sourceStart();
    }

    public final int getNameEnd() {
        return this.ref.sourceEnd();
    }

    protected ISourceRange getNameSourceRange() {
        return new SourceRange(this.getNameStart(), this.getNameEnd() - this.getNameStart() + 1);
    }

    public String getName() {
        return this.ref.getName();
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final PositionInformation getPositionInformation() {
        return new PositionInformation(this.getNameStart(), this.getNameEnd(), this.sourceStart(), this.sourceEnd());
    }

    public final void setModifier(int mods) {
        this.modifiers |= mods;
    }

    public final void setModifiers(int mods) {
        this.modifiers = mods;
    }

    public final void setName(String name) {
        if (this.ref == null) {
            this.ref = new SimpleReference(0, 0, name);
        } else {
            this.ref.setName(name);
        }
    }

    public void setNameEnd(int end) {
        this.ref.setEnd(end);
    }

    public void setNameStart(int start) {
        this.ref.setStart(start);
    }

    public boolean isStatic() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 8) != 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isStatic()) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append("static");
        }
        if (this.ref.getName() != null) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(this.ref.getName());
        }
        return sb.toString();
    }

    @Override
    public int getKind() {
        return 0;
    }

    @Override
    public void printNode(CorePrinter output) {
    }

    @Override
    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit(this)) {
            this.ref.traverse(pVisitor);
            pVisitor.endvisit(this);
        }
    }

    @Override
    public String debugString() {
        return String.valueOf(super.debugString()) + this.getNameSourceRange().toString();
    }

    public SimpleReference getRef() {
        return this.ref;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getComments() {
        return this.comments;
    }
}

