/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.project;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JsNature
implements IProjectNature {
    private static final String[] NATURE_IDS = new String[]{"org.eclipse.wst.jsdt.core.jsNature"};
    private static final String SUPER_TYPE_NAME = JavaUIMessages.JsNature_Global;
    private static final String SUPER_TYPE_LIBRARY = "org.eclipse.wst.jsdt.launching.JRE_CONTAINER";
    private Vector classPathEntries = new Vector();
    private boolean DEBUG = false;
    private IProject fCurrProject;
    private JavaProject fJavaProject;
    private IPath fOutputLocation;
    private IProgressMonitor monitor;

    public static void addJsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!JsNature.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + NATURE_IDS.length];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            int i = 0;
            while (i < NATURE_IDS.length) {
                newNatures[prevNatures.length + i] = NATURE_IDS[i];
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasNature(IProject project) {
        try {
            int i = 0;
            while (true) {
                if (i >= NATURE_IDS.length) {
                    return true;
                }
                if (!project.hasNature(NATURE_IDS[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static void removeJsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (JsNature.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length - NATURE_IDS.length];
            int k = 0;
            int i = 0;
            while (i < prevNatures.length) {
                block7: {
                    int j = 0;
                    while (j < NATURE_IDS.length) {
                        if (!prevNatures[i].equals(NATURE_IDS[j])) {
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    newNatures[k++] = prevNatures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public JsNature() {
        this.monitor = new NullProgressMonitor();
    }

    public JsNature(IProject project, IProgressMonitor monitor) {
        this.fCurrProject = project;
        if (monitor != null) {
            this.monitor = monitor;
        } else {
            monitor = new NullProgressMonitor();
        }
    }

    public void configure() throws CoreException {
        IIncludePathEntry[] entries;
        this.initOutputPath();
        this.createSourceClassPath();
        this.initJREEntry();
        this.initLocalClassPath();
        if (this.hasProjectClassPathFile() && (entries = this.getRawClassPath()) != null && entries.length > 0) {
            this.classPathEntries.removeAll(Arrays.asList(entries));
            this.classPathEntries.addAll(Arrays.asList(entries));
        }
        JsNature.addJsNature(this.fCurrProject, this.monitor);
        this.fJavaProject = (JavaProject)JavaScriptCore.create((IProject)this.fCurrProject);
        this.fJavaProject.setProject(this.fCurrProject);
        try {
            if (!this.hasProjectClassPathFile()) {
                this.fJavaProject.setRawIncludepath(this.classPathEntries.toArray(new IIncludePathEntry[0]), this.fOutputLocation, this.monitor);
            }
            if (this.hasProjectClassPathFile()) {
                this.fJavaProject.setRawIncludepath(this.classPathEntries.toArray(new IIncludePathEntry[0]), this.monitor);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        LibrarySuperType superType = new LibrarySuperType((IPath)new Path(SUPER_TYPE_LIBRARY), (IJavaScriptProject)this.getJavaProject(), SUPER_TYPE_NAME);
        this.getJavaProject().setCommonSuperType(superType);
        this.fCurrProject.refreshLocal(2, this.monitor);
    }

    private void createSourceClassPath() {
        if (this.hasAValidSourcePath()) {
            return;
        }
    }

    public void deconfigure() throws CoreException {
        Vector<IIncludePathEntry> badEntries = new Vector<IIncludePathEntry>();
        IIncludePathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
        IIncludePathEntry[] localEntries = this.initLocalClassPath();
        badEntries.addAll(Arrays.asList(defaultJRELibrary));
        badEntries.addAll(Arrays.asList(localEntries));
        IIncludePathEntry[] entries = this.getRawClassPath();
        Vector<IIncludePathEntry> goodEntries = new Vector<IIncludePathEntry>();
        int i = 0;
        while (i < entries.length) {
            if (!badEntries.contains(entries[i])) {
                goodEntries.add(entries[i]);
            }
            ++i;
        }
        IPath outputLocation = this.getJavaProject().getOutputLocation();
        this.getJavaProject().setRawIncludepath(goodEntries.toArray(new IIncludePathEntry[0]), outputLocation, this.monitor);
        this.getJavaProject().deconfigure();
        JsNature.removeJsNature(this.fCurrProject, this.monitor);
        this.fCurrProject.refreshLocal(2, this.monitor);
    }

    public JavaProject getJavaProject() {
        if (this.fJavaProject == null) {
            this.fJavaProject = (JavaProject)JavaScriptCore.create((IProject)this.fCurrProject);
            this.fJavaProject.setProject(this.fCurrProject);
        }
        return this.fJavaProject;
    }

    public IProject getProject() {
        return this.fCurrProject;
    }

    private IIncludePathEntry[] getRawClassPath() {
        JavaProject proj = new JavaProject();
        proj.setProject(this.fCurrProject);
        return proj.readRawIncludepath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAValidSourcePath() {
        if (!this.hasProjectClassPathFile()) return false;
        try {
            IIncludePathEntry[] entries = this.getRawClassPath();
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return false;
                }
                if (entries[i].getEntryKind() == 3) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            if (!this.DEBUG) return false;
            System.out.println("Error checking sourcepath:" + e);
        }
        return false;
    }

    private boolean hasProjectClassPathFile() {
        if (this.fCurrProject == null) {
            return false;
        }
        return this.fCurrProject.getFolder(".settings").getFile(".jsdtscope").exists();
    }

    private void initJREEntry() {
        block4: {
            IIncludePathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
            try {
                IIncludePathEntry[] entries = this.getRawClassPath();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i] == defaultJRELibrary[0]) {
                        return;
                    }
                    ++i;
                }
                this.classPathEntries.add(defaultJRELibrary[0]);
            }
            catch (Exception e) {
                if (!this.DEBUG) break block4;
                System.out.println("Error checking sourcepath:" + e);
            }
        }
    }

    private IIncludePathEntry[] initLocalClassPath() {
        IIncludePathEntry source = JavaScriptCore.newSourceEntry((IPath)this.fCurrProject.getFullPath().append("/"));
        return new IIncludePathEntry[]{source};
    }

    private void initOutputPath() {
        if (this.fOutputLocation == null) {
            this.fOutputLocation = this.fCurrProject.getFullPath();
        }
    }

    public void setProject(IProject project) {
        this.fCurrProject = project;
    }
}

