/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDataExportOperation;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataExportWizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TaskDataExportWizard
extends Wizard
implements IExportWizard {
    private static final String SETTINGS_SECTION = "org.eclipse.mylyn.tasklist.ui.exportWizard";
    private TaskDataExportWizardPage exportPage = null;

    public TaskDataExportWizard() {
        IDialogSettings masterSettings = TasksUiPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.TaskDataExportWizard_Export);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings settings = master.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = master.addNewSection(SETTINGS_SECTION);
        }
        return settings;
    }

    public void addPages() {
        this.exportPage = new TaskDataExportWizardPage();
        this.addPage((IWizardPage)this.exportPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        String destDir = this.exportPage.getDestinationDirectory();
        File destZipFile = new File(destDir + File.separator + TaskListBackupManager.getBackupFileName());
        TaskDataExportOperation job = new TaskDataExportOperation(this.exportPage.getDestinationDirectory(), destZipFile.getName());
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, (IRunnableWithProgress)job);
            } else {
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                service.run(true, true, (IRunnableWithProgress)job);
            }
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e);
            TasksUiInternal.logAndDisplayStatus(Messages.TaskDataExportWizard_export_failed, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.exportPage.saveSettings();
        return true;
    }
}

