/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.query;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.spliterator.SupersSpliterator;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;

public class SupersQuery
extends AbstractQuery<IES6Class> {
    private final ES6ClassSpi m_es6ClassSpi;
    private boolean m_includeSelf = false;
    private boolean m_includeSuperClasses = true;
    private boolean m_includeSuperInterfaces = true;
    private String m_name;

    public SupersQuery(ES6ClassSpi es6Class) {
        this.m_es6ClassSpi = es6Class;
    }

    protected ES6ClassSpi es6Class() {
        return this.m_es6ClassSpi;
    }

    public SupersQuery withSelf(boolean includeSelf) {
        this.m_includeSelf = includeSelf;
        return this;
    }

    protected boolean isIncludeSelf() {
        return this.m_includeSelf;
    }

    public SupersQuery withAllSupers(boolean includeAllSupers) {
        this.m_includeSuperClasses = includeAllSupers;
        this.m_includeSuperInterfaces = includeAllSupers;
        return this;
    }

    public SupersQuery withSuperClasses(boolean includeSuperClasses) {
        this.m_includeSuperClasses = includeSuperClasses;
        return this;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    public SupersQuery withSuperInterfaces(boolean includeSuperInterfaces) {
        this.m_includeSuperInterfaces = includeSuperInterfaces;
        return this;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    public SupersQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String getName() {
        return this.m_name;
    }

    protected boolean test(ES6ClassSpi t) {
        String name = this.getName();
        return name == null || name.equals(t.name());
    }

    protected Stream<IES6Class> createStream() {
        return StreamSupport.stream(new SupersSpliterator(this.es6Class(), this.isIncludeSuperClasses(), this.isIncludeSuperInterfaces(), this.isIncludeSelf()), false).filter(this::test).map(ES6ClassSpi::api);
    }
}

